package dressing.model;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import param.AccessoireInstance;
import param.Article;
import param.MechanicDesign;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.ParamFactory;
import param.PieceType;
import param.Quincaillerie;
import param.QuincaillerieInstance;

public class AccessoiresAndQuicailleriesManger {

	public static void updateAccessoiresAndQuincailleries(DesignObject3D rootspace ,MechanicDesign mechanicdesign,DesignObject3D parentDesign) throws DesignException, GeometricEngineException {
		if(rootspace==null || mechanicdesign==null) {
			return;
		}
		DesignObject3D childsparent=null;
		
		if((mechanicdesign.getType().equals(PieceType.DRESSING)
				||mechanicdesign.getType().equals(PieceType.CAISSON)
				||mechanicdesign.getType().equals(PieceType.SPACE3D)) && (parentDesign==null || parentDesign.getMechanicDesignDefinition()==null)) {
			((Space3DFree) rootspace).getAccessoires().clear();
			((Space3DFree) rootspace).getQuincailleries().clear();
		}
		
		if(mechanicdesign.getType().equals(PieceType.PIECE2D)) {
			childsparent=parentDesign;
		}else if(rootspace instanceof Space3D &&(mechanicdesign.getType().equals(PieceType.SPACE3D) 
				|| mechanicdesign.getType().equals(PieceType.CAISSON)
				|| mechanicdesign.getType().equals(PieceType.DRESSING)
				|| mechanicdesign.getType().equals(PieceType.OBSTACLE)) ) {
			childsparent =rootspace;
		}
		
		buildAccessoiresAndQuincailleries(rootspace, mechanicdesign, mechanicdesign.getPrivateparamgroup().getMechanicprivateparam(),mechanicdesign.getPublicparamgroup().getMechanicpublicparam());

		List<MechanicDesign> childs=new ArrayList<MechanicDesign>();
		childs.addAll(mechanicdesign.getMechanicdesign());
		
		if(childsparent!=null && childsparent.getRootModule()!=null && childsparent.getRootModule() instanceof Space3D && ((Space3D) childsparent.getRootModule()).getDependenceController()!=null
				&&((Space3D) childsparent.getRootModule()).getDependenceController().getChainModel()!=null ) {
			for(MechanicDesign mcdesign :childs)
			{
				DesignObject3D designInstance =((Space3D) childsparent.getRootModule()).getDependenceController().getIntsatanceToDefinition().get(mcdesign);
				updateAccessoiresAndQuincailleries(designInstance, mcdesign, rootspace);
			}
		}
	}
	
	public static void buildAccessoiresAndQuincailleries(DesignObject3D rootspace ,MechanicDesign mechanicdesign,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams) throws DesignException, GeometricEngineException {

		if (mechanicdesign.getAccessoires() != null) {
			if (mechanicdesign.getAccessoires().getAccessoires() != null && mechanicdesign.getAccessoires().getAccessoires().size() > 0) {
				for (AccessoireInstance accessoire : mechanicdesign.getAccessoires().getAccessoires()) {
					if (accessoire != null && accessoire.getAccessoire() != null) {
						ModelAccessoire model = new ModelAccessoire(accessoire);
						model.setId(accessoire.getAccessoire().getModelId());
						model.setName(accessoire.getAccessoire().getName());
						model.constructGenericDebitage(privateparams, publicparams, accessoire, rootspace);
						if ((Boolean) model.get("EXIST")) {
							if (accessoire.isStatic()) {
								model.setNumber(accessoire.getNombreFix());
								((Space3DFree) rootspace.getRoot()).addAccessoire(model);
							} else {
								((Space3DFree) rootspace.getRoot()).addAccessoire(model);
							}
							
							if (accessoire.getAccessoire().getQuincailleries() != null&& accessoire.getAccessoire().getQuincailleries().getQuincailleries() != null&& accessoire.getAccessoire().getQuincailleries().getQuincailleries().size() > 0) {
								EList<QuincaillerieInstance> quincailleries = accessoire.getAccessoire().getQuincailleries().getQuincailleries();
								for (QuincaillerieInstance quincaillerie : quincailleries) {
									if (quincaillerie != null && quincaillerie.getQuincaillerie() != null) {
										ModelQuincaillerie modelquincaillerie = new ModelQuincaillerie(quincaillerie,model);
										modelquincaillerie.setId(quincaillerie.getQuincaillerie().getModelId());
										modelquincaillerie.setName(quincaillerie.getName());
										modelquincaillerie.setNumber(quincaillerie.getNombreFix()*model.getNumber());
										((Space3DFree) rootspace.getRoot()).addQuincaillerie(modelquincaillerie);


									}
								}
							}
						}
					}
				}
			}
		}

		if (mechanicdesign.getQuincailleries() != null) {
			if (mechanicdesign.getQuincailleries().getQuincailleries() != null
					&& mechanicdesign.getQuincailleries().getQuincailleries().size() > 0) {
				for (QuincaillerieInstance quincaillerie : mechanicdesign.getQuincailleries().getQuincailleries()) {
					if (quincaillerie != null && quincaillerie.getQuincaillerie() != null) {
						ModelQuincaillerie model = new ModelQuincaillerie(quincaillerie);
						model.setId(quincaillerie.getQuincaillerie().getModelId());
						model.setName(quincaillerie.getQuincaillerie().getName());
						model.constructGenericDebitage(privateparams, publicparams, quincaillerie, rootspace);
						if((Boolean)model.get("EXIST"))
						{
							if (quincaillerie.isStatic()) {
								model.setNumber(quincaillerie.getNombreFix());
								((Space3DFree) rootspace.getRoot()).addQuincaillerie(model);
							} else {
								((Space3DFree) rootspace.getRoot()).addQuincaillerie(model);
							}

						}
					}
				}
			}
		}
		if(rootspace.equals(rootspace.getRoot())) {
			rootspace.getListPieces().stream().forEach(piece->{
				piece.getFaces().stream().forEach(face->{
					for(AssemblyContainerModel container:face.getAssemblies()) {
						if(face.getChilds().contains(container)
								&& container.getNode()!=null && container.getNode().getAssembly()!=null
								&& container.getNode().getAssembly().getArticle()!=null) {
							Article article= container.getNode().getAssembly().getArticle();
							if(article instanceof Quincaillerie) {
								QuincaillerieInstance instance = ParamFactory.eINSTANCE.createQuincaillerieInstance();
								instance.setName(article.getName());
								instance.setNombreFix(1);
								instance.setQuincaillerie((Quincaillerie) article);
								instance.setStatic(true);
								instance.setShowReport(true);
								ModelQuincaillerie model = new ModelQuincaillerie(instance);
								model.setId(instance.getQuincaillerie().getModelId());
								model.setName(instance.getQuincaillerie().getName());
								model.setNumber(instance.getNombreFix());
								((Space3DFree) rootspace.getRoot()).addQuincaillerie(model);
							}else {
									AccessoireInstance instance = ParamFactory.eINSTANCE.createAccessoireInstance();
									instance.setName(article.getName());
									instance.setNombreFix(1);
									instance.setAccessoire( (param.Accessoire) article);
									instance.setStatic(true);
									instance.setShowReport(true);
									ModelAccessoire model = new ModelAccessoire(instance);
									model.setId(article.getModelId());
									model.setName(article.getName());
									model.setNumber(instance.getNombreFix());
									((Space3DFree) rootspace.getRoot()).addAccessoire(model);
								
							}
							
						}
					}
				});
			});
		}
		
	}
	
}
