package dressing.handlers.catalog;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.UUID;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.SupercadProgressMonitorDialog;
import param.Catalog;

public class ImportCatolgHandler {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	
	@Inject 
	EPartService partService;
	
	@Inject
	IEventBroker eventBroker;
	
	@Execute
	public void execute(Shell shell,ParameterizedCommand command){
		FileDialog dialog = new FileDialog(shell, SWT.OPEN);
		dialog.setFilterExtensions(new String[] { "*.catalog" });
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperDressingProject");
		String defaultpath = projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryread", defaultpath);

			dialog.setFilterPath(dirpath);
			String filepath = dialog.open();
			if (filepath != null && !filepath.isEmpty()) {
				SupercadProgressMonitorDialog progressmonitor =new SupercadProgressMonitorDialog(shell);

				IRunnableWithProgress operation =	new IRunnableWithProgress() {
					
					@Override
					public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					
						// Save the resources to the file system.
						try {
							Catalog cat=ResourceManagers.getIntance().loadCatalog(filepath,true);
							if(cat!=null) {
								Catalog cat1=EcoreUtil.copy(cat);
								cat1.setId(UUID.randomUUID());
								cat1.setCreationDate(new Date());
								ResourceManagers.getIntance().getCatalogs().add(cat1);
								ResourceManagers.getIntance().saveCatalog(cat1);
								eventBroker.send("update_DataModel", ResourceManagers.getIntance().getApplication());
							}else {
								MessageDialog.openError(shell,"Catalog endommagée ", "La Catalog selectionner est endommagée");

							}
							 
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						//save file path to preference for future use
						File file = new File(filepath);
						String dirpath = file.getParent();
						 projectpref.put("directoryread", dirpath);
						 try {
							projectpref.flush();
						 } catch (BackingStoreException e) {
							e.printStackTrace();
						 }
						
					}
				};
				try {
					// This runs the options, and shows progress.
					//
					progressmonitor.run(true, false, operation);

				}
				catch (Exception exception) {
					// Something went wrong that shouldn't.
					//
					exception.printStackTrace();
				}	
				
			}
		
		
	}
	@CanExecute
	public boolean check()
	{
		return true;
	}
}
