package dressing.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import com.badlogic.gdx.Gdx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.io.IOUtilities;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.ProjectManager;
import dressing.ui.SuperCadMessageDialog;
import dressing.ui.util.SupercadProgressMonitorDialog;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import param.MechanicDesign;
import param.MechanicDressing;
import param.Project;

public class ImportProjectDressingHandler {

	@Execute
	public void execute(Shell shell) {
		FileDialog dialog = new FileDialog(shell, SWT.OPEN);
		dialog.setFilterExtensions(new String[] { "*.dress" });
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperDressingProject");
		String defaultpath = projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryread", defaultpath);

		dialog.setFilterPath(dirpath);
		String filepath = dialog.open();
		if (filepath != null && !filepath.isEmpty()) {
			File f = new File(filepath);
			
			///
			importProject(shell, f, filepath);
			dirpath = f.getParent();
			projectpref.put("directoryread", dirpath);
			try {
				projectpref.flush();
			} catch (BackingStoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	
	public void importProject(final Shell shell,File file,String filepath) {
		SupercadProgressMonitorDialog progressmonitor = new SupercadProgressMonitorDialog(shell,
				"Ouverture du projet en cours");

		IRunnableWithProgress operation = new IRunnableWithProgress() {

			@Override
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {

				Date deb = new Date();
				try {
					monitor.beginTask("Chargement du projet " ,IProgressMonitor.UNKNOWN);
					String projectName = file.getName();
					int indexextension = projectName.lastIndexOf(".dress");
					if (indexextension > 0) {
						projectName = projectName.substring(0, indexextension);
					}
					String tmpfolder = WorkspaceConfiguration.getProjectsPath() + File.separator + "tmp";
					File fTmpFolder = new File(tmpfolder);
					if (!fTmpFolder.exists()) {
						fTmpFolder.mkdirs();
						System.err.println(fTmpFolder.setExecutable(true));
						System.err.println(fTmpFolder.setReadable(true));
						System.err.println(fTmpFolder.setWritable(true, false));
					}
					String path = tmpfolder + File.separator + projectName;
					File f1 = new File(path);
					if(f1.exists())
					{
						IOUtilities.deleteFolder(f1);
					}
					String unzippedFilePath =IOUtilities.UnzipFile(filepath, tmpfolder);
					if(unzippedFilePath!=null) {
						path=unzippedFilePath;
						projectName=new File(path).getName();
					}
					System.err.println("exist "+f1.exists());
						
					String rootDir= WorkspaceConfiguration.getProjectsPath()+ File.separator +projectName;
					File frootDir = new File(rootDir);
					if(frootDir.exists())
					{
						IOUtilities.deleteFolder(frootDir);
					}
					Project project=readProjectfromDisk(path,true);
					if(project!=null) {
						monitor.done();
						monitor.beginTask("Ouverture du projet: "+projectName ,IProgressMonitor.UNKNOWN);
						openProjectDressing(project,path);
						monitor.done();
						//
						monitor.beginTask("Consrtuction des dressings: "+projectName ,IProgressMonitor.UNKNOWN);
						List<DesignObject3D> dressings = buildDressings(project);
						monitor.done();
						monitor.beginTask("Consrtuction des models 3D: "+projectName ,IProgressMonitor.UNKNOWN);

						for(DesignObject3D designObject:dressings ) {
							ProjectManager.getManager().getCurrentKitchen().addElement(designObject);
							WorldObject object = WorldObjectFactory.getFactory().createObjectFromDefinition(designObject);
							((AbstractScreen) Scene.game.getScreen()).getController().dropActor(object,
									Gdx.graphics.getWidth()/2, Gdx.graphics.getHeight()/2 );
						}
						monitor.done();
						//
						File tmpFilepath=new File(path);
						if(tmpFilepath.exists()) {
							IOUtilities.deleteFolder(tmpFilepath);

						}
						SuperCadMessageDialog.openMessage(MessageDialog.INFORMATION,progressmonitor.getShell(),"Succèes", "La projet est ajouter avec succèes");
					}else {
						SuperCadMessageDialog.openMessage(MessageDialog.ERROR,progressmonitor.getShell(),"Projet endommagée ", "La projet selectionner est endommagée ou créer avec la version 1.0\n essayer d'ouvrir avec la version 1.0 \n");

					}
					
				} catch (Exception e) {
					e.printStackTrace();
					SuperCadMessageDialog.openMessage(MessageDialog.ERROR,progressmonitor.getShell(),"Projet endommagée ", "La projet selectionner est endommagée ou créer avec la version 1.0 \n essayer d'ouvrir avec la version 1.0 \n erreur lors de chargement");
				}

				System.err.println("********time to update****" + (new Date().getTime() - deb.getTime()));
			}

			
		};
		try {
			// This runs the options, and shows progress.
			//

			progressmonitor.run(true, false, operation);

		} catch (Exception exception) {
			// Something went wrong that shouldn't.
			//
			exception.printStackTrace();
		}
	}
	public Project readProjectfromDisk(String rootDir, boolean iscreate) throws FileNotFoundException {
		Project project = null;
		File projFile=new File(rootDir + "//project.xml");
			if(projFile!=null&& projFile.exists()) {
				Resource resource = ResourceManagers.getIntance().loadResource(URI.createFileURI(projFile.getAbsolutePath()),iscreate,ResourceManagers.getIntance().getGestionResourceSet());
				if(resource!=null && resource.getContents()!=null ) {
					 for(Object obj: resource.getContents()) {
						 if(obj instanceof Project)
						 {
							 project= (Project) obj;
						 }
					 }
				}
			}

		return project;
	}
	public void openProjectDressing(Project project,String path) {
		File file = new File(path);
		if(file.exists()) {
			String[] directories = file.list(new FilenameFilter() {
				  @Override
				  public boolean accept(File current, String name) {
				    return new File(current, name).isDirectory();
				  }
				});

				for (String directory : directories) {
					String rootDir = path + "//" + directory;
					File dressingDir = new File(rootDir);
					File dressingFile = null;
					if (dressingDir.exists()) {
						File[] files = dressingDir.listFiles();
						if (files != null && files.length > 0) {
							for (File file1 : files) {
								if (file1.getName() != null && file1.getName().endsWith(".xml")) {
									dressingFile = file1;
									break;
								}
							}
						}
						if (dressingFile != null && dressingFile.exists()) {
							try {
								MechanicDressing dressing = readDressingfromDisk(dressingFile.getAbsolutePath());
								if (dressing != null) {
									project.getDressings().add(dressing);
								}
							} catch (FileNotFoundException e) {
								e.printStackTrace();
							}
						}

					}
				}
		}
		System.gc();
	}
	public MechanicDressing readDressingfromDisk(String rootDir) throws FileNotFoundException {
		MechanicDressing dressing = null;
		
		File projFile=new File(rootDir);
			if(projFile!=null&& projFile.exists()) {
				Resource resource = ResourceManagers.getIntance().loadResource(URI.createFileURI(projFile.getAbsolutePath()),false);
				if(resource!=null && resource.getContents()!=null ) {
					 for(Object obj: resource.getContents()) {
						 if(obj instanceof MechanicDressing)
						 {
							 dressing= (MechanicDressing) obj;
						 }
					 }
					 EcoreUtil.resolveAll(resource);
				}
				
			}

		return dressing;
	}
	public List<DesignObject3D> buildDressings(Project project) {
		List<DesignObject3D> dressings=new ArrayList<DesignObject3D>();
		if(project.getDressings()!=null && !project.getDressings().isEmpty()) {
			for(MechanicDesign md: project.getDressings()) {
				try {
					DesignObject3D designobject = MechanicDesignCreator.getInstance().constructObject(md, MechanicDesignCreator.open);
					dressings.add(designobject);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					SuperCadMessageDialog.openMessage(MessageDialog.ERROR,Display.getCurrent().getActiveShell(), "un erreur est servenue", e.getMessage());
				}
			}
		}
		return dressings;
	}
}
