package dressing.config.persistence;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.frs.dressing.parameters.ui.UiInjectorProvider;

import com.google.inject.Injector;

import dressing.config.WorkspaceConfiguration;
import dressing.io.FileSearch;
import dressing.model.ModelProvider;
import dressing.profiling.TimeProfiler;
import param.AccessoireGroup;
import param.Application;
import param.ArticleFamilyGroup;
import param.AssemblyGroup;
import param.AssemblySystemGroup;
import param.CalculEnginePref;
import param.Catalog;
import param.ChantGroup;
import param.EngineStrategy;
import param.Gestion;
import param.Material;
import param.MaterialGroup;
import param.MaterialTypeGroup;
import param.ModelRoot;
import param.Organisation;
import param.ParamFactory;
import param.Preference;
import param.QuincaillerieGroup;
import param.TypeDef;
import param.Utilities;
import param.util.ParamResourceFactoryImpl;

public class ResourceManagers {
	public static final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
	ResourceSet resSet =null;
	List<Resource> librariesresources=new ArrayList<Resource>();
	Resource libraryresource=null;
	Resource appResource=null;
	Resource configurationPreferenceResource=null;
	Resource companyResource=null;

	Resource accessoireResource=null;
	Resource quincailleriesResource=null;
	Resource articlesFamiliesResource=null;
	Resource assemblyGroupResource=null;
	Resource assemblySystemsGroupResource=null;
	Resource kitchenLibraryUtilitiesResource=null;

	Resource materialResource=null;

	Resource systemMaterialResource=null;
	
	Resource materialTypesResource=null;
	Resource chantsResource=null;

	private static ResourceManagers instance;
	private URI libraryUri = URI.createFileURI(WorkspaceConfiguration.getLibraryPath());
	private Injector injector = UiInjectorProvider.getInjector();
	// The EditingDomain is needed for context menu and drag and drop
	EditingDomain editingDomain = injector.getInstance(EditingDomain.class);

	ResourceLoader resourceLoader = injector.getInstance(ResourceLoader.class);
	private ModelRoot modelroot;
	private  List<ModelRoot> modelroots=new ArrayList<ModelRoot>();
	private List<Catalog> catalogs=new ArrayList<Catalog>();
	private Application application;
	private AccessoireGroup accessoireGroup=null;
	private QuincaillerieGroup quincailleriesGroup=null;
	private AssemblyGroup assemblyGroup=null;
	private AssemblySystemGroup assemblySystemGroup=null;
	private Utilities kitchenLibraryUtilities;

	private Preference preference;
	private Organisation company;
	
	private MaterialGroup materialgroup;
	
	private MaterialGroup systemMaterialgroup;
	private MaterialTypeGroup materialTypes;
	private ChantGroup chants;
	private ArticleFamilyGroup artFamGroup;
	
	private Gestion gestion;
	private Resource gestionResource=null;
	private DynamicTypeManager dynamicTypeManager;
    /** Cache for fast TypeDef lookup by name */
    private final Map<String, TypeDef> typeCache = new HashMap<>();
	private ResourceSet gestionResourceSet;
	private boolean inited=false;
	public ResourceManagers() {
		super();
		TimeProfiler.getInstance().start("ResourceManagers initialisation");
		saveOptions.put(Resource.OPTION_SAVE_ONLY_IF_CHANGED, Resource.OPTION_SAVE_ONLY_IF_CHANGED_MEMORY_BUFFER);
		saveOptions.put(XMLResource.OPTION_PROCESS_DANGLING_HREF, XMLResource.OPTION_PROCESS_DANGLING_HREF_DISCARD);
		initLibrary();
		
		TimeProfiler.getInstance().stop("ResourceManagers initialisation");
	}

	public synchronized static ResourceManagers getIntance() {
		synchronized(ResourceManagers.class) {
			if (instance == null) {
				instance = new ResourceManagers();
			}
			return instance;
		}
	}

	public void initLibrary() {
		if ((this.librariesresources == null || librariesresources.isEmpty()) && !this.inited) {
			long debut =new Date().getTime();

			ParamResourceFactoryImpl resourcefactory=new ParamResourceFactoryImpl();
			Map<String, Object> extensionToFactoryMap=new HashMap<String, Object>();
			this.resSet = editingDomain.getResourceSet();
			Resource.Factory.Registry  ResourceFactoryRegistry =this.resSet.getResourceFactoryRegistry();
			extensionToFactoryMap.put("xmi",resourcefactory);
			extensionToFactoryMap.put("library",resourcefactory);
			extensionToFactoryMap.put("xml",resourcefactory);
			extensionToFactoryMap.put("catalog",resourcefactory);//les catalog files
			extensionToFactoryMap.put("org",resourcefactory);//Organization config file
			extensionToFactoryMap.put("app",resourcefactory);//application config file
			extensionToFactoryMap.put("config",resourcefactory);//application config file
			extensionToFactoryMap.put("params",resourcefactory);//parameters config file
			extensionToFactoryMap.put("pref",resourcefactory);//Preference config file		
			extensionToFactoryMap.put("sdress",resourcefactory);//Preference config file		
			extensionToFactoryMap.put("data",resourcefactory);//Accesoires data file		
			extensionToFactoryMap.put("type",resourcefactory);//Accesoires data file
			
			ResourceFactoryRegistry.getExtensionToFactoryMap().putAll(extensionToFactoryMap);
			((ResourceSetImpl)editingDomain.getResourceSet()).setURIResourceMap(new HashMap<URI, Resource>());
			
			Map<Object, Object> options = editingDomain.getResourceSet().getLoadOptions();
			options.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
			options.put(XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE);
			options.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
			options.put(XMLResource.OPTION_PROCESS_DANGLING_HREF, XMLResource.OPTION_PROCESS_DANGLING_HREF_DISCARD);
			
			loadLibraries();
			
			gestionResourceSet = new ResourceSetImpl();
			gestionResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().putAll(extensionToFactoryMap);
			gestionResourceSet.getLoadOptions().putAll(options);
			
			long endparams =new Date().getTime();
			System.err.println("end load ModelParam.library\t" +(endparams-debut));
			gereParameters();
			loadConfigResources();
			this.inited = true;
//			long end =new Date().getTime();
//			System.err.println(end-debut);
		}
		
	}
	
	public void loadConfigResources() {
		TimeProfiler.getInstance().start("load data");
		loadApplicationConfig();
		this.dynamicTypeManager = new DynamicTypeManager(getApplication());
		loadDynamicTypes();
		this.dynamicTypeManager.init();
		loadAccessoireData();
		loadQuincailleriesData();
		loadarticlesFamiliesData();
		loadAssembliesData();
		loadAssemblySystemsData();
		loadKitchenLibraryUtilitiesData();
		loadGestionData();
		loadMaterialsData();
		loadMaterialTypesData();
		loadChantsData();
		loadSystemMaterialsData();
		loadCompanyConfig();
		loadAppPreference();
		loadCatalogs();
		TimeProfiler.getInstance().stop("load data");
	}
	public void loadLibraries() {
		String[] files =FileSearch.getFiles(WorkspaceConfiguration.getLibrariesPath(), true, new String[]{".library"},false);
		getLibrariesresources().clear();
		for (String filename : files) {
			TimeProfiler.getInstance().start("load libraries");
			File file = new File(filename);
			URI libraryUri = URI.createFileURI(file.getAbsolutePath());
			Resource library =resourceLoader.getResource(editingDomain, libraryUri).getResource();
			if (library != null)
			{
				getLibrariesresources().add(library);				
			}
			TimeProfiler.getInstance().stop("load libraries");
			TimeProfiler.getInstance().start("load library");
			this.libraryresource = resourceLoader.getResource(editingDomain, libraryUri).getResource();
			TimeProfiler.getInstance().stop("load library");
		}

	}
	
	public void resolveDependency(){
		EcoreUtil.resolveAll(getResSet());
		saveLibraryResource();
	}
	public Application loadApplicationConfig() {
		File file=new File(WorkspaceConfiguration.APP_CONFIG);
		URI uri=URI.createFileURI(file.getAbsolutePath());
		appResource =loadResource(uri,!file.exists());
		
		if(appResource.getContents()!=null &&!appResource.getContents().isEmpty()) {
			for (Object obj : appResource.getContents()) {
				if (obj instanceof Application) {
					Application app = (Application) obj;
					app.getKitchenLibraries().clear();
					app.getKitchenLibraries().addAll(getModelroots());
					setApplication(app);
					saveApplication();
					
					return app;
				}
			}
		}else {
			Application app=getDefaultApplication();
			appResource.getContents().clear();
			appResource.getContents().add(app);
			app.getKitchenLibraries().addAll(getModelroots());
			setApplication(app);
			saveApplication();
			
		}
		return null;
	}
	public Organisation loadCompanyConfig() {
		this.company =getApplication().getOrganisation();
		if(company==null || company.eIsProxy()) {
			File file=new File(WorkspaceConfiguration.COMPANY_CONFIG);
			URI uri=URI.createFileURI(file.getAbsolutePath());
			companyResource =loadResource(uri,!file.exists(),gestionResourceSet);
			
			if(companyResource.getContents()!=null &&!companyResource.getContents().isEmpty()) {
				for (Object obj : companyResource.getContents()) {
					if (obj instanceof Organisation) {
						Organisation app = (Organisation) obj;
						setCompany(app);
						getApplication().setOrganisation(app);
						saveApplication();
						return app;
					}
				}
			}else {
				Organisation company=getApplication().getOrganisation();
				if(company==null) {
					company=ParamFactory.eINSTANCE.createOrganisation();
				}
				companyResource.getContents().clear();
				companyResource.getContents().add(company);
				setCompany(company);
				saveCompanyConfig();
				saveApplication();
				return company;
				
			}
		}else {
			companyResource = this.company.eResource();
		}
		
		return null;
	}
	
	public void setCompany(Organisation company) {
		this.company = company;
	}

	public Preference loadAppPreference() {
		this.preference = getApplication().getPreferences();
		if(this.preference==null || this.preference.eIsProxy()) {
			File file=new File(WorkspaceConfiguration.APP_PREFERENCE);
			URI uri=URI.createFileURI(file.getAbsolutePath());
			configurationPreferenceResource =loadResource(uri,!file.exists(),gestionResourceSet);
			if(configurationPreferenceResource.getContents()!=null &&!configurationPreferenceResource.getContents().isEmpty()) {
				for (Object obj : configurationPreferenceResource.getContents()) {
					if (obj instanceof Preference) {
						Preference pref = (Preference) obj;
						setPreference(pref);
						getApplication().setPreferences(pref);
						saveApplication();
						return pref;
					}
				}
			} else {
				this.preference = getApplication().getPreferences();
				if(preference==null) {
					this.preference=ParamFactory.eINSTANCE.createPreference();
				}
				configurationPreferenceResource.getContents().clear();
				configurationPreferenceResource.getContents().add(preference);
				getApplication().setPreferences(preference);
				saveResource(preference, WorkspaceConfiguration.getConfigurationPreferencePath());
				saveApplication();
				return preference;
			}
		}else {
			configurationPreferenceResource = this.preference.eResource();
		}
		
		
		
		return null;
	}
	public void saveAppPreference() {
		saveResource(getPreference(), WorkspaceConfiguration.getConfigurationPreferencePath());
	}
	public void saveCompanyConfig() {
		saveResource(getCompany(), WorkspaceConfiguration.COMPANY_CONFIG);
	}
	public void setPreference(Preference preference) {
		this.preference = preference;
	}

	public Preference getPreference() {
		if(preference==null) {
			if(getApplication().getPreferences()!=null) {
				preference=getApplication().getPreferences();
			}else
			{
				preference=	loadAppPreference();
			}
		}
		return preference;
	}
	public CalculEnginePref getCalculEnginePrefs() {
		if(getPreference().getCalculEnginePrefs()==null) {
			getPreference().setCalculEnginePrefs(ParamFactory.eINSTANCE.createCalculEnginePref());
		}
		return getPreference().getCalculEnginePrefs();
	}
	public EngineStrategy getPieceCollistionStrategy() {
		return getCalculEnginePrefs().getPieceCollusion();
	}
	public void loadAccessoireData() {
		accessoireGroup =getApplication().getAccesoires();
		if(accessoireGroup==null || accessoireGroup.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getAccessoiresPath());
		    URI uri = URI.createFileURI(file.getAbsolutePath());
		    accessoireResource = loadResource(uri, !file.exists());
		    if (accessoireResource.getContents() != null && !accessoireResource.getContents().isEmpty()) {
		        Object firstObject = accessoireResource.getContents().get(0);

		        if (firstObject instanceof AccessoireGroup) {
		            AccessoireGroup accessoireGroup = (AccessoireGroup) firstObject;

		            getApplication().setAccesoires(accessoireGroup);
		            saveApplication();
		            this.accessoireGroup = accessoireGroup;
		        }
		    }else {
				if (accessoireGroup == null) {
					accessoireGroup = ParamFactory.eINSTANCE.createAccessoireGroup();
				}
				accessoireResource.getContents().clear();
				accessoireResource.getContents().add(accessoireGroup);
				getApplication().setAccesoires(accessoireGroup);
				saveResource(accessoireResource);
				saveApplication();
		    }
		}
	    else {
	    	 accessoireResource=accessoireGroup.eResource();
	    }
	}
	public void loadarticlesFamiliesData() {
		artFamGroup =getApplication().getArticleFamilies();
		if(artFamGroup==null || artFamGroup.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getARTICLE_FAMILIES());
		    URI uri = URI.createFileURI(file.getAbsolutePath());
		    articlesFamiliesResource = loadResource(uri, !file.exists());
		    if (articlesFamiliesResource.getContents() != null && !articlesFamiliesResource.getContents().isEmpty()) {
		        Object firstObject = articlesFamiliesResource.getContents().get(0);

		        if (firstObject instanceof ArticleFamilyGroup) {
		            ArticleFamilyGroup artFamGroup = (ArticleFamilyGroup) firstObject;

		            getApplication().setArticleFamilies(artFamGroup);
		            saveApplication();
		            this.artFamGroup = artFamGroup;
		        }
		    }else {
				if (artFamGroup == null) {
					artFamGroup = ParamFactory.eINSTANCE.createArticleFamilyGroup();
				}
				articlesFamiliesResource.getContents().clear();
				articlesFamiliesResource.getContents().add(artFamGroup);
				getApplication().setArticleFamilies(artFamGroup);
				saveResource(articlesFamiliesResource);
				saveApplication();
		    }
		}
	    else {
	    	articlesFamiliesResource=artFamGroup.eResource();
	    }
	}
	public AccessoireGroup getAccessoireGroup() {
		if(accessoireGroup==null) {
			loadAccessoireData();
		}
		return accessoireGroup;
	}

	public void loadQuincailleriesData() {
		this.quincailleriesGroup =getApplication().getQuincailleries();
		if(this.quincailleriesGroup==null || quincailleriesGroup.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getQuincailleriesPath());
		    URI uri = URI.createFileURI(file.getAbsolutePath());

		    quincailleriesResource = loadResource(uri, !file.exists());
		    if (quincailleriesResource.getContents() != null && !quincailleriesResource.getContents().isEmpty()) {
		        Object firstObject = quincailleriesResource.getContents().get(0);

		        if (firstObject instanceof QuincaillerieGroup) {
		            QuincaillerieGroup quincailleriesGroup = (QuincaillerieGroup) firstObject;

		            getApplication().setQuincailleries(quincailleriesGroup);
		            saveApplication();
		            this.quincailleriesGroup = quincailleriesGroup;
		        }
		    } else {
		    	if (quincailleriesGroup == null) {
		    		quincailleriesGroup = ParamFactory.eINSTANCE.createQuincaillerieGroup();
				}
		    	quincailleriesResource.getContents().clear();
		        quincailleriesResource.getContents().add(quincailleriesGroup);
		        getApplication().setQuincailleries(quincailleriesGroup);
		        saveResource(quincailleriesResource);
		        saveApplication();
		    }
		}
		else {
			quincailleriesResource=quincailleriesGroup.eResource();
	    }

	    
	}
	
	
	public QuincaillerieGroup getQuincailleriesGroup() {
		if(quincailleriesGroup==null) {
			loadQuincailleriesData();
		}
		return quincailleriesGroup;
	}
	
	//
	public void loadAssembliesData() {
		this.assemblyGroup = getApplication().getAssemblies();
		if (this.assemblyGroup == null || assemblyGroup.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getAssembliesPath());
			URI uri = URI.createFileURI(file.getAbsolutePath());
			
			assemblyGroupResource = loadResource(uri, !file.exists());
			if (assemblyGroupResource.getContents() != null && !assemblyGroupResource.getContents().isEmpty()) {
				Object firstObject = assemblyGroupResource.getContents().get(0);
				
				if (firstObject instanceof AssemblyGroup) {
					AssemblyGroup assemblyGroup = (AssemblyGroup) firstObject;
					
					getApplication().setAssemblies(assemblyGroup);
					saveApplication();
					this.assemblyGroup = assemblyGroup;
				}
			} else {
				if (assemblyGroup == null) {
					assemblyGroup = ParamFactory.eINSTANCE.createAssemblyGroup();
				}
				assemblyGroupResource.getContents().clear();
				assemblyGroupResource.getContents().add(assemblyGroup);
				getApplication().setAssemblies(assemblyGroup);
				saveResource(assemblyGroupResource);
				saveApplication();
			}
		} else {
			assemblyGroupResource = assemblyGroup.eResource();
		}
		
	}
	
	//
	public AssemblyGroup getAssembliesGroup() {
		if(assemblyGroup==null) {
			loadAssembliesData();
		}
		return assemblyGroup;
	}
	//
	public void loadAssemblySystemsData() {
		this.assemblySystemGroup = getApplication().getAssemblySystems();
		if (this.assemblySystemGroup == null || assemblySystemGroup.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getAssemblySystemsPath());
			URI uri = URI.createFileURI(file.getAbsolutePath());
			
			assemblySystemsGroupResource = loadResource(uri, !file.exists());
			if (assemblySystemsGroupResource.getContents() != null && !assemblySystemsGroupResource.getContents().isEmpty()) {
				Object firstObject = assemblySystemsGroupResource.getContents().get(0);
				
				if (firstObject instanceof AssemblySystemGroup) {
					AssemblySystemGroup assemblySystemGroup = (AssemblySystemGroup) firstObject;
					
					getApplication().setAssemblySystems(assemblySystemGroup);
					saveApplication();
					this.assemblySystemGroup = assemblySystemGroup;
				}
			} else {
				if (assemblySystemGroup == null) {
					assemblySystemGroup = ParamFactory.eINSTANCE.createAssemblySystemGroup();
				}
				assemblySystemsGroupResource.getContents().clear();
				assemblySystemsGroupResource.getContents().add(assemblySystemGroup);
				getApplication().setAssemblySystems(assemblySystemGroup);
				saveResource(assemblySystemsGroupResource);
				saveApplication();
			}
		} else {
			assemblySystemsGroupResource = assemblySystemGroup.eResource();
		}
		
	}
	//
	public AssemblySystemGroup getAssemblySystemGroup() {
		if(assemblySystemGroup==null) {
			loadAssemblySystemsData();
		}
		return assemblySystemGroup;
	}
	//
	public void loadKitchenLibraryUtilitiesData() {
		kitchenLibraryUtilities = getApplication().getUtilities();
		if (kitchenLibraryUtilities == null || kitchenLibraryUtilities.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getKitchenLibraryUtilitiesPath());
			URI uri = URI.createFileURI(file.getAbsolutePath());
			
			kitchenLibraryUtilitiesResource = loadResource(uri, !file.exists());
			if (kitchenLibraryUtilitiesResource.getContents() != null && !kitchenLibraryUtilitiesResource.getContents().isEmpty()) {
				Object firstObject = kitchenLibraryUtilitiesResource.getContents().get(0);
				
				if (firstObject instanceof Utilities) {
					kitchenLibraryUtilities = (Utilities) firstObject;
					
					getApplication().setUtilities(kitchenLibraryUtilities);
					saveApplication();
				}
			} else {
				if (kitchenLibraryUtilities == null) {
					kitchenLibraryUtilities = ParamFactory.eINSTANCE.createUtilities();
				}
				kitchenLibraryUtilitiesResource.getContents().clear();
				kitchenLibraryUtilitiesResource.getContents().add(kitchenLibraryUtilities);
				getApplication().setUtilities(kitchenLibraryUtilities);
				saveResource(kitchenLibraryUtilitiesResource);
				saveApplication();
			}
		} else {
			kitchenLibraryUtilitiesResource = kitchenLibraryUtilities.eResource();
		}
		
	}
	//
	public Utilities getKitchenLibraryUtilities() {
		if(kitchenLibraryUtilities==null) {
			loadKitchenLibraryUtilitiesData();
		}
		return kitchenLibraryUtilities;
	}
	//
	public void loadMaterialsData() {
		materialgroup = getApplication().getMaterialgroup();
		if (materialgroup == null || materialgroup.eIsProxy()) {
			if (getModelroot().getMaterialgroup() != null) {
				materialgroup = getModelroot().getMaterialgroup();
				materialResource=materialgroup.eResource();
			} else {
				File file = new File(WorkspaceConfiguration.getMaterialsPath());
				URI uri = URI.createFileURI(file.getAbsolutePath());

				materialResource = loadResource(uri, !file.exists());
				if (materialResource.getContents() != null && !materialResource.getContents().isEmpty()) {
					Object firstObject = materialResource.getContents().get(0);

					if (firstObject instanceof MaterialGroup) {
						MaterialGroup materialGroup = (MaterialGroup) firstObject;

						getApplication().setMaterialgroup(materialGroup);
						saveApplication();
						this.materialgroup = materialGroup;
					}
				} else {
					if (materialgroup == null) {
						materialgroup = ParamFactory.eINSTANCE.createMaterialGroup();		
					}
					getApplication().setMaterialgroup(materialgroup);
					materialResource.getContents().clear();
					materialResource.getContents().add(materialgroup);
					saveResource(materialResource);
					saveApplication();
				}
			}
			
		}else {
			materialResource=materialgroup.eResource();
		}
	}
	
	public MaterialGroup getMaterialGroup() {
		if(materialgroup==null) {
			loadMaterialsData();
		}
		return materialgroup;
	}
	
	//
	public List<Material> getMaterials(){
		List<Material> materials=new ArrayList<Material>();
		materials.addAll(getSystemMaterialGroup().getMaterial());
		materials.addAll(getMaterialGroup().getMaterial());
		materials.sort(new Comparator<Material>() {
			@Override
			public int compare(Material o1, Material o2) {
				return o1.getName().compareTo(o2.getName());
			}
			
		});
		return materials;
	}
	//
	public void loadSystemMaterialsData() {

		File file = new File(WorkspaceConfiguration.getSystemMaterialsPath());
		URI uri = URI.createFileURI(file.getAbsolutePath());

		systemMaterialResource = loadResource(uri, !file.exists());
		if (systemMaterialResource.getContents() != null && !systemMaterialResource.getContents().isEmpty()) {
			Object firstObject = systemMaterialResource.getContents().get(0);

			if (firstObject instanceof MaterialGroup) {
				MaterialGroup materialGroup = (MaterialGroup) firstObject;
				this.systemMaterialgroup = materialGroup;
			}
		} else {
			if (systemMaterialgroup == null) {
				systemMaterialgroup = ParamFactory.eINSTANCE.createMaterialGroup();
			}
			systemMaterialResource.getContents().clear();
			systemMaterialResource.getContents().add(systemMaterialgroup);
			saveResource(systemMaterialResource);
		}
//		
//		systemMaterialgroup.getMaterial().stream().forEach(mat ->{
////			
//			 Path path1 = Paths.get(mat.getImage());
//			 if(path1.isAbsolute()) {
//				 mat.setImage(path1.getFileName().toString());
//			 }
//		});
//		saveResource(systemMaterialResource);
	}
	
	public MaterialGroup getSystemMaterialGroup() {
		if(systemMaterialgroup==null) {
			loadSystemMaterialsData();
		}
		return systemMaterialgroup;
	}
	//
	public void loadMaterialTypesData() {
		this.materialTypes = getApplication().getMaterialType();
		if(this.materialTypes==null || this.materialTypes.eIsProxy()) {
			File file=new File(WorkspaceConfiguration.getMaterialsTypesPath());
			URI uri=URI.createFileURI(file.getAbsolutePath());
			materialTypesResource =loadResource(uri,!file.exists());
			
		    if (materialTypesResource.getContents() != null && !materialTypesResource.getContents().isEmpty()) {
		        Object firstObject = materialTypesResource.getContents().get(0);

		        if (firstObject instanceof MaterialTypeGroup) {
		            MaterialTypeGroup materialGroup = (MaterialTypeGroup) firstObject;

		            getApplication().setMaterialType(materialGroup);
		            saveApplication();
		            this.materialTypes = materialGroup;
		        }
		    } else {

		        if (materialTypes == null) {
		        	materialTypes = ParamFactory.eINSTANCE.createMaterialTypeGroup();
		        }
				
				materialTypesResource.getContents().clear();
				materialTypesResource.getContents().add(materialTypes);
				
				getApplication().setMaterialType(materialTypes);
				saveResource(materialTypesResource);
				saveApplication();
			}
		}
		else {
			materialTypesResource=materialTypes.eResource();
	    }
		
	}
	
	public MaterialTypeGroup getMaterialTypesGroup() {
		if(materialTypes==null) {
			loadMaterialTypesData();
		}
		return materialTypes;
	}
	//
	public Gestion getGestion() {
		if(gestion==null) {
			loadGestionData();
		}
		return gestion;
	}
	//
	public void loadGestionData() {
		this.gestion =getApplication().getGestion();
		if(this.gestion==null || gestion.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getGestionsPath());
		    URI uri = URI.createFileURI(file.getAbsolutePath());

		    gestionResource = loadResource(uri, !file.exists());
		    if (gestionResource.getContents() != null && !gestionResource.getContents().isEmpty()) {
		        Object firstObject = gestionResource.getContents().get(0);

		        if (firstObject instanceof Gestion) {
		        	Gestion gestion = (Gestion) firstObject;

		            getApplication().setGestion(gestion);
		            saveApplication();
		            this.gestion = gestion;
		        }
		    } else {
		    	if (gestion == null) {
		    		gestion = ParamFactory.eINSTANCE.createGestion();
				}
		    	gestionResource.getContents().clear();
		    	gestionResource.getContents().add(gestion);
	            getApplication().setGestion(gestion);
		        saveResource(gestionResource);
		        saveApplication();
		    }
		}
		else {
			gestionResource=gestion.eResource();
	    }
	}
	public void saveGestion() {
		saveResource(gestionResource);
	}
	//
	public void loadChantsData() {
		this.chants=getApplication().getChantgroup();
		if(this.chants==null || chants.eIsProxy()) {
			File file = new File(WorkspaceConfiguration.getChantsPath());
			URI uri = URI.createFileURI(file.getAbsolutePath());

			chantsResource = loadResource(uri, !file.exists());
			if (chantsResource.getContents() != null && !chantsResource.getContents().isEmpty()) {
				Object firstObject = chantsResource.getContents().get(0);

				if (firstObject instanceof ChantGroup) {
					ChantGroup chantGroup = (ChantGroup) firstObject;

					getApplication().setChantgroup(chantGroup);
					saveApplication();
					this.chants = chantGroup;
				}
			} else {
				ChantGroup chantGroup = getApplication().getChantgroup();

				if (chantGroup == null) {
					chantGroup = ParamFactory.eINSTANCE.createChantGroup();
				}

				chantsResource.getContents().clear();
				chantsResource.getContents().add(chantGroup);

				getApplication().setChantgroup(chantGroup);
				saveResource(chantsResource);
				saveApplication();
				this.chants = chantGroup;
			}
		}else {
			chantsResource=chants.eResource();
		}
	   
	}

	
	public ChantGroup getChants() {
		if( chants==null) {
			loadChantsData();
		}
		return chants;
	}

	//
	public Organisation getDefaultOrganisation() {
		Organisation org =ParamFactory.eINSTANCE.createOrganisation();
		org.setCreationDate(new Date());
		org.setModificationDate(new Date());
		org.setId(UUID.randomUUID());
		org.setName("FRS");
		org.setRaisonSocial("For Right Solutions");
		org.setClients(ParamFactory.eINSTANCE.createClientGroup());
		org.setSites(ParamFactory.eINSTANCE.createSiteGroup());
		org.setUsers(ParamFactory.eINSTANCE.createUserGroup());
		org.setUserStatus(ParamFactory.eINSTANCE.createUserStatusGroup());
		return org;
	}
	public Application getDefaultApplication() {
		File file=new File(System.getenv("ProgramData") + File.separator + "superDressing"+File.separator + "Data"
				+ File.separator +"app.config");
		URI uri=URI.createFileURI(file.getAbsolutePath());
		Resource appResource =loadResource(uri,!file.exists());
		if(appResource!=null && appResource.getContents()!= null&&appResource.getContents().size()>0 ) {
			if (appResource.getContents().get(0) instanceof Application) {
				Application application = (Application) appResource.getContents().get(0);
				Application app=ParamFactory.eINSTANCE.createApplication();
				app.setAccesoires(application.getAccesoires());
				app.setQuincailleries(application.getQuincailleries());
				app.setArticleFamilies(application.getArticleFamilies());
				app.setMaterialgroup(application.getMaterialgroup());
				app.setParametersgroups(ParamFactory.eINSTANCE.createParametersGroups());
				app.setPreferences(application.getPreferences());
				app.setOrganisation(application.getOrganisation());
				app.setChantgroup(application.getChantgroup());
				app.setMaterialType(application.getMaterialType());
				
				return app;
			}
		}else {
			Application app=ParamFactory.eINSTANCE.createApplication();
			app.setAccesoires(ParamFactory.eINSTANCE.createAccessoireGroup());
			app.setQuincailleries(ParamFactory.eINSTANCE.createQuincaillerieGroup());
			app.setArticleFamilies(ParamFactory.eINSTANCE.createArticleFamilyGroup());
			app.setMaterialgroup(ParamFactory.eINSTANCE.createMaterialGroup());
			app.setParametersgroups(ParamFactory.eINSTANCE.createParametersGroups());
			app.setPreferences(ParamFactory.eINSTANCE.createPreference());
			app.setOrganisation(getDefaultOrganisation());
			app.setChantgroup(ParamFactory.eINSTANCE.createChantGroup());
			app.setMaterialType(application.getMaterialType());
			return app;
		}
		return null;
	}
	public void saveApplication() {
//		getAppllication().setModificationDate(new Date());
		File file=new File(WorkspaceConfiguration.APP_CONFIG);

		URI uri=URI.createFileURI(file.getAbsolutePath());
		Resource ress =getResource(uri);
		ress.getContents().clear();
		ress.getContents().add(getApplication());
		// Save the resources to the file system.
		try {
			ress.save(ResourceManagers.saveOptions);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	public void loadCatalogs() {
		String[] files =FileSearch.getFiles(WorkspaceConfiguration.getCatalogsPath(), true, new String[]{".catalog"},false);

		for (String filename : files) {
			File file = new File(filename);
			Catalog cat = loadCatalog(file.getAbsolutePath(),false);
			if (cat != null)
			{
				getCatalogs().add(cat);				
			}
		}

	}
	
	public Catalog loadCatalog(String path ,boolean isCreate) {
		File file=new File(path);
		URI uri=URI.createFileURI(file.getAbsolutePath());
		Resource ress =loadResource(uri,!file.exists());
		if(!ress.getContents().isEmpty()) {
			 for(Object obj: ress.getContents()) {
				 if(obj instanceof Catalog)
				 {
					 Catalog cat= (Catalog) obj;
					 return cat;
				 }
			 }
		}
		return null;
	}
		
	public void saveCatalogs() {
		for(Catalog cat:getCatalogs()) {
			saveCatalog(cat);
		}
	}
	public void saveCatalog(Catalog catalog) {
		if(catalog.getId()==null) {
			catalog.setId(UUID.randomUUID());
		}
		
		catalog.setModificationDate(new Date());
		if(catalog.eResource()!=null) {
			saveResource(catalog.eResource());
		}else {
			File file=new File(WorkspaceConfiguration.getCatalogsPath()+File.separator+catalog.getName()+"("+catalog.getOwner()+")_"+catalog.getId()+".catalog");
			saveCatalog(catalog, file.getAbsolutePath());
		}
	}
	public void saveCatalog(Catalog catalog,String path) {
		final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
		saveOptions.put(Resource.OPTION_SAVE_ONLY_IF_CHANGED, Resource.OPTION_SAVE_ONLY_IF_CHANGED_MEMORY_BUFFER);
		saveOptions.put(XMLResource.OPTION_PROCESS_DANGLING_HREF, XMLResource.OPTION_PROCESS_DANGLING_HREF_DISCARD);
		File file=new File(path);
		URI uri=URI.createFileURI(file.getAbsolutePath());
		Resource ress=null;
		Resource oldResource=catalog.eResource();
		
		ress=getResource(uri);
		ress.getContents().clear();
		ress.getContents().add(catalog);
		// Save the resources to the file system.
		try {
			ress.save(saveOptions);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if(oldResource!=null && !oldResource.getURI().path().contentEquals(uri.path()) ) {
			URI oldUri=oldResource.getURI();
			File oldfile=new File(oldUri.path());
			try {
//				EcoreUtil.delete(oldResource);
				oldResource.delete(Collections.EMPTY_MAP);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			oldfile.delete();
			
		}
	}
	public void saveResource(EObject dressings,String path) {
		
		File file=new File(path);
		URI uri=URI.createFileURI(file.getAbsolutePath());
		Resource ress=null;
		
		ress=getResource(uri);
		ress.getContents().clear();
		if(dressings instanceof Collection)
		{
			ress.getContents().addAll((Collection<? extends EObject>) dressings);
		}else {
			ress.getContents().add(dressings);
		}
		saveResource(ress);

	}
	public void saveResource(Resource resource) {
		
		// Save the resources to the file system.
		try {
			resource.save(ResourceManagers.saveOptions);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public  String[] getfiles(String path,boolean isfile,String[] extensions,boolean acceptSubFile) {
		String[] files= new String[] {};
		File configFolder =new File(path);
		if(configFolder.exists()) {
			files = configFolder.list(new FilenameFilter() {
				  @Override
				  public boolean accept(File current, String name) {
					  if(!new File(current, name).isFile()) {
						  return false;
					  }
					  for(String ext:extensions) {
						  if(name.endsWith(ext)) {
							  return true;
						  }
					  }
				    return false;
				  }
				});
		}
		return files;
	}
	public Resource getResource(URI uri) {
		Resource ress =	resSet.getResource(uri,false);
		if(ress==null) {
			ress =	resSet.createResource(uri);
		}
		return ress;
	}
	
	public Resource loadResource(URI uri, boolean isCreate) {
		return loadResource(uri, isCreate, this.resSet);
	}
	
	/**
	 * Loads an EMF Resource from the given URI with optional creation.
	 * If the load fails due to unresolved references, performs a second
	 * relaxed load discarding invalid references.
	 *
	 * @param uri the file URI to load
	 * @param isCreate true to create a new empty resource if not existing
	 * @return the loaded Resource (never null)
	 */
	public Resource loadResource(URI uri, boolean isCreate,ResourceSet resSet) {
	    Resource resource = null;

	    try {
	        // --- Step 1: Create or retrieve resource ---
	        if (isCreate) {
	            resource = resSet.createResource(uri);
	        } else {
	            resource = resSet.getResource(uri, false);
	            if (resource == null) {
	                resource = resSet.createResource(uri);
	            }
	        }

	        // --- Step 2: Load normally ---
	        Map<?, ?> baseOptions = resSet.getLoadOptions();
	        resource.load(baseOptions);

	    } catch (Exception primaryEx) {
	        System.err.println("[EMF] Load failed for: " + uri);
	        primaryEx.printStackTrace();

	        try {
	            // --- Step 3: Attempt cleanup and relaxed reload ---
	            System.err.println("[EMF] Attempting relaxed load (discarding unresolved references)...");

	            resource.unload();
	            Map<Object, Object> relaxedOptions = new HashMap<>();

	            relaxedOptions.put(XMLResource.OPTION_DEFER_IDREF_RESOLUTION, Boolean.TRUE);
	            relaxedOptions.put(XMLResource.OPTION_DEFER_ATTACHMENT, Boolean.TRUE);
	            relaxedOptions.put(XMLResource.OPTION_USE_FILE_BUFFER, Boolean.TRUE);
	            relaxedOptions.put(XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE);
	            relaxedOptions.put(XMLResource.OPTION_PROCESS_DANGLING_HREF, XMLResource.OPTION_PROCESS_DANGLING_HREF_DISCARD);

	            resource.load(relaxedOptions);

	            System.err.println("[EMF] Relaxed load successful for: " + uri);

	        } catch (IOException secondaryEx) {
	            System.err.println("[EMF] Relaxed load failed for: " + uri);
	            secondaryEx.printStackTrace();
	        }
	    }

	    return resource;
	}

	public List<Resource> getLibrariesresources() {
		return librariesresources;
	}

	public void setLibrariesresources(List<Resource> librariesresources) {
		this.librariesresources = librariesresources;
	}

	public Injector getInjector() {
		return injector;
	}

	public void setInjector(Injector injector) {
		this.injector = injector;
	}

	public EditingDomain getEditingDomain() {
		return editingDomain;
	}

	public void setEditingDomain(EditingDomain editingDomain) {
		this.editingDomain = editingDomain;
	}

	public ResourceLoader getResourceLoader() {
		return resourceLoader;
	}

	public void setResourceLoader(ResourceLoader resourceLoader) {
		this.resourceLoader = resourceLoader;
	}
	
	public ResourceSet getResSet() {
		return resSet;
	}

	public void setResSet(ResourceSet resSet) {
		this.resSet = resSet;
	}

	public List<Catalog> getCatalogs() {
		return catalogs;
	}

	public void setCatalogs(List<Catalog> catalogs) {
		this.catalogs = catalogs;
	}

	public Organisation getCompany() {
		return company;
	}


	public Application getApplication() {
		return application;
	}

	public void setApplication(Application application) {
		this.application = application;
	}

	public Resource getAccessoireResource() {
		return accessoireResource;
	}

	public URI getLibraryUri() {
		return libraryUri;
	}

	public void saveLibraryResource() {
		//copyTypeDef objects from libraries to DynamicTypes  
		//dynamicTypeManager.copyDynamicTypes();used only in dev to copy types from libraries to dynamicTypes
	
		// Save the resources to the file system.

		getResSet().getResources().stream()
        .filter(Resource::isModified)
        .forEach(resource -> {
            try {
                resource.save(ResourceManagers.saveOptions);
                System.out.println("Resource saved: " + resource.getURI());
            } catch (IOException e) {
                e.printStackTrace();
            }
        });
	}
	
	public void saveAccessoireGroup() {
		if(accessoireResource==null) {
			loadAccessoireData();
		}
		saveResource(accessoireResource);
	}

	public void saveQuincaillerieGroup() {
		if(quincailleriesResource==null) {
			loadQuincailleriesData();
		}
		saveResource(quincailleriesResource);
	}
	public void saveMaterials() {
		if(materialResource==null) {
			loadMaterialsData();
		}
		saveResource(materialResource);
	}
	public Material getMaterial(UUID id) {
		Material element = null;
		for (Material elementX : ResourceManagers.getIntance().getMaterials()) {
			if (elementX.getModelId().equals(id))
				element = elementX;
		}
		return element;
	}
	public void saveMaterialTypes() {
		saveResource(materialTypesResource);
	}
	public void saveChants() {
		saveResource(chantsResource);
	}
	
	public ModelRoot getModelroot() {
		return modelroot;
	}
	public void setModelroot(ModelRoot modelroot) {
		this.modelroot = modelroot;
	}
	
	public List<ModelRoot> getModelroots() {
		return modelroots;
	}

	public void setModelroots(List<ModelRoot> modelroots) {
		this.modelroots = modelroots;
	}
	
	public Resource getAppResource() {
		return appResource;
	}

	public TypeDef getTypeDef(String key) {
		List<ModelRoot> roots=getModelroots();
		for(ModelRoot root:roots) {
			EList<TypeDef> types=root.getCategorie().getTypedef();
			for(TypeDef type:types) {
				if(type.getKey().contentEquals(key)) {
					return type;
				}
			}
		}
		return getTypeByKey(key);
	}
	
	public void gereParameters() {
		getModelroots().clear();
		for (Resource root : getLibrariesresources()) {
			TreeIterator<EObject> tree = root.getAllContents();
			EObject em = tree.next();

			if (em instanceof ModelRoot) {
				ModelRoot mr = (ModelRoot) em;
				getModelroots().add(mr);
			}
		}
		
		TreeIterator<EObject> tree = libraryresource.getAllContents();
		EObject em = tree.next();
		if (em instanceof ModelRoot) {
			ModelRoot mr = (ModelRoot) em;
			setModelroot(mr);
			ModelProvider.setModelroot(mr);	
		}
	}

	public DynamicTypeManager getDynamicTypeManager() {
		return dynamicTypeManager;
	}
	
	   /**
     * Loads all dynamic type definitions (*.type files) from the configured path.
     */
    public synchronized void loadDynamicTypes() {
        String basePath = WorkspaceConfiguration.getDynamicTypesPath();

        String[] files = FileSearch.getFiles(basePath, true, new String[]{".type"}, false);

        if (getApplication().getTypes() == null) {
        	getApplication().setTypes(ParamFactory.eINSTANCE.createDynamicTypes());
        }

        getApplication().getTypes().getTypes().clear();
        typeCache.clear();

        for (String filename : files) {
            File file = new File(filename);
            TypeDef type = loadDynamicType(file.getAbsolutePath(), true);
            if (type != null) {
            	getApplication().getTypes().getTypes().add(type);
            	dynamicTypeManager.addTypeChangeListener(type);
                cacheType(type);
            } else {
                System.err.println("⚠️  Impossible de charger le type depuis : " + filename);
            }
        }

        System.out.println("✅ " + typeCache.size() + " types dynamiques chargés et mis en cache.");
    }

	/**
	 * Loads a single TypeDef from the given path.
	 */
	public TypeDef loadDynamicType(String path, boolean isCreate) {
		File file = new File(path);
		if (!file.exists())
			return null;
		URI uri = URI.createFileURI(file.getAbsolutePath());
		Resource resource = loadResource(uri, isCreate);
		if (resource == null || resource.getContents().isEmpty()) {
			return null;
		}

		if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof TypeDef) {
			return (TypeDef) resource.getContents().get(0);
		}
		return null;
	}
	   /**
     * Caches a TypeDef object by its name.
     */
	private void cacheType(TypeDef type) {
		if (type != null && type.getKey() != null && !type.getKey().trim().isEmpty()) {
			typeCache.put(type.getKey().trim(), type);
		} else {
			System.err.println("⚠️  TypeDef ignoré car nom invalide ou vide.");
		}
	}

    /** Returns a TypeDef by name, or null if not found. */
    public TypeDef getTypeByKey(String key) {
        return typeCache.get(key);
    }

    /** Returns all cached types as an unmodifiable map. */
    public Map<String, TypeDef> getCachedTypes() {
        return Collections.unmodifiableMap(typeCache);
    }

	public Resource getGestionResource() {
		return gestionResource;
	}

	public ResourceSet getGestionResourceSet() {
		return gestionResourceSet;
	}
    
}
