package dressing.cam.model;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jogamp.vecmath.Point2d;

import com.badlogic.gdx.math.Vector3;

import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Rainure;
import dressing.model.Trou;
import dressing.model.Usinage;
import param.Chant;
import param.DesignElementChantGroup;
import reporting.data.handle.PieceCoupe;
public class Util {
	public static MathContext context=new MathContext(6);
	public static MathContext context3=new MathContext(3);

    private static final double EPSILON = 10.0;

	public static Comparator<Cercle2D> comparX = new Comparator<Cercle2D>() {

		@Override
		public int compare(Cercle2D o1, Cercle2D o2) {
			double x1 = o1.getxPos();
			double x2 = o2.getxPos();
			double y1 = o1.getyPos();
			double y2 = o2.getyPos();
			if (x1 >= x2 && y1 >= y2) {
				return 1;
			} else if (x1 <= x2 && y1 <= y2) {
				return -1;
			} else {
				if (x1 >= x2 && y1 <= y2) {
					return 1;
				} else if (x1 <= x2 && y1 >= y2) {
					return -1;
				}
			}
			return 0;
		}

	};
	public static Comparator<Cercle2D> comparY = new Comparator<Cercle2D>() {

		@Override
		public int compare(Cercle2D o1, Cercle2D o2) {
			double x1 = o1.getxPos();
			double x2 = o2.getxPos();
			double y1 = o1.getyPos();
			double y2 = o2.getyPos();
			if (x1 >= x2 && y1 >= y2) {
				return 1;
			} else if (x1 <= x2 && y1 <= y2) {
				return -1;
			} else {
				if (y1 >= y2 && x1 <= x2) {
					return 1;
				} else if (y1 <= y2 && x1 >= x2) {
					return -1;
				}

			}
			return 0;
		}

	};
	
	
	

	public static double calculateDistance(List<Cercle2D> trous) {
		double cdisance = 0;
		for (int i = 0; i < trous.size() - 1; i++) {

			double x1 = trous.get(i).getxPos();
			double x2 = trous.get(i + 1).getxPos();
			double y1 = trous.get(i).getyPos();
			double y2 =trous.get(i + 1).getyPos();
			double dis = Point2D.distance(x1, y1, x2, y2);
			cdisance += dis;
		}
		return cdisance;
	}
	public static double calculateDistanceOperation(List<Operation> trous) {
		double cdisance = 0;
		for (int i = 0; i < trous.size() - 1; i++) {

			double x1 = trous.get(i).getShape().getxPos();
			double x2 = trous.get(i + 1).getShape().getxPos();
			double y1 = trous.get(i).getShape().getyPos();
			double y2 =trous.get(i + 1).getShape().getyPos();
			double dis = Point2D.distance(x1, y1, x2, y2);
			cdisance += dis;
		}
		return cdisance;
	}

	public static Cercle2D deteminerCercleExtrusion(Point2d p1, Point2d p2, Point2d p3) {
		Cercle2D cercle = new Cercle2D();
		Point2d centre = new Point2d();

		Double a1, a2, b1, b2;
		a1 = (p2.y - p1.y) / (p2.x - p1.x);
		b1 = (p1.x * p2.y) / (p1.x - p2.x);

		a2 = (p2.y - p3.y) / (p2.x - p3.x);
		b2 = (p3.x * p2.y) / (p3.x - p2.x);

		centre.x = (b2 - b1) / (a1 - a2);
		centre.y = a1 * centre.x + b1;

		Double rayon = Math.sqrt(Math.pow((centre.x - p1.x), 2) + Math.pow((centre.y - p1.y), 2));

		cercle.setRaduis(rayon);
		cercle.setxPos(centre.x);
		cercle.setyPos(centre.y);

		return cercle;

	}

	public static boolean candrawUsinage(Usinage cavity, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) cavity.getParentdesign();

		switch (perspectiveview) {
		case FRONT:
			return cavity.getZpos() + cavity.getProfondeurext() == piece.getProfondeurext();
		case BACK:
			return cavity.getZpos() == 0;
		case RIGHT:
			return cavity.getXpos() + cavity.getLongeurext() == piece.getLongeurext();
		case LEFT:
			return cavity.getXpos() == 0;
		case DOWN:
			return cavity.getYpos() == 0;
		case TOP:
			return cavity.getYpos() + cavity.getHauteurext() == piece.getHauteurext();
		default:
			return false;
		}
	}


	public static boolean candrawTrou(Trou tr, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return tr.getDirection() == Direction.ZMINUS;
		case BACK:
			return tr.getDirection() == Direction.ZPLUS;
		case RIGHT:
			return tr.getDirection() == Direction.XMINUS;
		case LEFT:
			return tr.getDirection() == Direction.XPLUS;
		case DOWN:
			return tr.getDirection() == Direction.YPLUS;
		case TOP:
			return tr.getDirection() == Direction.YMINUS;
		default:
			return false;
		}

		
	}

	public static double getDepth(Rainure rn, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return -rn.getProfondeurext();
		case BACK:
			return -rn.getProfondeurext();
		case RIGHT:
			return -rn.getLongeurext();
		case LEFT:
			return -rn.getLongeurext();
		case DOWN:
			return -rn.getHauteurext();
		case TOP:
			return -rn.getHauteurext();
		default:
			return 0;
		}

	}

	public static double getDepth(Trou tr, PlanUsinage perspectiveview) {
		return -tr.getDepth();

	}

	public static double getDesignHeight(DesignObject3D rn, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return rn.getHauteurext();
		case BACK:
			return rn.getHauteurext();
		case RIGHT:
			return rn.getHauteurext();
		case LEFT:
			return rn.getHauteurext();
		case DOWN:
			return rn.getProfondeurext();
		case TOP:
			return rn.getProfondeurext();
		default:
			return 0;
		}

	}

	public static double getDesignWidth(DesignObject3D rn, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return rn.getLongeurext();
		case BACK:
			return rn.getLongeurext();
		case RIGHT:
			return rn.getProfondeurext();
		case LEFT:
			return rn.getProfondeurext();
		case DOWN:
			return rn.getLongeurext();
		case TOP:
			return rn.getLongeurext();
		default:
			return 0;
		}

	}

	public static double getRainureXpos(Rainure rn, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) rn.getParentdesign();
		switch (perspectiveview) {
		case FRONT:
			return rn.getXpos();
		case BACK:
			return  rn.getXpos();
		case RIGHT:
			return piece.getProfondeurext() - rn.getZpos() - rn.getProfondeurext();
		case LEFT:
			return rn.getZpos();
		case DOWN:
			return rn.getXpos();
		case TOP:
			return rn.getXpos();
		default:
			return 0;
		}

	}

	public static double getRainureYpos(Rainure rn, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) rn.getParentdesign();

		switch (perspectiveview) {
		case FRONT:
			return rn.getYpos();
		case BACK:
			return piece.getHauteurext() - rn.getYpos();
		case RIGHT:
			return piece.getHauteurext() - rn.getYpos() - rn.getHauteurext();
		case LEFT:
			return piece.getHauteurext() - rn.getYpos() - rn.getHauteurext();
		case DOWN:
			return piece.getProfondeurext() - rn.getZpos() - rn.getProfondeurext();
		case TOP:
			return rn.getZpos();
		default:
			return 0;
		}

	}

	public static double getXcenter(Trou tr, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) tr.getParentdesign();
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
			
		switch (perspectiveview) {
		case FRONT:
			return tr.getXpos();
		case BACK:
			return piece.getLongeurext() - tr.getXpos();
		case RIGHT:
			return piece.getProfondeurext() - tr.getZpos();
		case LEFT:
			return tr.getZpos();
		case DOWN:
			return tr.getXpos();
		case TOP:
			return tr.getXpos();
		default:
			return 0.00001;
		}
	}

	public static double getYcenter(Trou tr, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) tr.getParentdesign();
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return tr.getYpos();
		case BACK:
			return tr.getYpos();
		case RIGHT:
			return tr.getYpos();
		case LEFT:
			return tr.getYpos();
		case DOWN:
			return  tr.getZpos();
		case TOP:
			return piece.getProfondeurext() -tr.getZpos();
		default:
			return 0.00001;
		}
	}
	
	public static Vector3 getMaterialDependentDimention(Piece2D piece,boolean isSenseFil,boolean ispredebitchant ,boolean isSenseFilInverse  ) {
		Vector3 dim=new Vector3();
		dim.x=(float) piece.getPieceL();
		dim.y=(float) piece.getPieceH();
		BigDecimal longeur=new BigDecimal(piece.getLongeurext(),Util.context).movePointRight(3);
		BigDecimal hauteur=new BigDecimal(piece.getHauteurext(),Util.context).movePointRight(3);
		BigDecimal profondeur=new BigDecimal(piece.getProfondeurext(),Util.context).movePointRight(3);
		dim.z=longeur.add(hauteur).add(profondeur)
				.subtract(new BigDecimal(dim.x,Util.context).movePointRight(3))
				.subtract(new BigDecimal(dim.y,Util.context).movePointRight(3))
				.movePointLeft(3).floatValue();
//		dim.z=(float) ((piece.getLongeurext()+piece.getHauteurext()+piece.getProfondeurext())-(dim.x+dim.y));
		float l=dim.x;
		BigDecimal dimx=new BigDecimal(dim.x,Util.context).movePointRight(3);
		BigDecimal dimy=new BigDecimal(dim.y,Util.context).movePointRight(3);
		if(isSenseFil) {
			switch (piece.getMechanicDesignElementDefinition().getSensFil()) {
			case HORIZONTAL:
				if(dimx.compareTo(longeur)!=0) {
					l=dim.y;
					dim.y=dim.x;
					dim.x=l;
				}

				break;
			case VERTICAL:
				if(dimx.compareTo(hauteur)!=0) {
					l=dim.y;
					dim.y=dim.x;
					dim.x=l;
				}
				break;
			case PROUFOUND:
				if(dimx.compareTo(profondeur)!=0) {
					l=dim.y;
					dim.y=dim.x;
					dim.x=l;
				}
				break;
			default:
				break;
			}
		}
		if(isSenseFilInverse) {
			l=dim.y;
			dim.y=dim.x;
			dim.x=l;
		}
		if(ispredebitchant &&piece.getMechanicDesignElementDefinition()!=null && piece.getMechanicDesignElementDefinition().getChants()!=null) {
			DesignElementChantGroup chants = piece.getMechanicDesignElementDefinition().getChants();
			

			if(chants.isLeftExist()&& chants.getLeft()!=null) {
				BigDecimal dime=new BigDecimal(chants.getLeft().getEpaisseur(),Util.context).movePointRight(3);
				dimx=dimx.subtract(dime);
			}
			if(chants.isRightExist()&& chants.getRight()!=null) {
				BigDecimal dime=new BigDecimal(chants.getRight().getEpaisseur(),Util.context).movePointRight(3);
				dimx=dimx.subtract(dime);
			}
			if(chants.isBottomExist()&& chants.getBottom()!=null) {
				BigDecimal dime=new BigDecimal(chants.getBottom().getEpaisseur(),Util.context).movePointRight(3);
				dimy=dimy.subtract(dime);
			}
			if(chants.isTopExist()&& chants.getTop()!=null) {
				BigDecimal dime=new BigDecimal(chants.getTop().getEpaisseur(),Util.context).movePointRight(3);
				dimy=dimy.subtract(dime);
			}
			dim.y=dimy.movePointLeft(3).floatValue();
			dim.x=dimx.movePointLeft(3).floatValue();

		}

		
		return dim;
	}
	
	public static String formatChantForSuperCoupe(Chant chant) {
		return chant.getName() + "-" + chant.getEpaisseur();
	}
	
	public static Map<PlanUsinage,Chant> getChants(Piece2D piece,boolean isSenseReversed){
		Map<PlanUsinage ,Chant> chantsMap=new HashMap<PlanUsinage, Chant>();
		Chant leftchant = null;
		Chant rightChant = null;
		Chant topChant =null;
		Chant bottomChant = null;
		
		if (piece.getMechanicDesignElementDefinition() != null
				&& piece.getMechanicDesignElementDefinition().getChants() != null) {
			DesignElementChantGroup chants = piece.getMechanicDesignElementDefinition().getChants();

			if (chants.isLeftExist() && chants.getLeft() != null && chants.getLeft().getName() != null) {
				leftchant = chants.getLeft(); 
			}
			if (chants.isRightExist() && chants.getRight() != null && chants.getRight().getName() != null) {
				rightChant = chants.getRight();  
			}
			if (chants.isTopExist() && chants.getTop() != null && chants.getTop().getName() != null) {
				topChant = chants.getTop();
			}
			if (chants.isBottomExist() && chants.getBottom() != null && chants.getBottom().getName() != null) {
				bottomChant = chants.getBottom();
			}
		
		}
		if(isSenseReversed) {
			Chant aux=leftchant;
			leftchant=bottomChant;
			bottomChant=aux;
			
			aux=rightChant;
			rightChant=topChant;
			topChant=aux;
		}
		chantsMap.put(PlanUsinage.LEFT, leftchant);
		chantsMap.put(PlanUsinage.RIGHT, rightChant);
		chantsMap.put(PlanUsinage.TOP,topChant );
		chantsMap.put(PlanUsinage.DOWN, bottomChant);

		return chantsMap;
	}

	public static void sortTrous(List<Cercle2D> trous) {
		
		trous.sort(comparX);
		double xdisance = calculateDistance(trous);
		trous.sort(comparY);
		double ydisance = calculateDistance(trous);
		if (xdisance < ydisance) {
			trous.sort(comparX);
		} else {
			trous.sort(comparY);
		}
	}
	public static void sortOps(List<Operation> trous) {
		 Comparator<Operation> comparX = new Comparator<Operation>() {

			@Override
			public int compare(Operation o1, Operation o2) {
				CamShape c1=o1.getShape();
				CamShape c2=o2.getShape();
				if(c1 instanceof Cercle2D && !(c2 instanceof Cercle2D)) {
					return 1;
				}
				if(c2 instanceof Cercle2D && !(c1 instanceof Cercle2D)) {
					return -1;
				}
					

				double x1 = c1.getxPos(); 
				double x2 = c2.getxPos();
				double y1 = c1.getyPos();
				double y2 = c2.getyPos();
				if (x1 >= x2 && y1 >= y2) {
					return 1;
				} else if (x1 <= x2 && y1 <= y2) {
					return -1;
				} else {
					if (x1 >= x2 && y1 <= y2) {
						return 1;
					} else if (x1 <= x2 && y1 >= y2) {
						return -1;
					}
				}
				return 0;
			}

		};
		 Comparator<Operation> comparY = new Comparator<Operation>() {

			@Override
			public int compare(Operation o1, Operation o2) {
				CamShape c1=o1.getShape();
				CamShape c2=o2.getShape();
				double x1 = c1.getxPos();
				double x2 = c2.getxPos();
				double y1 = c1.getyPos();
				double y2 = c2.getyPos();
				if(c1 instanceof Cercle2D && !(c2 instanceof Cercle2D)) {
					return 1;
				}
				if(c2 instanceof Cercle2D && !(c1 instanceof Cercle2D)) {
					return -1;
				}
				if (x1 >= x2 && y1 >= y2) {
					return 1;
				} else if (x1 <= x2 && y1 <= y2) {
					return -1;
				} else {
					if (y1 >= y2 && x1 <= x2) {
						return 1;
					} else if (y1 <= y2 && x1 >= x2) {
						return -1;
					}
				}
				return 0;
			}

		};
		trous.sort(comparX);
		double xdisance = calculateDistanceOperation(trous);
		trous.sort(comparY);
		double ydisance = calculateDistanceOperation(trous);
		if (xdisance < ydisance) {
			trous.sort(comparX);
		} else {
			trous.sort(comparY);
		}
	}
	public static void sortRainure(List<RainureGcode> rainures) {
		 Comparator<RainureGcode> comparX = new Comparator<RainureGcode>() {

			@Override
			public int compare(RainureGcode o1, RainureGcode o2) {
				if(o1.getStart().dst(new Vector3(0, 0, 0))<o2.getStart().dst(new Vector3(0, 0, 0))) {
					return -1;
				}else {
					return 1;
				}
			}
			 
		 };
		 rainures.sort(comparX);
	}
	/**
	 * 
	 * @param operations list of rainure to assemble
	 * @param checkwidth if to check width equality before assembling the rainures or checkwidth==false ignore the width 
	 * @param checkdepth if to check depth equality before assembling the rainures or checkdepth==false ignore the depth
	 * @return
	 */
	public static List<RainureGcode> assembleRainures(List<RainureGcode> operations,boolean checkwidth, boolean checkdepth) {
        List<RainureGcode> assembledOperations = new ArrayList<>();

        for (int i = 0; i < operations.size(); i++) {
            RainureGcode currentOperation = operations.get(i);

            if (assembledOperations.isEmpty()) {
                assembledOperations.add(currentOperation);
            } else {
                RainureGcode previousOperation = assembledOperations.get(assembledOperations.size() - 1);

                if (isAligned(previousOperation, currentOperation) 
                		&&(!checkwidth ||previousOperation.getWidth()==currentOperation.getWidth())
                		&&(!checkdepth ||previousOperation.getDepth()==currentOperation.getDepth())) {
                    double distance = calculateDistance(previousOperation.getEnd(), currentOperation.getStart());
                    if (distance <= EPSILON) {
                        // Update end point of previous operation if needed
                        if (currentOperation.getEnd().x > previousOperation.getEnd().x) {
                            previousOperation.setEnd(currentOperation.getEnd());
                        }
                    } else {
                        assembledOperations.add(currentOperation);
                    }
                } else {
                    assembledOperations.add(currentOperation);
                }
            }
        }

        return assembledOperations;
    }
	
    private static boolean isAligned(RainureGcode operation1, RainureGcode operation2) {
        return operation1.getStart().x == operation2.getStart().x ||
               operation1.getStart().y == operation2.getStart().y;
    }

    private static double calculateDistance(Vector3 point1, Vector3 point2) {
        // Assuming Euclidean distance for simplicity
        return Math.sqrt(Math.pow(point2.x - point1.x, 2) +
                         Math.pow(point2.y - point1.y, 2));
    }

	public static List<Cuboid> getcuboidsforPlan(PlanUsinage plan, Piece2D piece) {
		List<Cuboid> cuboids = new ArrayList<Cuboid>();
		for (DesignObject3D cv : piece.getChilds()) {
			if((cv instanceof Rainure) || (cv instanceof Cavity)) {
				if (Util.candrawUsinage((Usinage) cv, plan)) {
					cuboids.add(new Cuboid((Usinage) cv, plan));
				}
			}
		}
		return cuboids;
	}
	
	public static List<Cercle2D> gettrousforPlan(PlanUsinage plan, Piece2D piece) {
		List<Cercle2D> trous = new ArrayList<Cercle2D>();
		for (DesignObject3D tr : piece.getChilds()) {
			if (tr instanceof Trou) {
				if (Util.candrawTrou((Trou) tr, plan)) {
					trous.add(new Cercle2D((Trou) tr, plan));
				}
			}
		}

		return trous;
	}

	public static List<Usinage> getRainureforPlan(PlanUsinage plan, Piece2D piece) {
		List<Usinage> cuboids = new ArrayList<Usinage>();
		for (DesignObject3D cv : piece.getChilds()) {
			if((cv instanceof Rainure) || (cv instanceof Cavity)) {
				if (Util.candrawUsinage((Usinage) cv, plan)) {
					cuboids.add((Usinage) cv);
				}
			}
		}

		return cuboids;
	}

	public static List<Usinage> gettrous(PlanUsinage plan, Piece2D piece) {
		List<Usinage> trous = new ArrayList<Usinage>();
		for (DesignObject3D tr : piece.getChilds()) {
			if (tr instanceof Trou) {
				if (Util.candrawTrou((Trou) tr, plan)) {
					trous.add((Usinage) tr);
				}
			}
		}

		return trous;
	}
	public static double getPieceH(Piece2D piece, PlanUsinage perspectiveview) {
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return piece.getHauteurext() ;
		case BACK:
			return piece.getHauteurext();
		case RIGHT:
			return piece.getHauteurext();
		case LEFT:
			return piece.getHauteurext();
		case DOWN:
			return piece.getProfondeurext();
		case TOP:
			return piece.getProfondeurext();
		default:
			return 0.00001;
		}
	}
	public static double getPieceL(Piece2D piece, PlanUsinage perspectiveview) {
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return piece.getLongeurext() ;
		case BACK:
			return piece.getLongeurext();
		case RIGHT:
			return piece.getProfondeurext();
		case LEFT:
			return piece.getProfondeurext();
		case DOWN:
			return piece.getLongeurext();
		case TOP:
			return piece.getLongeurext();
		default:
			return 0.00001;
		}
	}
	
	public static double round(double d, int precision) {
		return Math.round(d * Math.pow(10, precision)) * Math.pow(10, -precision);
	}
	public static boolean epsilonEquals(float f1, float f2, float epsilon) {
        return (f1 + epsilon >= f2 && f1 - epsilon <= f2);
    }
	public static Vector3 getDesignAxe(DesignObject3D deisgn) {
		double rainurelength = Math.max(Math.max(deisgn.getLongeurext(), deisgn.getHauteurext()), deisgn.getProfondeurext());
		if(rainurelength == deisgn.getLongeurext()) {
			return Vector3.X;
		}else if(rainurelength == deisgn.getHauteurext()) {
			return Vector3.Y;
		}else {
			return Vector3.Z;
		}
	}
	public static List<PieceCoupe> compactPieces2D(List<Piece2D> pieces){
		List<PieceCoupe> coupePieces=new ArrayList<PieceCoupe>();
		for(Piece2D piece:pieces) {
			boolean found=false;
			if(!coupePieces.isEmpty()) {
				for(PieceCoupe coupe:coupePieces ) {
					if(coupe.contains(piece)) {
						coupe.addPiece(piece);
						found=true;
						break;
					}
				}
			}
			
			if(!found) {
				PieceCoupe coupe=new PieceCoupe(piece.getName(),piece);
				coupePieces.add(coupe);
			}
		}
		
		
		return coupePieces;
	}
}
