package dressing.cam.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import dressing.model.Usinage;

public abstract class CamShape {

	PlanUsinage plan = PlanUsinage.FRONT ;
	Usinage usin;
	public double xPos;
	public double yPos;
	public CamShape(PlanUsinage plan, Usinage usin) {
		super();
		this.plan = plan;
		this.usin = usin;
	}
	public CamShape(Usinage usin) {
		this(PlanUsinage.FRONT,usin);
	}
	public CamShape() {
	}
	
	public Usinage getUsin() {
		return usin;
	}
	public void setUsin(Usinage usin) {
		Usinage oldValue=this.usin;		
		this.usin = usin;
		init();
		firePropertyChange("usin", oldValue, this.usin);
	}
	public PlanUsinage getPlan() {
		return plan;
	}

	public void setPlan(PlanUsinage plan) {
		PlanUsinage oldValue=this.plan;		
		this.plan = plan;
		init();
		firePropertyChange("plan", oldValue, this.plan);
	}
	public double getxPos() {
		return xPos;
	}

	public void setxPos(double xPos) {
		this.xPos = xPos;
	}

	public double getyPos() {
		return yPos;
	}

	public void setyPos(double yPos) {
		this.yPos = yPos;
	}

	abstract void init();
	public abstract String getGcode();
	
	public PropertyChangeSupport getPropertyChangeSupport() {
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}
}
