package tech.frsdev.shapes2D;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import dressing.cam.model.Direction;
import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;
import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Rainure;
import dressing.model.Trou;

public class Piece2DDraw 
{
	Piece2D piece ;
    int widthbound;
    int heightbound;


    double width;
    double height;
    
    double newratio =1;
    double newratiox =1;
    double newratioy =1;

    double realheight;
    double realwidth;
    int xcenter;
    int ycenter;
    double scale = 1;
    int widthbeafterzoom;
    int heightafterzoom;
    private PlanUsinage perspectiveview = PlanUsinage.RIGHT;
    private Point translate=new Point(0,0); 
    public static final BasicStroke basicStroke_2  = new BasicStroke(2.0f);
    public static final BasicStroke basicStroke_05  = new BasicStroke(0.5f);
    public static final BasicStroke basicStroke_03  = new BasicStroke(0.3f);
    public static final BasicStroke basicStroke_1  = new BasicStroke(1.0f);
    public static final BasicStroke basicStroke_01  = new BasicStroke(0.1f);
    public static final BasicStroke dahsedstroke_02 = new BasicStroke(0.2f,BasicStroke.CAP_SQUARE, BasicStroke.JOIN_MITER,
			 10.0f,new float[] {3.0f,4.0f}, 0.0f); 

	public Piece2DDraw(Piece2D piece, int widthbound, int heightbound) {
		super();
		this.piece = piece;
		this.widthbound = widthbound;
		this.heightbound = heightbound;

	}

	public Piece2D getPiece() {
		return piece;
	}

	public void setPiece(Piece2D piece) {
		this.piece = piece;
	}

	public int getWidthbound() {
		return widthbound;
	}

	public void setWidthbound(int widthbound) {
		this.widthbound = widthbound;
	}

	public int getHeightbound() {
		return heightbound;
	}

	public void setHeightbound(int heightbound) {
		this.heightbound = heightbound;
	}

	public double getWidth() {
		return width;
	}

	public double getHeight() {
		return height;
	}

	public  void redifine()
	{
		
//		if(piece.getPiecetype().equals(PieceType.DROITE_CUISSON))
//		{
//			piece.getChilds().clear();
//			try {
//				Trou tr = new Trou(Direction.XPLUS);
//				tr.setDiameter(200);
//				tr.setXcenter(0);
//				tr.setYcenter(piece.getHauteurext() / 2);
//				tr.setZcenter(piece.getProfondeurext() / 2);
//				tr.setDepth(piece.getLongeurext() / 2);
//				piece.addElement(tr);
//
//				tr = new Trou(Direction.XPLUS);
//				tr.setDiameter(50);
//				tr.setXcenter(0);
//				tr.setYcenter(piece.getHauteurext() * 0.75);
//				tr.setZcenter(piece.getProfondeurext() / 2);
//				tr.setDepth(piece.getLongeurext() / 2);
//				piece.addElement(tr);
//
//				tr = new Trou(Direction.XPLUS);
//				tr.setDiameter(50);
//				tr.setXcenter(0);
//				tr.setYcenter(piece.getHauteurext() * 0.75);
//				tr.setZcenter(piece.getProfondeurext() * 0.75);
//				tr.setDepth(piece.getLongeurext() / 2);
//				piece.addElement(tr);
//			} catch (DesignException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			} catch (GeometricEngineException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//			
//			
//		}
		switch (perspectiveview) {
		case FRONT:
			width =  (int) piece.getLongeurext();
			height = (int) piece.getHauteurext();
			break;
		case BACK:
			width =  (int) piece.getLongeurext();
			height = (int) piece.getHauteurext();
			break;
		
		case RIGHT:
			width =  (int) piece.getProfondeurext();
			height = (int) piece.getHauteurext();
			break;
		case LEFT:
			width =  (int) piece.getProfondeurext();
			height = (int) piece.getHauteurext();
			break;			
		case DOWN:
			width =  (int) piece.getLongeurext();
			height = (int) piece.getProfondeurext();
			break;
		case TOP:
			width =  (int) piece.getLongeurext();
			height = (int) piece.getProfondeurext();
			break;		
		default:
			break;
		}

		realheight = height;
		realwidth = width;
		double widthratio = (double)width/widthbound;
		double heighratio = (double)height/heightbound;
		
		if( widthratio>heighratio)
		{
			double max = (int) (widthbound*0.8);
			 newratio = max/width;
			 newratiox= max/width;
			 newratioy= max/height;
			height = (int) (newratio  * height) ;
			width = (int) max;
		}
		else if( heighratio>widthratio )
		{
			double max = (int) (heightbound*0.8);
			 newratio = max/height;
			 newratiox= max/width;
			 newratioy= max/height;
			width = (int) (newratio  * width) ;
			height = (int) max;
			
		}
		
		
		xcenter = (int) (widthbound/2 - width/2) ;
		ycenter = (int) (heightbound/2  - height/2);
		
		scale = 1;
		this.translate=new Point(0, 0);
		zoom(0);
	}
	public void translate(Point start) {
		this.translate.translate((start.x), (start.y));
	}
    public void zoom(double step)
    {
    	scale+=step;    	
    	if(scale<0.2)
    		scale = 0.25;
    	
		widthbeafterzoom = (int) (width * scale);;
		heightafterzoom = (int) (height *  scale);
		xcenter = widthbound/2 - widthbeafterzoom/2 ;
		ycenter = heightbound/2  - heightafterzoom/2;
    }
    
    public int getXcenter() {
		return xcenter;
	}
    public int getYcenter() {
		return ycenter;
	}
    
    public int getWidthbeafterzoom() {
		return widthbeafterzoom;
	}
    
    public int getHeightafterzoom() {
		return heightafterzoom;
	}
    
    public void draw(Graphics2D g2d)
    {
    	

    	

    	
    	g2d.translate(xcenter+translate.x, ycenter+translate.y);
    	g2d.fillOval(0, 0, 2, 2);
    	
    	
    	g2d.setStroke(basicStroke_2);
    	g2d.drawRect(0,0,this.getWidthbeafterzoom(), this.getHeightafterzoom());
    	
    	

    	g2d.setStroke(basicStroke_03);
    	for(DesignObject3D des : piece.getChilds())
    	{
    		if(des instanceof Trou)
    		{
    			Trou tr  = (Trou)des;
    			drawTrous(tr, g2d);
    		}
    		if(des instanceof Rainure)
    		{
    			Rainure rn  = (Rainure)des;
    			drawRainure(rn, g2d);
    		}
    		if(des instanceof Cavity) {
    			Cavity cavity =(Cavity)des;
    			drawCavity(cavity,g2d);
    		}
    	}

    	
    	g2d.setStroke(basicStroke_05);
    	g2d.translate(0, -40); 
    	g2d.drawLine(0, 0, this.getWidthbeafterzoom(), 0);
    	g2d.drawString(""+(int)this.realwidth, this.getWidthbeafterzoom()/2, -5);    	
    	g2d.translate(0, 40); 
    	
    	
    	
    	g2d.translate(-40, 0); 
    	g2d.drawLine(0, 0, 0, this.getHeightafterzoom());
    	Rectangle2D bounds=g2d.getFontMetrics().getStringBounds(""+(int)this.realheight, g2d);
    	double stringHeight=bounds.getWidth();
    	g2d.drawString(""+(int)this.realheight,(int) -stringHeight-3,  (int) (this.getHeightafterzoom()/2 +bounds.getHeight()/4));
    	g2d.translate(40, 0); 
    	
    	g2d.translate(0, this.getHeightafterzoom()); 
    	Rectangle2D nameBounds=g2d.getFontMetrics().getStringBounds(this.getPiece().getName(), g2d);
    	g2d.drawString(""+this.getPiece().getName(),(int) (this.getWidthbeafterzoom()/2-nameBounds.getWidth()/2),  +20 );
    	g2d.translate(0,-this.getHeightafterzoom()); 
    	
    	g2d.translate(-xcenter-translate.x, -ycenter-translate.y);   
    	
    }	

	public void setViewPerspective(PlanUsinage persplan) {
		// TODO Auto-generated method stub
		this.perspectiveview = persplan;
	}

	public void drawTrous(Trou tr,Graphics2D g2d) {

		if (candrawTrou(tr)) {

			// redefinir l origine
			g2d.scale(scale, scale);

			g2d.translate(Util.getXcenter(tr,perspectiveview) * newratio, getYcenter(tr,perspectiveview) * newratio);
			g2d.translate(-tr.getDiameter() * 0.5 * newratio, -tr.getDiameter() * 0.5 * newratio);

			g2d.drawOval(0, 0, (int) (tr.getDiameter() * newratio), (int) (tr.getDiameter() * newratio));

			g2d.translate(tr.getDiameter() * 0.5 * newratio, tr.getDiameter() * 0.5 * newratio);
			g2d.translate(-Util.getXcenter(tr,perspectiveview) * newratio, -getYcenter(tr,perspectiveview)* newratio);
			g2d.setStroke(basicStroke_05);

	    	g2d.translate(-5,getYcenter(tr,perspectiveview) * newratio); 
	    	g2d.drawLine(0, (int) (-tr.getDiameter() * 0.5 * newratio), 0,(int) (tr.getDiameter() *0.5* newratio));
	    	g2d.setStroke(basicStroke_01);
	    	Rectangle2D stringsize=g2d.getFontMetrics().getStringBounds(""+(int)tr.getDiameter(), g2d);
	    	g2d.drawString(""+(int)tr.getDiameter() , (int) (-3-stringsize.getWidth()), (int)(-3+ stringsize.getHeight()/2));    
	    	g2d.translate(5, -(getYcenter(tr,perspectiveview)) * newratio);
			
			
			//
			g2d.scale(1 / scale, 1 / scale);
		}
	}
	
	private void drawRainure(Rainure rn,Graphics2D g2d) {
		if (candrawRainure(rn)) {
			g2d.scale(scale, scale);

			g2d.translate(getCavityXpos(rn) * newratio, getCavityYpos(rn) * newratio);

			g2d.drawRect(0, 0, (int) (getCavityWidth(rn) * newratio), (int) (getCavityHeight(rn) * newratio));
			g2d.translate(-getCavityXpos(rn) * newratio, -getCavityYpos(rn) * newratio);

			
			//
			
			g2d.setStroke(basicStroke_05);
	    	g2d.translate(0, height+5); 
	    	
	    	g2d.translate(getCavityXpos(rn) * newratio, 0);			
	    	g2d.drawLine(0, 0, (int) (getCavityWidth(rn) * newratio), 0);
	    	g2d.setStroke(basicStroke_01);
	    	Rectangle2D stringsize=g2d.getFontMetrics().getStringBounds(""+(int)getCavityHeight(rn), g2d);

	    	g2d.drawString(""+(int)getCavityWidth(rn) , (int) (getCavityWidth(rn) * newratio)/2 -2, (int) (stringsize.getHeight()/2+4));    	
	    	g2d.translate(-getCavityXpos(rn) * newratio, 0);
	    	g2d.translate(0, -height-5);
	    	
	    	g2d.translate((width+10), 0); 
	    	g2d.setStroke(basicStroke_01);
	    	g2d.translate(0, getCavityYpos(rn) * newratio);			
	    	g2d.drawLine(0,0, 0,(int) (getCavityHeight(rn) * newratio));
	    	g2d.setStroke(basicStroke_03);
	    	double stringHeight=g2d.getFontMetrics().getStringBounds(""+(int)getCavityHeight(rn), g2d).getHeight();
	    	g2d.drawString(""+(int)getCavityHeight(rn) , 5,  (int) ((getCavityHeight(rn) * newratio)/2+stringHeight/4));

//	    	g2d.rotate(-Math.PI/2 );
	    	g2d.translate(0, -getCavityYpos(rn) * newratio);
	    	g2d.translate(-(width+10), 0);
			
			
			//
			g2d.scale(1 / scale, 1 / scale);
		}
		
	}
	private void drawCavity(Cavity cavity,Graphics2D g2d) {
		if (candrawCavity(cavity)) {
			g2d.scale(scale, scale);

			
			
			g2d.setStroke(dahsedstroke_02);
			g2d.translate(getCavityXpos(cavity) * newratio, getCavityYpos(cavity) * newratio);

			g2d.drawRect(0, 0, (int) (getCavityWidth(cavity) * newratio), (int) (getCavityHeight(cavity) * newratio));
			g2d.translate(-getCavityXpos(cavity) * newratio, -getCavityYpos(cavity) * newratio);

			
			//
			
			g2d.setStroke(basicStroke_05);
	    	g2d.translate(0, height+20); 
	    	
	    	g2d.translate(getCavityXpos(cavity) * newratio, 0);			
	    	g2d.drawLine(0, 0, (int) (getCavityWidth(cavity) * newratio), 0);
	    	g2d.setStroke(basicStroke_01);
	    	g2d.translate(0, 20);
	    	g2d.drawString(""+(int)getCavityWidth(cavity) , (int) (getCavityWidth(cavity) * newratio)/2, -5);    	
	    	g2d.translate(0, -20);
	    	g2d.translate(-getCavityXpos(cavity) * newratio, 0);
	    	g2d.translate(0, -height-20);
	    	
	    	g2d.translate(-10, 0); 
	    	g2d.setStroke(basicStroke_05);
	    	g2d.translate(0, getCavityYpos(cavity) * newratio);			
	    	g2d.drawLine(0,0, 0,(int) (getCavityHeight(cavity) * newratio));
	    	g2d.setStroke(basicStroke_01);
	    	double stringHeight=g2d.getFontMetrics().getStringBounds(""+(int)getCavityHeight(cavity), g2d).getHeight();
	    	g2d.drawString(""+(int)getCavityHeight(cavity) ,-23 , (int) ((getCavityHeight(cavity) * newratio)/2 +stringHeight/4));    	
//	    	g2d.rotate(Math.PI / 2);
	    	g2d.translate(0, -getCavityYpos(cavity) * newratio);
	    	g2d.translate(10, 0);
			
			
			//
			g2d.scale(1 / scale, 1 / scale);
		}
		
	}
	public static double getYcenter(Trou tr, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) tr.getParentdesign();
		
		return Util.getPieceH(piece, perspectiveview)-Util.getYcenter(tr, perspectiveview);
	}
	public boolean candrawTrou(Trou tr) {
		switch (perspectiveview) {
		case FRONT:
			return tr.getDirection() == Direction.ZMINUS;
		case BACK:
			return tr.getDirection() == Direction.ZPLUS;
		case RIGHT:
			return tr.getDirection() == Direction.XMINUS;
		case LEFT:
			return tr.getDirection() == Direction.XPLUS;
		case DOWN:
			return tr.getDirection() == Direction.YPLUS;
		case TOP:
			return tr.getDirection() == Direction.YMINUS;
		default:
			break;
		}

		return false;
	}

	public boolean candrawRainure(Rainure rn) {
		switch (perspectiveview) {
		case FRONT:
			return rn.getZpos() + rn.getProfondeurext() == piece.getProfondeurext();
		case BACK:
			return rn.getZpos() == 0;
		case RIGHT:
			return rn.getXpos() + rn.getLongeurext() == piece.getLongeurext() ;
		case LEFT:
			return rn.getXpos() == 0;
		case DOWN:
			return rn.getYpos() == 0;
		case TOP:
			return rn.getYpos() + rn.getHauteurext() == piece.getHauteurext();
		default:
			return false;
		}
//		return true;
	}
	public boolean candrawCavity(Cavity cavity) {
		switch (perspectiveview) {
		case FRONT:
			return cavity.getZpos() + cavity.getProfondeurext() == piece.getProfondeurext();
		case BACK:
			return cavity.getZpos() == 0;
		case RIGHT:
			return cavity.getXpos() + cavity.getLongeurext() == piece.getLongeurext() ;
		case LEFT:
			return cavity.getXpos() == 0;
		case DOWN:
			return cavity.getYpos() == 0;
		case TOP:
			return cavity.getYpos() + cavity.getHauteurext() == piece.getHauteurext();
		default:
			return false;
		}
//		return true;
	}
	public double getCavityXpos(Rainure rn) {
		switch (perspectiveview) {
		case FRONT:
			return rn.getXpos();
		case BACK:
			return piece.getLongeurext() - rn.getXpos()-rn.getLongeurext();
		case RIGHT:
			return piece.getProfondeurext()- rn.getZpos()-rn.getProfondeurext();
		case LEFT:
			return rn.getZpos();
		case DOWN:
			return rn.getXpos();
		case TOP:
			return rn.getXpos();
		default:
			return 0;
		}

	}
	public double getCavityYpos(Rainure rn) {
		switch (perspectiveview) {
		case FRONT:
			return piece.getHauteurext()-rn.getYpos()- rn.getHauteurext();
		case BACK:
			return piece.getHauteurext()-rn.getYpos()- rn.getHauteurext();
		case RIGHT:
			return piece.getHauteurext() - rn.getYpos() - rn.getHauteurext();
		case LEFT:
			return  piece.getHauteurext() - rn.getYpos() - rn.getHauteurext() ;
		case DOWN:
			return piece.getProfondeurext()-rn.getZpos()-rn.getProfondeurext();
		case TOP:
			return rn.getZpos();
		default:
			return 0;
		}

	}
	public double getCavityXpos(Cavity cavity) {
		switch (perspectiveview) {
		case FRONT:
			return cavity.getXpos();
		case BACK:
			return piece.getLongeurext() - cavity.getXpos()-cavity.getLongeurext();
		case RIGHT:
			return piece.getProfondeurext()- cavity.getZpos()-cavity.getProfondeurext();
		case LEFT:
			return cavity.getZpos();
		case DOWN:
			return cavity.getXpos();
		case TOP:
			return cavity.getXpos();
		default:
			return 0;
		}

	}
	public double getCavityYpos(Cavity cavity) {
		switch (perspectiveview) {
		case FRONT:
			return piece.getHauteurext()-cavity.getYpos() -cavity.getHauteurext();
		case BACK:
			return piece.getHauteurext()-cavity.getYpos() -cavity.getHauteurext();
		case RIGHT:
			return piece.getHauteurext()-cavity.getYpos() -cavity.getHauteurext();
		case LEFT:
			return piece.getHauteurext()-cavity.getYpos() -cavity.getHauteurext();
		case DOWN:
			return piece.getProfondeurext()-cavity.getZpos()-cavity.getProfondeurext();
		case TOP:
			return cavity.getZpos();
		default:
			return 0;
		}

	}
	public double getCavityWidth(Rainure rn) {
		switch (perspectiveview) {
		case FRONT:
			return  rn.getLongeurext();
		case BACK:
			return  rn.getLongeurext();
		case RIGHT:
			return rn.getProfondeurext();
		case LEFT:
			return  rn.getProfondeurext();
		case DOWN:
			return rn.getLongeurext();
		case TOP:
			return rn.getLongeurext();
		default:
			return 0;
		}

	}
	public double getCavityHeight(Rainure rn) {
		switch (perspectiveview) {
		case FRONT:
			return  rn.getHauteurext();
		case BACK:
			return  rn.getHauteurext();
		case RIGHT:
			return rn.getHauteurext();
		case LEFT:
			return  rn.getHauteurext();
		case DOWN:
			return  rn.getProfondeurext();
		case TOP:
			return  rn.getProfondeurext();
		default:
			return 0;
		}

	}
	public double getCavityWidth(Cavity cavity) {
		switch (perspectiveview) {
		case FRONT:
			return  cavity.getLongeurext();
		case BACK:
			return  cavity.getLongeurext();
		case RIGHT:
			return cavity.getProfondeurext();
		case LEFT:
			return  cavity.getProfondeurext();
		case DOWN:
			return cavity.getLongeurext();
		case TOP:
			return cavity.getLongeurext();
		default:
			return 0;
		}

	}
	public double getCavityHeight(Cavity cavity) {
		switch (perspectiveview) {
		case FRONT:
			return  cavity.getHauteurext();
		case BACK:
			return  cavity.getHauteurext();
		case RIGHT:
			return 	cavity.getHauteurext();
		case LEFT:
			return  cavity.getHauteurext();
		case DOWN:
			return  cavity.getProfondeurext();
		case TOP:
			return  cavity.getProfondeurext();
		default:
			return 0;
		}

	}
	
	public static PlanUsinage getPrimaryPrespective(Piece2D piece) {
		switch (piece.getPiecetype()) {
		case BAS_CUISSON:
			return PlanUsinage.TOP;
		case HAUT_CUISSON:
			return PlanUsinage.DOWN;
		case GAUCHE_CUISSON:
		case COTE_GAUCHE:
		case COTE_GAUCHE_TIROIR:
			return PlanUsinage.RIGHT;
			
			
		case DROITE_CUISSON:
		case COTE_DROITE:
		case COTE_DROITE_TIROIR:
			return PlanUsinage.LEFT;
			
		case PORTE_HAUT:
			return PlanUsinage.BACK;
		case PORTE:
			return PlanUsinage.BACK;
		case PORTE_BAS:
			return PlanUsinage.BACK;
		case PORTE_DROITE:
			return PlanUsinage.BACK;
		case PORTE_GAUCHE:
			return PlanUsinage.BACK;
		case DOS_EXTERIRUR:
			return PlanUsinage.FRONT;
		case DOS_INTERIEUR:
			return PlanUsinage.FRONT;
		case ETAGERE_MOBILE:
			return PlanUsinage.LEFT;
		case ETAGERE_FIXE:
			return PlanUsinage.LEFT;
		default:
			if(piece.getPiecetype().isFacade()) {
				return PlanUsinage.BACK;
			}
			return piece.getPrimaryPrespective();
		}
		
	}
	public static PlanUsinage getSecondaryPrespective(Piece2D piece) {
		switch (piece.getPiecetype()) {
		case BAS_CUISSON:
			return PlanUsinage.LEFT;
		case HAUT_CUISSON:
			return PlanUsinage.LEFT;
		case GAUCHE_CUISSON:
			return PlanUsinage.LEFT;
			
			
		case DROITE_CUISSON:
			return PlanUsinage.RIGHT;
		case PORTE_HAUT:
			return PlanUsinage.RIGHT;
		case PORTE:
			return PlanUsinage.RIGHT;
		case PORTE_BAS:
			return PlanUsinage.RIGHT;
		case PORTE_DROITE:
			return PlanUsinage.RIGHT;
		case PORTE_GAUCHE:
			return PlanUsinage.RIGHT;
		case DOS_EXTERIRUR:
			return PlanUsinage.RIGHT;
		case DOS_INTERIEUR:
			return PlanUsinage.RIGHT;
		case ETAGERE_MOBILE:
			return PlanUsinage.TOP;
		case ETAGERE_FIXE:
			return PlanUsinage.TOP;
		default:
			return piece.getSecondaryPrespective();
		}
		
	}


	@Override
	public Object clone() throws CloneNotSupportedException {
		// TODO Auto-generated method stub
		return new Piece2DDraw(piece, widthbound, heightbound);
	}
}