package reporting;

import java.util.ArrayList;
import java.util.HashMap;

import org.frs.structures.grid.Cell;
import org.frs.structures.grid.Grid;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.CamShape;
import dressing.cam.model.Cercle2D;
import dressing.cam.model.Cuboid;
import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;
import dressing.model.DesignException;
import dressing.model.Piece2D;
import dressing.model.PieceRotater;
import dressing.model.Usinage;
import reporting.htmlReporting.CubeGrid;

/* colors re encoded as normalized rgb vector*/
public class SVGGnerator {

	private final StringBuilder stringBuilder = new StringBuilder();
	
	private CotationManager cotationManager;
	private final ArrayList<Cercle2D> circles = new ArrayList<Cercle2D>();
	private final ArrayList<Cuboid> rainures = new ArrayList<Cuboid>();
	private ArrayList<Cotation> cotations;

	public String generateProjection(Piece2D piece, PlanUsinage face, Vector2 translation) {
		extractShapes(piece, face);
		if(circles.isEmpty() && rainures.isEmpty())
			return "";
		genCotations(piece, face);
		double l=Util.getPieceL(piece, face);
		double h=Util.getPieceH(piece, face);
		Vector2 dims = new Vector2((float)l, (float)h);
		Vector2 origin = new Vector2().sub(dims.cpy().scl(0.125f));
		Vector2 endCorner =  dims.cpy().scl(1.25f);
		stringBuilder.setLength(0);
		stringBuilder.append(String.format("<svg width=\"600%s\"  height=\"600%s\"  viewBox=\"%s  %s %s %s\"  "
				+ "style=\"border:1px solid black\">", "px", "px", origin.x, origin.y, endCorner.x, endCorner.y));
		// generate piece border
		 stringBuilder.append(SVGWriter.generateRectangleBlock(0, 0, l,
				 h, new Vector3(1, 1, 1), new Vector3()));
		 for(Cercle2D circle: circles) {
			 stringBuilder.append(SVGWriter.generateCircleBlock((float)circle.getxPos(), 
					 (float)circle.getyPos(), (float)circle.getRaduis(), new Vector3()) + "\n");
		 }
		 for(Cuboid cuboid: rainures) {
			 stringBuilder.append(SVGWriter.generateRectangleBlock(cuboid.getxPos(), cuboid.getyPos(), cuboid.getLongeur(),
					 cuboid.getHauteur(), new Vector3(1,1,1), new Vector3()) + "\n");
		 }
		 for(Cotation cotation:cotations) {
			 stringBuilder.append(SVGWriter.generateCotationCode(cotation, new Vector2()));
		 }
		 stringBuilder.append("</svg>");

		return stringBuilder.toString();
	}
	
	
	public String genSingleImageProjections(Piece2D piece, Vector2 dimension, int v_spacing, int h_spacing, float padding) {
		PieceRotater rotater = new PieceRotater();
		piece = rotater.rotateForLargestSurface(piece, true);

		CubeGrid cubeGrid = new CubeGrid();
		
		Grid grid = createGridForPiece(piece, v_spacing, h_spacing);
		
		cubeGrid.createForProjections(piece, h_spacing, v_spacing);
		int width = Math.round(dimension.x);
		int height = Math.round(dimension.y);
		stringBuilder.setLength(0);
		stringBuilder.append(String.format("<svg width=\"%s\"  height=\"%s\"  viewBox=\"%s %s %s %s\"  >", "100%", "650px",-padding, -padding, grid.getWidth() + padding, grid.getHeight() + padding));
		for(PlanUsinage face: PlanUsinage.values()) {
			Cell cell = grid.get(face);
			if(cell == null)
				continue;
			Vector2 translation = new Vector2();
			translation.set(cell.getX() + cell.getPadding()[2], cell.getY() + + cell.getPadding()[0]);
			generateProjectionContent(piece, face, translation );
		}
		stringBuilder.append("</svg>");
		return stringBuilder.toString();
	}
	
	private Grid createGridForPiece(Piece2D piece, int v_spacing, int h_spacing) {
		PieceProjectionGenerator gridGenerator = new PieceProjectionGenerator();
		Grid grid = gridGenerator.createGrid(piece, new float[] {v_spacing, h_spacing});
		return grid;
	}


	public void generateProjectionContent(Piece2D piece, PlanUsinage face, Vector2 translation) {
		extractShapes(piece, face);
		genCotations(piece, face);
		double l=Util.getPieceL(piece, face);
		double h=Util.getPieceH(piece, face);
		// generate piece border
		 stringBuilder.append(SVGWriter.generateRectangleBlock(0, 0, l,
				h, new Vector3(1, 1, 1), new Vector3(), translation));
		 for(Cercle2D circle: circles) {
			 stringBuilder.append(SVGWriter.generateCircleBlock((float)circle.getxPos(), 
					 (float)circle.getyPos(), (float)circle.getRaduis(), new Vector3(), translation) + "\n");
		 }
		 for(Cuboid cuboid: rainures) {
			 stringBuilder.append(SVGWriter.generateRectangleBlock(cuboid.getxPos(), cuboid.getyPos(), cuboid.getLongeur(),
					 cuboid.getHauteur(), new Vector3(1,1,1), new Vector3(), translation) + "\n");
		 }
		 for(Cotation cotation:cotations) {
			 stringBuilder.append(SVGWriter.generateCotationCode(cotation, translation));
		 }
	}
	
	private void genCotations(Piece2D piece, PlanUsinage face) {
		if(cotationManager == null)
			cotationManager = new CotationManager();
		cotations = cotationManager.generateCotationForProjection(piece, face, null);
	}
	
	private void extractShapes(Piece2D piece, PlanUsinage face) {
		circles.clear();
		rainures.clear();
		for (Usinage usinage : piece.getusinage()) {
			CamShape shape = null;
			try {
				shape = usinage.getShape();
			} catch (DesignException e) {
				e.printStackTrace();
				shape = null;
			}
			if (shape != null && shape.getPlan() == face) {
				if(shape instanceof Cercle2D) {
					circles.add((Cercle2D) shape);
				}else if(shape instanceof Cuboid){
					rainures.add((Cuboid) shape);
				}
			}
		}
	}
	
	
	public  HashMap<PlanUsinage,String> generatefaceprojection(Piece2D piece,Vector2 dimenions){
		HashMap<PlanUsinage,String> svgface = new HashMap<PlanUsinage,String>();
		String backSvg = generateProjection( piece, PlanUsinage.BACK, dimenions);
		if(!backSvg.equals(""))
			svgface.put(PlanUsinage.BACK,backSvg);
		
		String downSvg = generateProjection( piece, PlanUsinage.DOWN, dimenions);
		if(!downSvg.equals(""))
			svgface.put(PlanUsinage.DOWN,downSvg);
		
		String frontSvg = generateProjection( piece, PlanUsinage.FRONT, dimenions);
		if(!frontSvg.equals(""))
			svgface.put(PlanUsinage.FRONT,frontSvg);
		
		String leftSvg = generateProjection( piece, PlanUsinage.LEFT, dimenions);
		if(!leftSvg.equals(""))
			svgface.put(PlanUsinage.LEFT,leftSvg);
		
		String rightSVG = generateProjection( piece, PlanUsinage.RIGHT , dimenions);
		if(!rightSVG.equals(""))
			svgface.put(PlanUsinage.RIGHT,rightSVG);
		
		String topSVG = generateProjection( piece, PlanUsinage.TOP, dimenions);
		if(!topSVG.equals(""))
			svgface.put(PlanUsinage.TOP,topSVG);	
		return svgface;
		
	}


}
