package gdxapp.shapes;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;

public class LineSegmentEventProcessor extends InputListener{
	
	private final static String TAG = LineSegmentEventProcessor.class.getName();
	private LineSegment lineSegment;
	private boolean detect = true;
	private boolean endDefined = false;
	
	public LineSegmentEventProcessor(LineSegment lineSegment) {
		super();
		this.lineSegment = lineSegment;
	}
	
	@Override
	public boolean handle(Event e) {
		if(detect)
			return super.handle(e);
		else
			return false;
	}

	@Override
	public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
		lineSegment.setColor(Color.RED);
		if(endDefined) {
			Vector2 vertex = lineSegment.getNearestEdge(new Vector2(x,y));
			if(vertex != null) {
				
			}
		}
		return true;
	}

	@Override
	public void touchUp(InputEvent event, float x, float y, int pointer, int button) {

		if(Gdx.input.isKeyPressed(Keys.CONTROL_LEFT)) {
			Vector2 point = new Vector2(x,y);
			if(lineSegment.getStart() == null) {
				lineSegment.setStart(point);
			}else {
				lineSegment.setEnd(point);
				endDefined = true;
				
			}
		
		}
	}

	@Override
	public void touchDragged(InputEvent event, float x, float y, int pointer) {
		Gdx.app.debug(TAG, "touch dragged");
		// TODO Auto-generated method stub
		super.touchDragged(event, x, y, pointer);
	}

	@Override
	public boolean mouseMoved(InputEvent event, float x, float y) {
		if(lineSegment.getStart() != null && !endDefined)
			lineSegment.setEnd(new Vector2(x,y));
		// TODO Auto-generated method stub
		return super.mouseMoved(event, x, y);
	}

	@Override
	public boolean keyUp(InputEvent event, int keycode) {
		
    	Gdx.app.debug(TAG, "key up...");
		// TODO Auto-generated method stub
		return super.keyUp(event, keycode);
	}

	
	
}
