package gdxapp.screens.ObjectEditor;



import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.scenes.scene2d.Stage;

import dressing.events.Event;
import dressing.events.EventHandler;
import gdxapp.object3d.Object3D;
import gdxapp.scenes.SceneEvent;


public class ObjectEditorInputHandler implements EventHandler{
	
	private final InputMultiplexer multiplexer;
	
	private final Stage stage;
	private final ObjectSelector objectSelector;
	private final BoxBuilder boxBuilder;
	private final TargetCamera cameraController;
	private final ObjectMover objectMover;
	private DrawableInputProcessor activeProcesor;
	
	public ObjectEditorInputHandler(Stage stage, TargetCamera cameraController, ArrayList<Object3D> objects) {
		this.stage = stage;
		this.cameraController = cameraController;
		objectSelector = new ObjectSelector(cameraController.getCamera(), objects);
		boxBuilder = new BoxBuilder(cameraController.getCamera());
		objectMover = new ObjectMover(cameraController.getCamera());
		multiplexer = new InputMultiplexer();
		multiplexer.addProcessor(stage);
		multiplexer.addProcessor(cameraController);
		subscribeToEvent();
	}
	
	private void subscribeToEvent() {
		subscribe(SceneEvent.BUILD_CUBE.name());
		subscribe(SceneEvent.SELECT_OBJECT.name());
		subscribe(SceneEvent.MOVE_BTN_PRESSED.name());
	}

	@Override
	public void handle(Event event) {
		SceneEvent topic = SceneEvent.valueOf(event.getTopic());
		switch (topic) {
		case BUILD_CUBE:
			buildCubes();
			break;
		case SELECT_OBJECT:
			selectObjects();
			break;
		case MOVE_BTN_PRESSED:
			moveObject();
		default:
			break;
		}
		
	}



	private void moveObject() {
		multiplexer.clear();
		multiplexer.addProcessor(stage);
		
		multiplexer.addProcessor(objectMover);
		
		multiplexer.addProcessor(cameraController);
		
		activeProcesor = objectMover;
	}

	private void selectObjects() {
		multiplexer.clear();
		multiplexer.addProcessor(stage);
		objectSelector.setCamera(cameraController.getCurrentCamera());
		multiplexer.addProcessor(objectSelector);
		
		multiplexer.addProcessor(cameraController);
		
	}

	private void buildCubes() {
		boxBuilder.setCamera(cameraController.getCurrentCamera());
		multiplexer.clear();
		multiplexer.addProcessor(stage);
		
		multiplexer.addProcessor(boxBuilder);
		
		multiplexer.addProcessor(cameraController);
		
		activeProcesor = boxBuilder;
	}
	
	
	public void processInput() {
		Gdx.input.setInputProcessor(this.multiplexer);
	}



	
	//getters
	public BoxBuilder getBoxBuilder() {
		return boxBuilder;
	}

	public void draw(ModelBatch batch) {
		if(activeProcesor != null)
			activeProcesor.draw(batch);
	}

}
