package dressing.ui.util;

import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;

public abstract class EditorWindow extends Window{

	public static final int create = 1;
	public static final int executeAction = 2;
	public static final int update = 3;
	public static final int View = 4;
	protected String title;
	public EditorWindow(Shell parentShell,int update) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
		this.updateMode=update;
	}
	protected int updateMode=EditorWindow.create;

	public Shell shell;
	public List<Action> actions;
	protected String errorMessage="";
	protected boolean errorExist;
	private Button btnRun;
	private Button btnCancel;
	private Composite buttonAreaComposite;
	private Composite clientAreaComposite;
	
	public List<Action> getActions() {
		return actions;
	}
	public void setActions(List<Action> actions) {
		this.actions = actions;
	}
	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}

	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	@Override
	public void create() {
		// TODO Auto-generated method stub
		super.create();
		constrainShellSize();
		getShell().setImage(ResourceManager.getPluginImage("Dressing", "icons/icon-supercad32.jpg"));
		getShell().setMaximized(isMaximized());
		if(getTitle()!=null && !getTitle().isEmpty()) {
			getShell().setText(getTitle());
		}
	}
	protected boolean isMaximized() {
		return true;
	}
	/**  
	 * Create contents of the window.
	 * @return 
	 */
	@Override
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Editeur");

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		ScrolledComposite container = new ScrolledComposite(composite, SWT.V_SCROLL);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		container.setExpandHorizontal(true);
		container.setExpandVertical(true);
		clientAreaComposite = createClientArea(container);
//		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
//
//		clientAreaComposite.setLayoutData(gd_composite_1);
		container.setContent(clientAreaComposite);
//		container.setMinSize(clientAreaComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		buttonAreaComposite = createButtonArea(composite);
		GridData gd_composite_2 = new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1);
		gd_composite_2.heightHint = 50;
		buttonAreaComposite.setLayoutData(gd_composite_2);
		//
		composite.setTabList(new Control[]{container, buttonAreaComposite});

		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= EditorWindow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);		
		if(getUpdateMode()==EditorWindow.View) {
			this.clientAreaComposite.setEnabled(false);
		}

		return composite;

	}
	
	
	
	protected abstract Composite createClientArea(Composite parent);
	protected Composite createButtonArea(Composite parent) {
		Composite composite= new Composite(parent, SWT.NONE);
		GridLayout gl_composite_2 = new GridLayout(2, true);
		gl_composite_2.horizontalSpacing = 0;
		composite.setLayout(gl_composite_2);
		
		btnRun = new Button(composite, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 50;
		btnRun.setLayoutData(gd_btnRun);

		btnRun.setText("Appliquer");
		btnCancel = new Button(composite, SWT.NONE);
		btnCancel.setImage(ResourceManager.getPluginImage("Dressing", "icons/cancel_22X22.png"));
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 50;
		btnCancel.setLayoutData(gd_btnFermer);
		btnCancel.setText("Fermer");
		
		btnCancel.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						fermer();
					}
					
				});
		btnRun.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						terminer();
//						
					}
					
				});

		switch (this.updateMode) {
		case EditorWindow.View:
			this.getBtnRun().setEnabled(false);
			this.getBtnRun().setVisible(false);
			this.clientAreaComposite.setEnabled(false);

			break;

		case EditorWindow.create:
			this.getBtnRun().setText("Ajouter");
			this.getBtnRun().setEnabled(true);
			this.getBtnRun().setVisible(true);
			this.clientAreaComposite.setEnabled(true);

			break;

		case EditorWindow.update:
			this.getBtnRun().setText("Modifier");
			this.getBtnRun().setEnabled(true);
			this.getBtnRun().setVisible(true);
			this.clientAreaComposite.setEnabled(true);

			break;
		case EditorWindow.executeAction:
			this.getBtnRun().setText("Appliquer");
			this.getBtnRun().setEnabled(true);
			this.getBtnRun().setVisible(true);
			this.clientAreaComposite.setEnabled(true);
			break;
		default:
			break;
		}

		return composite;
	}
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			EditorWindow.this.shell.setVisible(true);
			EditorWindow.this.shell.setActive();
			EditorWindow.this.shell.setMaximized(true);
		}

	}
	public synchronized void hide() {
		if(!shell.isDisposed())
		{
			
			EditorWindow.this.shell.setVisible(false);
		}

	}
	public void displayMessage(Shell shell, String message) {
	      Shell hoverShell = new Shell(shell, SWT.ON_TOP);
	      hoverShell.setLayout(new FillLayout());
	      Label messageLabel = new Label(hoverShell, SWT.NONE);
	      messageLabel.setText(message);
	      Point shellLocation = shell.getLocation();
	      hoverShell.setSize(600,400);
	      hoverShell.pack();
	      hoverShell.setLocation(shellLocation.x + (shell.getSize().x / 2) - (hoverShell.getSize().x / 2), shellLocation.y/2+ (shell.getSize().y / 2));
	      hoverShell.open();
	      Display.getDefault().timerExec(2000, new Runnable() {

	        @Override
	        public void run() {
	            hoverShell.dispose();
	        }
	    });
	}
	public Shell getShell() {
		return shell;
	}
	public void setShell(Shell shell) {
		this.shell = shell;
	}
	public Button getBtnRun() {
		return btnRun;
	}
	public void setBtnRun(Button btnRun) {
		this.btnRun = btnRun;
	}
	public Button getBtnCancel() {
		return btnCancel;
	}
	public void setBtnCancel(Button btnFermer) {
		this.btnCancel = btnFermer;
	}
	
	public int getUpdateMode() {
		return updateMode;
	}
	public void setUpdateMode(int updateMode) {
		this.updateMode = updateMode;
	}
	public boolean terminer() {
		if(!check()) {
			MessageDialog.openError(getShell(), "Erreur", errorMessage);
			return false;
		}
		return true;
	}
	
	public void finish() {
		if(this.clientAreaComposite!=null&& !this.clientAreaComposite.isDisposed()) {
			this.clientAreaComposite.dispose();
		}
		System.gc();
		setReturnCode(OK);
		close();
	}
	public abstract boolean check();

	protected void fermer() {
		setReturnCode(CANCEL);
		cancel();
		close();
		if(!this.clientAreaComposite.isDisposed()) {
			this.clientAreaComposite.dispose();
		}
	}
	@Override
	protected void handleShellCloseEvent() {
		fermer();
	}
	protected abstract void cancel();
	public void createController() {
		
	}
	
	@Override
	protected Point getInitialSize() {
		
		return new Point(1280, 720);
	}
}
