package dressing.ui.preferences;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

import dressing.config.ReportingPreferences;

public class ReportPreferencesComposite extends Composite {

    private Button showAccessoireCheckbox;
    private Button showQuincaillerieCheckbox;
    private Button showCostCheckbox;
    private Button showFacadesCheckbox;
    private Button showFakeFacadesCheckbox;

    
    private Button showPiecesCheckbox;

    public ReportPreferencesComposite(Composite parent, int style) {
        super(parent, style);
        createContents(this);
    }

    private void createContents(Composite parent) {
        this.setLayout(new GridLayout(1, false));
        this.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));

        Group group = new Group(parent, SWT.NONE);
        group.setText("Préférences du rapport");
        group.setLayout(new GridLayout(1, false));
        group.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));

        ReportingPreferences prefs = ReportingPreferences.getInstance();

        showAccessoireCheckbox = createCheckbox(group, "Afficher les accessoires", 
            prefs.getBoolean("report.accessoire", true));

        showQuincaillerieCheckbox = createCheckbox(group, "Afficher les quincailleries", 
            prefs.getBoolean("report.quicaillerie", true));

        showCostCheckbox = createCheckbox(group, "Afficher les coûts", 
            prefs.getBoolean("report.showcost", false));

        showFacadesCheckbox = createCheckbox(group, "Afficher les façades", 
            prefs.getBoolean("report.showFacades", false));

        showPiecesCheckbox = createCheckbox(group, "Afficher les pièces", 
            prefs.getBoolean("report.showPieces", false));
        showFakeFacadesCheckbox = createCheckbox(group, "Afficher les fausse façades", 
                prefs.getBoolean("report.showFakeFaces", true));
    }

    private Button createCheckbox(Composite parent, String label, boolean selected) {
        Button checkbox = new Button(parent, SWT.CHECK);
        checkbox.setText(label);
        checkbox.setSelection(selected);
        return checkbox;
    }

    public void savePreferences() {
        ReportingPreferences prefs = ReportingPreferences.getInstance();

        prefs.setProperty("report.accessoire", Boolean.toString(showAccessoireCheckbox.getSelection()));
        prefs.setProperty("report.quicaillerie", Boolean.toString(showQuincaillerieCheckbox.getSelection()));
        prefs.setProperty("report.showcost", Boolean.toString(showCostCheckbox.getSelection()));
        prefs.setProperty("report.showFacades", Boolean.toString(showFacadesCheckbox.getSelection()));
        prefs.setProperty("report.showPieces", Boolean.toString(showPiecesCheckbox.getSelection()));
        prefs.setProperty("report.showFakeFaces", Boolean.toString(showFakeFacadesCheckbox.getSelection()));

        prefs.save(); // Save preferences to disk or session — implement if needed
    }
}
