package dressing.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.ui.palette.PaletteComposite;
import dressing.ui.palette.PaletteProvider;

public class PalettePart {

	@Inject
	private ESelectionService selectionService;
	
	@Inject
	IEventBroker eventBroker;
	
	static  Display display;
	Composite parentComposite;
	private Composite clientArea;

	public PalettePart() {
	}

	/**
	 * Create contents of the view part.
	 */
	@PostConstruct
	public void createControls(Composite parent) {
		parentComposite = parent;
		clientArea = new PaletteComposite(parent, SWT.FILL,eventBroker,selectionService,PaletteProvider.getInstance());
		display = parent.getDisplay();
		clientArea.pack();
//		parent.requestLayout();

	}

	
	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		clientArea.setFocus();
	}
}