package dressing.ui.parts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;

import dressing.cam.model.PlanUsinage;
import dressing.model.Piece2D;
import dressing.model.Solide3D;
import tech.frsdev.shapes2D.Panel2D;
import tech.frsdev.shapes2D.Piece2DDraw;

public class Edit2DPiece {

	@Inject ESelectionService selectionService;
	public Edit2DPiece() {
	}
	Panel2D panel2D =null;
	
	/**
	 * Create contents of the view part.
	 */
	@PostConstruct
	public void createControls(Composite parent) {

		Composite holder = new Composite(parent, SWT.EMBEDDED);
		java.awt.Frame fileTableFrame = SWT_AWT.new_Frame(holder);
	    java.awt.Panel panel = new java.awt.Panel(new java.awt.BorderLayout());
	    fileTableFrame.add(panel);
	    JTree fileTable = new JTree();
	    fileTable.setDoubleBuffered(true);


	    JPanel drawingPanel = new JPanel();
		drawingPanel.setLayout(new BorderLayout());
		drawingPanel.setPreferredSize(new Dimension(1000, 800));
		panel2D = new Panel2D();
		drawingPanel.add(panel2D, BorderLayout.CENTER);
//	    JScrollPane scrollPane = new JScrollPane(drawingPanel);
	    panel.add(drawingPanel);

	    selectionService.addSelectionListener("dressing.part.projectexplorer",new ISelectionListener() {
			
			@Override
			public void selectionChanged(MPart part, Object selection) {
				// TODO Auto-generated method stub
				if( selection instanceof Piece2D)
				{
					panel2D.updateDesign((Piece2D) selection);
					panel2D.changePerspective(Piece2DDraw.getPrimaryPrespective((Piece2D) selection));

				}
				
			}

		});
	}

	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}
	public void setSelection(@Optional @Named(IServiceConstants.ACTIVE_SELECTION) Solide3D contact) {
		  if (contact == null) {
		    /* implementation not shown */
		  } else {
		    /* implementation not shown */
		  }
		}
	
	public void setViewPerspective(PlanUsinage persplan) {
		panel2D.changePerspective(persplan);
	}
	
public static void paintToFile(String path,Piece2DDraw piece) {
		
		File file = null;
		for(PlanUsinage perspective: PlanUsinage.values())
		if(piece!=null)
		{
			BufferedImage bi = new BufferedImage(piece.getWidthbound(), piece.getHeightbound(), BufferedImage.TYPE_INT_ARGB);
			Graphics2D g = (Graphics2D) bi.getGraphics();
			g.setColor(Color.BLACK);
			piece.setViewPerspective(perspective);
			piece.redifine();
			piece.draw(g);
			String pathX  =  path + File.separator + perspective.toString() + ".png";
			file = new File(pathX);
			if(!file.exists()) {
				file.getParentFile().mkdirs();
				try {
					file.createNewFile();
					ImageIO.write(bi, "png", file);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}

	
}