package dressing.ui.palette;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

import dressing.model.ProjectManager;
import dressing.ui.engine3d.DnDHelper;
import gdxapp.object3d.ModeledObject;
import gdxapp.object3d.WorldObject;
import param.MechanicDesign;

/**
 * Centralized service responsible for palette drag-and-drop behavior.
 */
public final class PaletteDragService {

    private PaletteDragService() {
        // Utility class
    }

    /**
     * Attach drag-and-drop behavior to a palette cell control.
     *
     * @param control SWT control acting as drag source
     * @param data palette item data
     */
    public static void attach(Control control, Object data) {
        int operations = DND.DROP_MOVE | DND.DROP_COPY;
        DragSource source = new DragSource(control, operations);

        source.setTransfer(new Transfer[] { PaletteItemTransferType.getInstance() });
        source.setDragSourceEffect(null);

        source.addDragListener(new DragSourceAdapter() {

            @Override
            public void dragStart(DragSourceEvent event) {
                event.doit = ProjectManager.getManager().getCurrentKitchen() != null;
            }

            @Override
            public void dragSetData(DragSourceEvent event) {
            	Object transferredData=data;
            	PaletteItem item=null;
            	if(data instanceof PaletteItem) {
            		transferredData = ((PaletteItem) data).getData();
            		item=(PaletteItem) data;
            	}
                if (transferredData instanceof ModeledObject modeled) {
                    DnDHelper.transferedObject =
                        ((WorldObject) modeled).clone();
                }
                else {
                    MechanicDesign design =
                        MechanicDesignFactory.createCopy(transferredData);
                    if (design != null) {
                        DnDHelper.transferedObject = design;
                    }
                }
                PaletteItem[] pi = new PaletteItem[] { item };
				event.data = pi;
//                event.data = "caisson_canvas3D";
            }
        });
    }
}
