package dressing.ui.palette;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Vector4;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.TypeDefElementLabelProvider;
import gdxapp.object3d.WorldObject;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.TypeDef;
import param.TypeDefElement;

import org.eclipse.swt.widgets.List;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Label;

public class DesignObjectPaletteWindow extends EditorWindow {
	
	//ui objects
	private Composite parentComposite;
	private Composite clientArea;
	private Spinner spnLongeur;
	private Spinner spnHauteur;
	private Spinner spnProfondeur;
	private ComboViewer CValtitude;
	private Combo altitudeCombo;
	private Spinner spnAltitude;
	
	//data
	private Object data;
	private java.util.List<String> widths = new ArrayList<String>();
	private ListViewer listViewer;

	/**
	 * Create the application window.
	 */
	public DesignObjectPaletteWindow(Shell parentShell) {
		super(parentShell, EditorWindow.executeAction);
	}

	/**
	 * Return the initial size of the window.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(600, 400);
	}
	@Override
	protected boolean isMaximized() {
		return false;
	}
	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite = parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		listViewer = new ListViewer(clientArea, SWT.BORDER | SWT.V_SCROLL);
		List list = listViewer.getList();
		list.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Composite composite = new Composite(clientArea, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblLongeur = new Label(composite, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblLongeur.setText("Longeur");

		spnLongeur = new Spinner(composite, SWT.BORDER | SWT.WRAP);
		spnLongeur.setMaximum(10000000);
		spnLongeur.setSelection(600);
		spnLongeur.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));

		Label lblHauteur = new Label(composite, SWT.NONE);
		lblHauteur.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblHauteur.setText("Hauteur");

		spnHauteur = new Spinner(composite, SWT.BORDER | SWT.WRAP);
		spnHauteur.setPageIncrement(1);
		spnHauteur.setMaximum(1000000);
		spnHauteur.setSelection(720);
		spnHauteur.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));

		Label lblProfondeur = new Label(composite, SWT.NONE);
		lblProfondeur.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblProfondeur.setText("Profondeur");

		spnProfondeur = new Spinner(composite, SWT.BORDER | SWT.WRAP);
		spnProfondeur.setPageIncrement(1);
		spnProfondeur.setMaximum(1000000000);
		spnProfondeur.setSelection(560);
		spnProfondeur.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));

		CValtitude = new ComboViewer(composite, SWT.READ_ONLY);
		altitudeCombo = CValtitude.getCombo();
		GridData gd_altitudeCombo = new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1);
		gd_altitudeCombo.widthHint = 30;
		altitudeCombo.setLayoutData(gd_altitudeCombo);

		spnAltitude = new Spinner(composite, SWT.BORDER | SWT.WRAP);
		spnAltitude.setPageIncrement(1);
		spnAltitude.setMaximum(1000000000);
		spnAltitude.setSelection(0);
		spnAltitude.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		CValtitude.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		CValtitude.setContentProvider(ArrayContentProvider.getInstance());
		TypeDef altitudeType = ModelProvider.getTypeDef("PositionReference");
		CValtitude.setInput(altitudeType.getTypedefelement());
		CValtitude.setSelection(new StructuredSelection(altitudeType.getTypedefelement().get(0)));
		widths.add("150");
		widths.add("200");
		widths.add("250");
		widths.add("300");
		widths.add("350");
		widths.add("400");
		widths.add("450");
		widths.add("500");
		widths.add("550");
		widths.add("600");
		widths.add("650");
		widths.add("700");
		widths.add("750");
		widths.add("800");
		widths.add("850");
		widths.add("900");
		widths.add("950");
		widths.add("1000");
		widths.add("1050");
		widths.add("1100");
		widths.add("1150");
		widths.add("1200");

		listViewer.setContentProvider(ArrayContentProvider.getInstance());
		listViewer.setInput(widths);
		listViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection = (IStructuredSelection) event.getSelection();
				// set the selection to the service
				Object selectionobj = selection.size() == 1 ? selection.getFirstElement() : selection.toList();
				spnLongeur.setSelection(Float.valueOf((String) selectionobj).intValue());
			}
		});
		parent.requestLayout();
		return clientArea;
	}
	
	private void initModelObject() {
        WorldObject worldObject =(WorldObject) data;
		Vector4 dimension = worldObject.getRealWorldDimension().cpy();
		dimension.scl(1000);
		spnLongeur.setSelection(Math.round(dimension.x));
		spnHauteur.setSelection(Math.round(dimension.y));
		spnProfondeur.setSelection(Math.round(dimension.z));
		Vector3 position = worldObject.getRealWorldPosition().cpy();
		position.scl(1000);
		float y = position.y - dimension.y/2;
		spnAltitude.setSelection(Math.round(y));
		TypeDef altitudeType = ModelProvider.getTypeDef("PositionReference");
		if (altitudeType != null) {
			CValtitude.setSelection(new StructuredSelection(altitudeType.getElement("BOTTOM")));
		}
		if (widths.contains(String.valueOf(position.x))) {
			listViewer.getList().setSelection(widths.indexOf(String.valueOf(position.x)));
		}
		if(worldObject!=null) {
			title = worldObject.getName()!=null?"Ajouter un Composant : "+worldObject.getName(): "Ajouter un Composant";
			getShell().setText(title);
		}
	}
	
	private void initMechanicDesign() {
		MechanicDesign design = (MechanicDesign) data;
		try {
			MechanicPublicParam longeur = design.getPublicParam("global.l");
			MechanicPublicParam hauteur = design.getPublicParam("global.h");
			MechanicPublicParam profondeur = design.getPublicParam("global.p");

			MechanicPublicParam altitude = design.getPublicParam("element.positionY");
			MechanicPublicParam altitudeReference = design.getPublicParam("element_YReference");
			if (longeur != null) {
				String val = longeur.getDefaultvalue();

				if (widths.contains(val)) {
					listViewer.getList().setSelection(widths.indexOf(val));
				}
				spnLongeur.setSelection(Float.valueOf(longeur.getDefaultvalue()).intValue());
				spnLongeur.setEnabled(longeur.isChangeable());
				listViewer.getControl().setEnabled(longeur.isChangeable());
			}
			if (hauteur != null) {
				spnHauteur.setSelection(Float.valueOf(hauteur.getDefaultvalue()).intValue());
				spnHauteur.setEnabled(hauteur.isChangeable());
			}
			if (profondeur != null) {
				spnProfondeur.setSelection(Float.valueOf(profondeur.getDefaultvalue()).intValue());
				spnProfondeur.setEnabled(profondeur.isChangeable());
			}
			if (altitude != null && altitude.getDefaultvalue() != null
					&& !altitude.getDefaultvalue().isEmpty()) {

				spnAltitude.setSelection(Float.valueOf(altitude.getDefaultvalue()).intValue());
				spnAltitude.setEnabled(altitude.isChangeable());
			}
			if (altitudeReference != null && altitudeReference.getTypedefelement() != null) {

				CValtitude.setSelection(new StructuredSelection(altitudeReference.getTypedefelement()));
				CValtitude.getControl().setEnabled(altitudeReference.isChangeable());
			}
			if(design!=null) {
				title = design.getName()!=null?"Ajouter un Composant : "+design.getName(): "Ajouter un Composant";
				getShell().setText(title);
			}
		} catch (NumberFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
		if(data instanceof WorldObject) {
			initModelObject();
		}else if(data instanceof MechanicDesign) {
			initMechanicDesign();
		}
	}

	@Override
	public boolean check() {
		// TODO Auto-generated method stub
		return true;
	}
	
	public boolean terminer() {
		if (!super.terminer()) {
			return false;
		}
		if(data instanceof WorldObject) {
			 WorldObject worldObject =(WorldObject) data;
			 Vector4 dimension = new Vector4((float)spnLongeur.getSelection()/1000f, (float)spnHauteur.getSelection()/1000f,
						(float)spnProfondeur.getSelection()/1000f,0);
			 worldObject.setRealWorldDimension(dimension);
			float y = spnAltitude.getSelection() /1000.0f;
			Object sel = CValtitude.getStructuredSelection().getFirstElement();
			TypeDefElement altitudeReference=null;
			if (sel != null && sel instanceof TypeDefElement) {
				altitudeReference = (TypeDefElement) sel;
			}
			float kitchenAltitude = ProjectManager.getManager().getCurrentScene().getPreferences().getWallHeight();
			float altitude = y + dimension.y / 2.0f;
			if (altitudeReference!=null && altitudeReference.getKey().equals("TOP")) {
				altitude = kitchenAltitude - y - dimension.y / 2.0f;
			}
			
			worldObject.getRealWorldPosition().y = altitude;
		}
		else if (data instanceof MechanicDesign) {
			try {
				MechanicDesign design = (MechanicDesign) data;
				MechanicPublicParam longeur = design.getPublicParam("global.l");
				MechanicPublicParam hauteur = design.getPublicParam("global.h");
				MechanicPublicParam profondeur = design.getPublicParam("global.p");

				MechanicPublicParam altitude = design.getPublicParam("element.positionY");
				MechanicPublicParam altitudeReference = design.getPublicParam("element_YReference");
				if (longeur != null) {
					longeur.setDefaultvalue(String.valueOf(spnLongeur.getSelection()));
				}
				if (hauteur != null) {
					hauteur.setDefaultvalue(String.valueOf(spnHauteur.getSelection()));
				}
				if (profondeur != null) {
					profondeur.setDefaultvalue(String.valueOf(spnProfondeur.getSelection()));
				}
				if (longeur != null) {
					longeur.setDefaultvalue(String.valueOf(spnLongeur.getSelection()));
				}
				if (altitude != null) {
					altitude.setDefaultvalue(String.valueOf(spnAltitude.getSelection()));
				}
				if (altitudeReference != null) {
					Object sel = CValtitude.getStructuredSelection().getFirstElement();
					if (sel != null && sel instanceof TypeDefElement) {
						altitudeReference.setTypedefelement((TypeDefElement) sel);
					}
				}

			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		
		
	}
	
//	@Override
//	public String getTitle() {
//		return "Ajouter un Composant";
//	}
}
