package dressing.ui.palette;

import java.io.File;
import java.util.List;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import param.Catalog;
import param.DesignClassGroup;
import param.DesignClasse;
import param.DesignInstance;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.ModelRoot;
import param.PieceType;

public class DesignApplicationPaletteProvider extends PaletteProvider {
	private DesignObject3D parent;
	
	public DesignApplicationPaletteProvider(DesignObject3D parent) {
		this.parent=parent;
	}
	
	@Override
	public PaletteProject createPaletteProject() {
		this.palette = new PaletteProject();

		List<ModelRoot> roots = ResourceManagers.getIntance().getModelroots();
		for(ModelRoot root:roots) {
		
			DesignClassGroup classes = root.getClasses();
			if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
				for (DesignClasse classe : classes.getDesignClasse()) {
					PaletteGroup grp2 = new PaletteGroup(classe.getName()+" ("+root.getName()+")");
					grp2.setData(classe);
					grp2.setModifiable(false);
					grp2.setDeletable(false);
					if (classe.getCategorie() != null && classe.getCategorie().size() > 0) {
						for (MechanicDesignGroup famille : classe.getCategorie()) {
							if (famille != null && famille.getMechanicdesign() != null) {
								createGroupFromDesignGroup(grp2, famille);
							}
						}
					}
					if (!grp2.getPalettegroupes().isEmpty()) {
						if (classe.getPerviewPath() != null && !classe.getPerviewPath().isEmpty()) {
							grp2.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + classe.getPerviewPath());
						} else {
							String imagePath = WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_FOLDER_ICON;
							grp2.setImage(imagePath);
	
						}

						palette.addPaletteGroup(grp2);
					}
				}
	
			}
		}
		for (Catalog cat : ResourceManagers.getIntance().getCatalogs()) {
			PaletteGroup grp2 = new PaletteGroup(cat.getName() + " (" + cat.getOwner() + ")");
			grp2.setData(cat);
			grp2.setModifiable(true);
			grp2.setDeletable(true);
			if (cat.getCategorie() != null && !cat.getCategorie().isEmpty()) {
				for (MechanicDesignGroup famille : cat.getCategorie()) {
					if (famille != null && famille.getMechanicdesign() != null) {
						createGroupFromDesignGroup(grp2, famille);
					}
				}
			}
			if (!grp2.getPalettegroupes().isEmpty()) {
				if (cat.getPerviewPath() != null && !cat.getPerviewPath().isEmpty()) {
					grp2.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + cat.getPerviewPath());
				} else {
					String imagePath =WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_FOLDER_ICON;
					grp2.setImage(imagePath);

				}
				palette.addPaletteGroup(grp2);
			}
		}
		List<ModelRoot> dressingLibraries = ResourceManagers.getIntance().getApplication().getDressingLibraries();
		for(ModelRoot root:dressingLibraries) {
		
			DesignClassGroup classes = root.getClasses();
			if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
				for (DesignClasse classe : classes.getDesignClasse()) {
					PaletteGroup grp2 = new PaletteGroup(classe.getName()+" ("+root.getName()+")");
					grp2.setData(classe);
					grp2.setModifiable(false);
					grp2.setDeletable(false);
					if (classe.getCategorie() != null && classe.getCategorie().size() > 0) {
						for (MechanicDesignGroup famille : classe.getCategorie()) {
							if (famille != null && famille.getMechanicdesign() != null) {
								createGroupFromDesignGroup(grp2, famille);
							}
						}
					}
					if (!grp2.getPalettegroupes().isEmpty()) {
						if (classe.getPerviewPath() != null && !classe.getPerviewPath().isEmpty()) {
							grp2.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + classe.getPerviewPath());
						} else {
							String imagePath = WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_FOLDER_ICON;
							grp2.setImage(imagePath);
	
						}

						palette.addPaletteGroup(grp2);
					}
				}
	
			}
		}
		return palette;
	}

	/**
	 * @param parent
	 * @param famille
	 */
	private void createGroupFromDesignGroup(PaletteGroup parent, MechanicDesignGroup famille) {
		boolean isapplyToSpace=this.parent instanceof Space3D;
		PaletteGroup grp3 = new PaletteGroup(famille.getName());
		grp3.setData(famille);
		for (MechanicDesign design : famille.getMechanicdesign()) {
			if( isapplyToSpace && !design.getType().equals(PieceType.OBSTACLE) ) {
				continue;
			}
			if (design != null && design.isApplicable()) {
				createDesignPaletteItem(grp3, design,!PaletteProvider.isLibrary);
			}
		}
		for (DesignInstance design : famille.getDesignsintances()) {
			if( isapplyToSpace && !design.isObstacle() ) {
				continue;
			}
			if (design != null && design.isApplicable()) {
				createDesignInstancePaletteItem(grp3, design,!PaletteProvider.isLibrary);
			}
		}
		if (!grp3.getPaletteItems().isEmpty()) {
			if (famille.getPerviewPath() != null && !famille.getPerviewPath().isEmpty()) {
				grp3.setImage(WorkspaceConfiguration.getIconsPath() + File.separator + famille.getPerviewPath());
			} else {
				String imagePath = WorkspaceConfiguration.getIconsPath() + File.separator + DEFAULT_FOLDER_ICON;
				grp3.setImage(imagePath);

			}
			parent.addPaletteGroup(grp3);
		}
	}

}
