package dressing.ui;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.ReportingPreferences;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignObject3D;
import dressing.ui.util.TypeDefElementLabelProvider;
import param.DesignInstance;
import param.MechanicDressing;
import param.MechanicPublicParam;
import param.Option;
import param.OptionGroup;
import param.ParamFactory;
import param.ParamFamily;
import param.ParamFamilyGroup;
import param.PieceType;
import param.PublicParamGroup;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class MechanicDesignInstanceEditorComposite extends MechanicDeisgnEditorUtil {
	private DataBindingContext m_bindingContext;

	private DesignInstance designInstance;

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 * @param rootspace 
	 * @param update
	 * @param isModel 
	 */
	public MechanicDesignInstanceEditorComposite(Composite parent, int style,DesignInstance design, int update) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		this.designInstance=design;
		Label lblNom = new Label(this, SWT.NONE);
		lblNom.setText("Nom");
		lblNom.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		this.ismodel=true;
		this.design=this.designInstance.getDesign();
		this.accessoiresGroup = designInstance.getAccessoires();
		this.quincailleriesGroup = designInstance.getQuincailleries();
		name = new Text(this, SWT.BORDER);
		name.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		name.setText(design.getName());
		tabFolder = new CTabFolder(this, SWT.BORDER);
		tabFolder.setHighlightEnabled(true);
		tabFolder.setSimple(false);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		tabFolder.setSelectionBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));
		tabFolder.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		tabFolder.setBorderVisible(true);

		if((design.getDesign().getPublicparamgroup()!=null && design.getDesign().getPublicparamgroup().getMechanicpublicparam()!=null && design.getDesign().getPublicparamgroup().getMechanicpublicparam().size()>0&& design.getDesign().getPublicparamgroup().getMechanicpublicparam().stream().filter(mpp->mpp.isChangeable()).count()>0 )
				||(design instanceof MechanicDressing || design.getDesign().getType().equals(PieceType.DRESSING)) ){
			createGeneralTab();
		}
		boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
		createModelTabComposite();
		if(this.design.getMechanicelementgroup()!=null && this.design.getMechanicelementgroup().getMechanicdesignelment()!=null
				&&!this.design.getMechanicelementgroup().getMechanicdesignelment().isEmpty() )
		{
			createPieceModelTab();
		}
		if(isShowAccessoire||isShowQuicaillerie ) {
			createArticlesTab(isShowAccessoire,isShowQuicaillerie);
		}
		parent.requestLayout();
		if(tbtmGnral!=null)
		{
			tabFolder.setSelection(tbtmGnral);
			tbtmGnral.getControl().setFocus();
		}else {
			tabFolder.setSelection(0);
		}
		tabFolder.redraw();
		m_bindingContext = initDataBindings();
		
	}
	protected Composite createGeneralTab() {
		tbtmGnral = new CTabItem(tabFolder, SWT.NONE);
		tbtmGnral.setFont(SWTResourceManager.getFont("Times New Roman (Titres CS)", 14, SWT.BOLD));
		tbtmGnral.setText("Général");
		//
		general_scrolledComposite = new ScrolledComposite(tabFolder, SWT.H_SCROLL | SWT.V_SCROLL);
		general_scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		general_scrolledComposite.setExpandHorizontal(true);
		general_scrolledComposite.setExpandVertical(true);
		composite_general = new Composite(general_scrolledComposite, SWT.FILL);
		composite_general.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
//		gd_composite_1.heightHint = 558;
		composite_general.setLayoutData(gd_composite_1);
		composite_general.setLayout(new GridLayout(2, false));

		populateGeneralTab();
		setDesignInstanceOptionParameters();

		general_scrolledComposite.setContent(composite_general);
		general_scrolledComposite.setSize(composite_general.computeSize(SWT.MIN, SWT.MIN));
		general_scrolledComposite.setMinSize(composite_general.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		tbtmGnral.setControl(general_scrolledComposite);
		composite_general.pack();
		return composite_general;
	}
	/**
	 * 
	 */
	private void setDesignInstanceOptionParameters() {
		if(designInstance.getOptions()==null) {
			
			OptionGroup options = ParamFactory.eINSTANCE.createOptionGroup();
			Option primaryOption = ParamFactory.eINSTANCE.createOption();
			primaryOption.setLabel(designInstance.getName());
			primaryOption.setName(designInstance.getName());
			primaryOption.setModelId(UUID.randomUUID());
			primaryOption.setDefault(true);
			primaryOption.setVersion("1.0.0");
			primaryOption.setInjectedPublicParam(ParamFactory.eINSTANCE.createPublicParamGroup());
			options.getOptions().add(primaryOption);
			options.setSelectedOption(primaryOption);
			options.setId(UUID.randomUUID());
			designInstance.setOptions(options);
			
		}

		EList<MechanicPublicParam> publicParams = designInstance.getOptions().getSelectedOption().getInjectedPublicParam().getMechanicpublicparam();
		if (publicParams != null && !publicParams.isEmpty()) {
			for (MechanicPublicParam publicParam : publicParams) {
				try {
					PublicParamEditorComposite composite = ParamsCompositeMap.get(designInstance.getDesign().getPublicParam(publicParam.getKey()));
					if(composite!=null)
					composite.setValues(publicParam,true);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}

	
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	public void updateValues() {
		design.setName(design.getName().trim());
		PublicParamGroup paramGroup= designInstance.getOptions().getSelectedOption().getInjectedPublicParam();
		for(MechanicPublicParam param:dirtyParams.keySet()) {
			PublicParamEditorComposite composite=dirtyParams.get(param);
			MechanicPublicParam optionparam=paramGroup.getParam(param.getKey());
			if(optionparam==null) {
				optionparam=EcoreUtil.copy(param);
				optionparam.setTypeDefinition(null);

				optionparam.setTypedef(param.getTypedef());
				optionparam.setTypedefelement(param.getTypedefelement());
				paramGroup.getMechanicpublicparam().add(optionparam);
			}
			composite.updateValues(optionparam);
		}
		for(OptionGroup group:dirtyOptions.keySet()) {
			ComboViewer viewer=	dirtyOptions.get(group);
			Option option=(Option) viewer.getStructuredSelection().getFirstElement();
			group.setSelectedOption(option);
			for(MechanicPublicParam param : option.getInjectedPublicParam().getMechanicpublicparam()) {
				try {
					if(param.getTypedef()!=null && param.getTypedefelement()!=null)
					{
						design.getPublicparamgroup().setParamType(param.getKey(), param.getTypedefelement());
					}else {
						design.setPublicParamValue(param.getKey(), param.getDefaultvalue());
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		
	}
	
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextNameObserveWidget = WidgetProperties.text(SWT.Modify).observe(name);
		IObservableValue nameDesignObserveValue = BeanProperties.value("name").observe(designInstance);
		bindingContext.bindValue(observeTextNameObserveWidget, nameDesignObserveValue, null, null);
		//
		//
		if (design instanceof MechanicDressing) {
			MechanicDressing dressing = (MechanicDressing) design;
		
			//
			IObservableValue observeTextchantierObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtChantier);
			IObservableValue chantierDesignObserveValue = BeanProperties.value("chantier").observe(design);
			bindingContext.bindValue(observeTextchantierObserveWidget, chantierDesignObserveValue, null, null);
			//
			//
			IObservableValue observeTextEtageObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtEtage);
			IObservableValue etageDesignObserveValue = BeanProperties.value("etage").observe(design);
			bindingContext.bindValue(observeTextEtageObserveWidget, etageDesignObserveValue, null, null);
			//
			IObservableValue observeTextAppartementObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtAppartement);
			IObservableValue appartementDesignObserveValue = BeanProperties.value("appartement").observe(design);
			bindingContext.bindValue(observeTextAppartementObserveWidget, appartementDesignObserveValue, null, null);
			//
		}
		return bindingContext;
	}
}
