package dressing.ui;

import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Finition;
import param.ParamFactory;

public class FinitionsListWindow extends ListEditorWindow {

	IEventBroker eventBroker;
	public FinitionsListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
		this.eventBroker=eventBroker;
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des Finitions");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Finition ) {
					return ((Finition)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		//
		ColumnLabelProvider codeLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Finition ) {
					return ((Finition)element).getCode();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Code", true, null, SWT.LEFT, codeLabelProvider, new StringViewerComparator(codeLabelProvider));
		//
		//
		ColumnLabelProvider mdfLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Finition ) {
					return ((Finition)element).isPanneaux()?"Oui":"Non";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Panneaux" , true, null, SWT.CENTER, mdfLabelProvider, new StringViewerComparator(mdfLabelProvider));
		//
		ColumnLabelProvider chantLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Finition ) {
					return ((Finition)element).isChant()?"Oui":"Non";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Chant" , true, null, SWT.CENTER, chantLabelProvider, new StringViewerComparator(chantLabelProvider));
		//
		ColumnLabelProvider accessoiresLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Finition ) {
					return ((Finition)element).isAccessoire()?"Oui":"Non";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Accessoires" , true, null, SWT.CENTER, accessoiresLabelProvider, new StringViewerComparator(accessoiresLabelProvider));
		//
	}
	
	@Override
	protected void Add() {
		Finition frs=ParamFactory.eINSTANCE.createFinition();
		frs.setName("");
		FinitionEditorWindow materialEditorWindow = new FinitionEditorWindow(shell,frs,EditorWindow.create);
		materialEditorWindow.create();
		int ret=materialEditorWindow.open();
		if(ret==Window.OK) {
			refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Finition) {
			FinitionEditorWindow mechanicDesignWindow = new FinitionEditorWindow(shell,(Finition) selection.getFirstElement(),EditorWindow.update);
			mechanicDesignWindow.create();
			int ret=mechanicDesignWindow.open();
			if(ret==Window.OK) {
				refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Finition) {
						ResourceManagers.getIntance().getGestion().getFinitions().getFinitions().remove(obj);
						ResourceManagers.getIntance().saveGestion();
					}
				}
				refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Finition) {
			FinitionEditorWindow mechanicDesignWindow = new FinitionEditorWindow(shell,(Finition) selection.getFirstElement(),EditorWindow.View);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getGestion().getFinitions().getFinitions();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
