package dressing.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.ReportingPreferences;
import dressing.config.persistence.ResourceManagers;
import dressing.handlers.catalog.CreateCatalogEditorWindow;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;
import dressing.ui.util.EditorWindow;
import param.BaseObject;
import param.Catalog;
import param.DesignClasse;
import param.DesignInstance;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.MechanicDressing;
import param.ModelRoot;
import param.Option;
import param.OptionGroup;
import param.ParamFactory;
import param.PieceType;

public class ExportModuleWindow extends EditorWindow {

	public static final boolean isCatalog=true;
	private MechanicDesign design;
	private MechanicDesignGroup parent=null;
	
	IEventBroker eventBroker;
	
	Composite parentComposite;
	private TreeViewer treeViewer;
	private boolean copy=true; 
	public ExportModuleWindow(Shell parentShell, IEventBroker eventBroker, MechanicDesign design2, boolean iscopy) {
		super(parentShell,EditorWindow.executeAction);
		this.design=design2;
		this.eventBroker=eventBroker;
		this.copy=iscopy;
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		treeViewer = new TreeViewer(parent, SWT.BORDER);
		final Tree tree = treeViewer.getTree();
		treeViewer.setContentProvider(new LibraryTreeContentProvider());
		refreshTreeInput();
		treeViewer.setLabelProvider(ModelEMFLabelProvider.getInstance());
		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
		    public void selectionChanged(SelectionChangedEvent event) {
		      IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		      // set the selection to the service
		      Object selectionobj= selection.getFirstElement() ;
		      
		      if(selectionobj!=null && selectionobj instanceof MechanicDesignGroup) {
		    	  ExportModuleWindow.this.parent= (MechanicDesignGroup) selectionobj;
		      }
		    }
		  });
		MenuManager menuMgr = new MenuManager();

        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener() {
            @Override
            public void menuAboutToShow(IMenuManager manager) {
                // IWorkbench wb = PlatformUI.getWorkbench();
                // IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                if (treeViewer.getSelection().isEmpty()) {
                    return;
                }

                if (treeViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection) treeViewer.getSelection();
                    Object object = selection.getFirstElement();
                    if(object instanceof Catalog) {
                    	manager.add(new Action("Ajouter un Group") {
                        	public void run() {
                        		Catalog cat=null;
                        		if(object instanceof Catalog) {
                        			cat=(Catalog) object;
                        		}
                        		CreateCatalogEditorWindow catalogEditor =new CreateCatalogEditorWindow(parent.getShell(), cat, EditorWindow.create, !ExportModuleWindow.isCatalog, null,null);
                        		catalogEditor.setEventBroker(eventBroker);
                        		catalogEditor.create();
        						int returntype=catalogEditor.open();
        						if(returntype==Window.OK) {
        							treeViewer.refresh();
        						}
                        	};
    					});
                    	manager.add(new Action("Modifier") {
                        	public void run() {
                        		Catalog cat=null;
                        		if(object instanceof Catalog) {
                        			cat=(Catalog) object;
                        		}
                        		CreateCatalogEditorWindow catalogEditor =new CreateCatalogEditorWindow(parent.getShell(), cat, EditorWindow.update, ExportModuleWindow.isCatalog, null,null);
                        		catalogEditor.setEventBroker(eventBroker);
        						catalogEditor.create();
        						int returntype=catalogEditor.open();
        						if(returntype==Window.OK) {
        							treeViewer.refresh();
        						}
                        	};
    					});
                    }else  if(object instanceof MechanicDesignGroup){
                    	manager.add(new Action("Modifier") {
                        	public void run() { 
                        		Catalog cat=null;
                        		DesignClasse classe=null;
                        		if(object instanceof MechanicDesignGroup) {
                        			if(((MechanicDesignGroup) object).eContainer() instanceof Catalog) {
                						cat=(Catalog) ((MechanicDesignGroup) object).eContainer();
                        			}else {
                        				classe=(DesignClasse)((MechanicDesignGroup) object).eContainer();
                        			}
                        		}
                        		CreateCatalogEditorWindow catalogEditor =new CreateCatalogEditorWindow(parent.getShell(), cat, EditorWindow.update, !ExportModuleWindow.isCatalog, (MechanicDesignGroup) object,classe);
                        		catalogEditor.setEventBroker(eventBroker);
                        		catalogEditor.create();
        						int returntype=catalogEditor.open();
        						if(returntype==Window.OK) {
        							treeViewer.refresh();
        						}
                        	};
    					});
                    }else if(object instanceof DesignClasse) {
                    	manager.add(new Action("Ajouter un Group") {
                        	public void run() {
                        		DesignClasse cat=null;
                        		if(object instanceof DesignClasse) {
                        			cat=(DesignClasse) object;
                        		}
                        		CreateCatalogEditorWindow catalogEditor =new CreateCatalogEditorWindow(parent.getShell(), null, EditorWindow.create, !ExportModuleWindow.isCatalog, null,cat);
                        		catalogEditor.setEventBroker(eventBroker);
                        		catalogEditor.create();
        						int returntype=catalogEditor.open();
        						if(returntype==Window.OK) {
        							treeViewer.refresh();
        						}
                        	};
    					});
                    }
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        treeViewer.getControl().setMenu(menu);
		treeViewer.expandAll();
		tree.requestLayout();
		getShell().setText("Exporter un module");
		return tree;
	}

	/**
	 * 
	 */
	public void refreshTreeInput() {
		boolean isdev = ReportingPreferences.getInstance().getProperty("user.dev", false);

		List<BaseObject> input=new ArrayList<BaseObject>();
		if(isdev)
		{
			List<ModelRoot> roots = ResourceManagers.getIntance().getModelroots();
			for(ModelRoot modelroot:roots) {
				input.addAll(modelroot.getClasses().getDesignClasse());
			}
		}
		input.addAll(ResourceManagers.getIntance().getCatalogs());
		if(design instanceof MechanicDressing || design.getType().equals(PieceType.DRESSING)|| design.getType().equals(PieceType.CAISSON)|| design.isApplicable())
		{
			input.addAll(ResourceManagers.getIntance().getCatalogs());
		}

		treeViewer.setInput(input);
	}
	
	@Override
	protected Composite createButtonArea(Composite parent) {
		Composite buttonArea=super.createButtonArea(parent);
		GridLayout gl_composite_2 = new GridLayout(3, true);
		gl_composite_2.horizontalSpacing = 0;
		buttonArea.setLayout(gl_composite_2);
		Button btnCreateCatalog = new Button(buttonArea, SWT.NONE);
		btnCreateCatalog.setImage(ResourceManager.getPluginImage("Dressing", "icons/newproject.png"));
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 50;
		btnCreateCatalog.setLayoutData(gd_btnFermer);
		btnCreateCatalog.setText("Créer un catalogue");
		
		btnCreateCatalog.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						CreateCatalogEditorWindow catalogEditor =new CreateCatalogEditorWindow(parent.getShell(), null, EditorWindow.create, ExportModuleWindow.isCatalog, null,null);
						catalogEditor.setEventBroker(eventBroker);
						catalogEditor.create();
						int returntype=catalogEditor.open();
						if(returntype==Window.OK) {
							refreshTreeInput();
							treeViewer.refresh();
						}
					}
					
				});
		
		return buttonArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		
		try {
			// create DesignInstance and populate the appropriate attributes
			DesignInstance instance = ParamFactory.eINSTANCE.createDesignInstance();
			instance.setPublic(true);
			instance.setId(UUID.randomUUID());
			MechanicDesign model = design;
			// if the export is of the mode copy , we copy it and create a resource for it
			// to store separately
			if (isCopy()) {
				// create the MechanicDesign from the original
				model = EcoreUtil.copy(design);
				model.setModelId(UUID.randomUUID());
				model.setId(null);
				String designPath = parent.eResource().getURI().toFileString();
				designPath = designPath.substring(0, designPath.lastIndexOf('.')) + "\\" + model.getModelId() + ".data";
				URI uri = URI.createFileURI(designPath);
				Resource res = ResourceManagers.getIntance().getResSet().createResource(uri);
				res.getContents().clear();
				res.getContents().add(model);
				instance.setModelChangeable(true);
				instance.setChangeable(true);
			} else {
				// if the export of mode reference we just create the instance and make it just
				// reference the original and setModelChangeable(false) so it can't change the
				// original model,
				// it can change just the instance and choose the preferred values such as the
				// parameters and accessories
				instance.setModelChangeable(false);
				instance.setChangeable(true);
			}
			if(design instanceof MechanicDressing) {
				instance.setPublic(false);
				instance.setDressing(true);	
			}
			if(design.isApplicable() ) {
				instance.setApplicable(true);
			}
			if(design.getType().equals(PieceType.OBSTACLE)) {
				instance.setObstacle(true);
			}
			instance.setName(model.getName());
			instance.setDesign(model);
			// create primary options
			OptionGroup options = ParamFactory.eINSTANCE.createOptionGroup();
			Option primaryOption = ParamFactory.eINSTANCE.createOption();
			primaryOption.setLabel(model.getName());
			primaryOption.setName(model.getName());
			primaryOption.setModelId(UUID.randomUUID());
			primaryOption.setDefault(true);
			primaryOption.setVersion("1.0.0");
			primaryOption.setInjectedPublicParam(ParamFactory.eINSTANCE.createPublicParamGroup());
			options.getOptions().add(primaryOption);
			options.setSelectedOption(primaryOption);
			options.setId(UUID.randomUUID());
			instance.setOptions(options);
			instance.setPerviewPath(design.getPreviewImagePath());

			// add the designInstance to the choose parent group
			parent.getDesignsintances().add(instance);
//				String designPath=parent.eResource().getURI().toFileString();
//				designPath =designPath.substring(0, designPath.lastIndexOf('.'))+"\\"+instance.getDesign().getModelId()+".data";
			// save options first so the MechanicDesign can reference its correct path and
			// so is the mechanicDesign in relation to DesignInstance
			ResourceManagers.getIntance().saveResource(instance.getDesign().eResource());
			ResourceManagers.getIntance().saveResource(parent.eResource());
			eventBroker.send("update_DataModel", ResourceManagers.getIntance().getApplication());
			displayMessage((Shell) getShell().getParent(), "Module Exporter avec succées");

		} catch (Exception e) {
			e.printStackTrace();
		}		
		finish();
		return true;
	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		if(parent==null) {
			errorExist=true;
			errorMessage="La sélection d'un groupe est obligatoire";
		}
		return !errorExist;
	}

	public MechanicDesign getDesign() {
		return design;
	}

	public void setDesign(MechanicDesign design) {
		this.design = design;
	}
	
	public boolean isCopy() {
		return copy;
	}

	@Override
	protected void cancel() {
		// TODO Auto-generated method stub
		
	}
}
class LibraryTreeContentProvider implements ITreeContentProvider {
    @Override
    public boolean hasChildren(Object element) {
    	if(element!=null && element instanceof DesignClasse)
    	{
    		DesignClasse obj3d = (DesignClasse)element;
    		if(obj3d!=null && obj3d.getCategorie().size()>0)
    		{
    			return true;
    		}
    		return false;
    	}
    	if(element!=null && element instanceof Catalog)
    	{
    		Catalog obj3d = (Catalog)element;
    		if(obj3d!=null && obj3d.getCategorie()!=null && !obj3d.getCategorie().isEmpty())
    		{
    			return true;
    		}
    		return false;
    	}

        return false;
    }

    @Override
    public Object getParent(Object element) {
    	if(element!=null && element instanceof EObject)
    	{
    		EObject obj3d = (EObject)element;
    		return obj3d.eContainer();
    	}
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
    	
    	if(inputElement!=null && inputElement instanceof DesignClasse)
    	{
    		DesignClasse obj3d = (DesignClasse)inputElement;
    		if(obj3d!=null && obj3d.getCategorie().size()>0)
    		{
    			return obj3d.getCategorie().toArray();
    		}
    		//ne doit pas etre null
    		Object[] o = new Object[] {};
    		return o;
    	}
    	if(inputElement!=null && inputElement instanceof List)
    	{
    		if(!((List) inputElement).isEmpty() ) {
    			
    			return ((List) inputElement).toArray();
    			
    		}
    		//ne doit pas etre null
    		Object[] o = new Object[] {};
    		return o;
    	}
    	if(inputElement!=null && inputElement instanceof Catalog) {
    		
    		return ((Catalog)inputElement).getCategorie().toArray();
    	}
    	//ne doit pas etre null
    	Object[] o = new Object[] {};
		return o;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
    	if(parentElement!=null && parentElement instanceof DesignClasse)
    	{
    		DesignClasse obj3d = (DesignClasse)parentElement;
    		if(obj3d!=null && obj3d.getCategorie().size()>0)
    		{
    			return obj3d.getCategorie().toArray();
    		}
    		//ne doit pas etre null
    		Object[] o = new Object[] {};
    		return o;
    	}
    	if(parentElement!=null && parentElement instanceof Catalog) {   	
    		return ((Catalog)parentElement).getCategorie().toArray();
    	}
        return null;
    }
}