package dressing.ui.Assemblage;

import java.util.ArrayList;
import java.util.List;

import dressing.config.persistence.ResourceManagers;
import param.AssemblySystemCluster;
import param.AssemblySystemsPreference;
import param.AssemblySystemsPreferenceGroup;
import param.MechanicDesign;
import param.ParamFactory;

public class AssemblySystemsPreferenceController {

    private MechanicDesign design;

    public AssemblySystemsPreferenceController(MechanicDesign design) {
        this.design = design;
    }

    public MechanicDesign getDesign() {
		return design;
	}

	public void setDesign(MechanicDesign design) {
		this.design = design;
	}

	public List<PreferenceDisplayModel> loadAllPreferences() {
        List<PreferenceDisplayModel> displayList = new ArrayList<>();
        
        if (design.getAssemblySystemsPreferences() != null) {
            for (AssemblySystemsPreference pref : design.getAssemblySystemsPreferences().getPreferences()) {
                displayList.add(new PreferenceDisplayModel(design,pref, false));
            }
        }
        if (design.getInportedAssemblySystemsPreferences() != null) {
            for (AssemblySystemsPreference pref : design.getInportedAssemblySystemsPreferences()) {
                displayList.add(new PreferenceDisplayModel(design,pref, true));
            }
        }
        return displayList;
    }

    public void addOrUpdatePreference(AssemblySystemsPreference newPref) {
        AssemblySystemsPreferenceGroup group = design.getAssemblySystemsPreferences();
        if (group == null) {
            group =ParamFactory.eINSTANCE.createAssemblySystemsPreferenceGroup();
            design.setAssemblySystemsPreferences(group);
        }
        // Remove existing for same face
        group.getPreferences().removeIf(pref -> 
           ( pref.getFaceSide().equals(newPref.getFaceSide()) && !pref.isAllSides() && !newPref.isAllSides()) || (pref.isAllSides() && newPref.isAllSides())
        );
        // Add new one
        group.getPreferences().add(newPref);
    }

    public void removePreference(AssemblySystemsPreference prefToRemove) {
		AssemblySystemsPreferenceGroup group = design.getAssemblySystemsPreferences();
		if (prefToRemove != null && group != null && group.getPreferences() != null) {
			group.getPreferences().remove(prefToRemove);
		}
    }

	public List<AssemblySystemCluster> getClusters() {
		List<AssemblySystemCluster> clusters =new ArrayList<AssemblySystemCluster>();
		clusters.addAll(ResourceManagers.getIntance().getApplication().getAssemblySystems().getAssemblyClusters());
		List<PreferenceDisplayModel> preferences=loadAllPreferences();
		for(PreferenceDisplayModel model:preferences) {
			if(model!=null && model.getPref()!=null && model.getPref().getLocalAssemblySystem()!=null) {
				clusters.add(model.getPref().getLocalAssemblySystem());
			}
		}
		return clusters;
	}
}

