package dressing.ui.Assemblage;

import java.util.List;

import org.eclipse.emf.ecore.util.EcoreAdapterFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.wb.swt.ResourceManager;

import dressing.ui.util.EditorWindow;
import param.AssemblySystemCluster;
import param.AssemblySystemsPreference;
import param.MechanicDesign;
import param.ParamFactory;

public class AssemblyPreferencesComposite extends Composite {

	private TableViewer tableViewer;
	private Button addButton, editButton, removeButton;

	private final AssemblySystemsPreferenceController controller;

	public AssemblyPreferencesComposite(Composite parent, int style, MechanicDesign design) {
		super(parent, style);
		this.controller = new AssemblySystemsPreferenceController(design);
		createContents();
		refreshTable();
	}

	private void createContents() {
		setLayout(new GridLayout(2, false));
//		setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 4, 1));


		tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION | SWT.SINGLE);
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableViewer.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof PreferenceDisplayModel ) {
					AssemblySystemsPreference pref = ((PreferenceDisplayModel) element).getPref();
					String side = pref.getFaceSide().getLiteral();
					String cluster = pref.getAssemblySystem() != null ? pref.getAssemblySystem().getName() : "(Aucun)";
					return (((PreferenceDisplayModel) element).isInherited() ? "[Importer] " : "") + side + (pref.isAllSides() ? " (Tous les Faces)" : "") + " → " + cluster;
				}
				return super.getText(element);
			}
		});

		Table table = tableViewer.getTable();
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Composite tableGroup = new Composite(this, SWT.NONE);
		tableGroup.setLayout(new GridLayout(1, false));
		tableGroup.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, true, 1, 1));
		// Buttons
//		new Label(this, SWT.NONE); 
		
		addButton = new Button(tableGroup, SWT.PUSH);
		addButton.setText("Ajouter");
		addButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/ajout.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1);
		gd_btnRun.heightHint = 50;
		addButton.setLayoutData(gd_btnRun);
		addButton.addListener(SWT.Selection, e ->{
			PreferenceDisplayModel selected = getSelected();
			if (selected != null ) {
				
				AssemblySystemsPreference copy = EcoreUtil.copy(selected.getPref());
				if(selected.isInherited()) {
					if(copy.getLocalAssemblySystem()!=null) {
						copy.setAssemblySystem(copy.getLocalAssemblySystem());
					}
				}else {
					copy.setAssemblySystem(selected.getPref().getLocalAssemblySystem());
					copy.setLocalAssemblySystem(null);
				}
				openEditorDialog(copy,false );
			}else {
				openEditorDialog(ParamFactory.eINSTANCE.createAssemblySystemsPreference(),false );

			}
		});
		
		editButton = new Button(tableGroup, SWT.PUSH);		
		editButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/icons8-edit-16.png"));
		GridData gd_btnModify = new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1);
		gd_btnModify.heightHint = 50;
		editButton.setLayoutData(gd_btnModify);

		editButton.setText("Modifier");
		
		editButton.addListener(SWT.Selection, e -> {
			PreferenceDisplayModel selected = getSelected();
			if (selected != null ) {
				if(!selected.isInherited())
				{
					openEditorDialog(selected.getPref(),true);
				}else {
					AssemblySystemsPreference copy = EcoreUtil.copy(selected.getPref());
					if(copy.getLocalAssemblySystem()!=null)
					{
						copy.setAssemblySystem(copy.getLocalAssemblySystem());
					}
					openEditorDialog(copy,false );

				}
			}
		});

		removeButton = new Button(tableGroup, SWT.PUSH);
		removeButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/cancel_22X22.png"));
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1);
		gd_btnFermer.heightHint = 50;
		removeButton.setLayoutData(gd_btnFermer);
		removeButton.setText("Supprimer");
		
		removeButton.addListener(SWT.Selection, e -> {
			PreferenceDisplayModel selected = getSelected();
			if (selected != null && !selected.isInherited()) {
				boolean ret = MessageDialog.openConfirm(getShell(), "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
				if(ret) {
					controller.removePreference(selected.getPref());
					refreshTable();
				}
			}
		});
	}

	private void openEditorDialog(AssemblySystemsPreference existing,boolean isupdate) {
		 AssemblySystemsPreferenceEditorWindow editorWindow = new AssemblySystemsPreferenceEditorWindow(
			        getShell(),
			        controller,
			        existing,
			        isupdate? EditorWindow.update:EditorWindow.create
			    );
			    editorWindow.open();
			    
		if (editorWindow.getReturnCode() == Window.OK) {
			refreshTable();
		}
	}

	private void refreshTable() {
		tableViewer.setInput(controller.loadAllPreferences());
	}

	private PreferenceDisplayModel getSelected() {
		IStructuredSelection selection = tableViewer.getStructuredSelection();
		return (PreferenceDisplayModel) selection.getFirstElement();
	}
}
