package dressing.model.debitage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

import org.eclipse.emf.common.util.EList;
import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.EngineKeys;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import param.Cavity;
import param.CondtionalEquation;
import param.ImportedParams;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.Parameters;
import param.Rainure;
import param.UsinageNode;
import param.UsinageTrou;

public class GenericDebitageFormula extends DebitageFormulas {

	public GenericDebitageFormula() {
		super();
		// TODO Auto-generated constructor stub
	}

	public static  void filldebitagesequations(DesignObject3D parent,DesignObject3D child,Object emf,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams,ArrayList<Equation> equations) throws DesignException
	{
		if (child == null)
			throw new DesignException("Formule de debitage : child null");
		Bindings globalBindings = GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE);
		Bindings engineBindings = GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE);
		if(globalBindings != null)
		{
			globalBindings.clear();
			
		}else {
			GeomtericEngine.getLogicalEngine().setBindings(new SimpleBindings(), ScriptContext.GLOBAL_SCOPE);
		}
		if(engineBindings != null)
		{
			engineBindings.clear();
		}else {
			GeomtericEngine.getLogicalEngine().setBindings(new SimpleBindings(), ScriptContext.ENGINE_SCOPE);
		}

		// check exist logic
		try {
			// les parametres d usine doivent être les premier
			// fillequationsusinage(parent,child,equations); //scho 1953 les parametres d
			// usine doivent etre dans provate params
			if( ResourceManagers.getIntance().getApplication().getParametersgroups()!=null && ResourceManagers.getIntance().getApplication().getParametersgroups().getParameters()!=null)
			{
				FILL_USINAGE(ResourceManagers.getIntance().getApplication().getParametersgroups().getParameters(),equations);
			}
			fillequationsfromparent(parent, equations);
			fillequationsfromprivateparam(equations, privateparams);
			fillequationsfrompublicparam(equations, publicparams);
			if (parent != null) {
				GeomtericEngine.getLogicalEngine().put("PARENT", parent);
				GeomtericEngine.getLogicalEngine().put("CHILD", child);
				GeomtericEngine.getEngine().put("PARENT", parent);
				GeomtericEngine.getEngine().put("CHILD", child);
				fillEnginefromProps(parent);
			}
			//fill depuis child props le cas du child du type Space3DFree ou MechanicDesign
			if(child !=null && child instanceof Space3DFree) {
				fillEnginefromProps(child);
			}
			
			fillequationsfromemfmodel(child,equations, emf);
			// evaluer seulement si il ya exist expression
			boolean res = true;
			String existExpression= getExistExpression(emf);
			if (existExpression!=null && !existExpression.isEmpty()) {
				res = (boolean) GeomtericEngine.getLogicalEngine().eval(existExpression);
			}
			if(emf instanceof MechanicDesignElment) {
				MechanicDesignElment element=(MechanicDesignElment) emf;
				String solidExpression=element.getSolidExpression();
				if(solidExpression!=null && !solidExpression.isEmpty()) {
					boolean solid = (boolean) GeomtericEngine.getLogicalEngine().eval(solidExpression);
					child.put("SOLID_EXPRESSION", solid);
				}else {
					child.put("SOLID_EXPRESSION", true);
				}
			}
			child.put("EXIST", res);

			try {
				if(emf instanceof UsinageTrou) {
					UsinageTrou elment = ((UsinageTrou)emf);
					String haveOppositeExpression=elment.getHaveOppositeExpression();
					if(haveOppositeExpression!=null && !haveOppositeExpression.isEmpty())
					{
						boolean hasOpposite = (boolean) GeomtericEngine.getLogicalEngine().eval(haveOppositeExpression);
						child.put("HAS_OPPOSITE", hasOpposite);
						
					}
				}

			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				child.put("HAS_OPPOSITE", false);
			}
		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			child.put("EXIST", false);
			throw new DesignException(" Existence expression cannot be evaluated " + child.get("EXIST_EXPRESSION").toString());
		} finally {
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE).clear();
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE).clear();
		}

	}

	private static void fillEnginefromProps(DesignObject3D parent) throws DesignException {
		for (Entry<Object, Object> prop : parent.entrySet()) {
			if (prop.getKey().toString().startsWith("$")) {
				try {
					GeomtericEngine.getLogicalEngine().eval(parent.get(prop.getKey()).toString());
					GeomtericEngine.getEngine().eval(parent.get(prop.getKey()).toString());
				} catch (ScriptException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					throw new DesignException("La fonction " + prop.getKey().toString() + " cannot be evaluated");
				}
			} else {
				GeomtericEngine.getLogicalEngine().put((String) prop.getKey(), parent.get(prop.getKey()));
			}

		}
	}
	public static String getExistExpression(Object emf) {
		if(emf instanceof MechanicDesignElment) {
			MechanicDesignElment elment = ((MechanicDesignElment)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				return elment.getExistexpression();
			}
		}
		else if(emf instanceof UsinageTrou)
		{
			UsinageTrou elment = ((UsinageTrou)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				return elment.getExistexpression();
			}
		}
		else if(emf instanceof param.Rainure)
		{
			param.Rainure elment = ((param.Rainure)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				return elment.getExistexpression();
			}
		}
		else if(emf instanceof Cavity)
		{
			Cavity elment = ((Cavity)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				return elment.getExistexpression();
			}
		}else if( emf instanceof UsinageNode) {
			return ((UsinageNode) emf).getExistexpression();
		}
		
		return null;
	}

	private static void fillequationsfromemfmodel(DesignObject3D child, ArrayList<Equation> equations,Object emf ) throws DesignException {	
		
		//fill default parmeter of the piece
		fillequationsfromchildequations(equations,child.getSystemEquation(emf));	
		
		//override with specfic 
		if(emf instanceof MechanicDesign)
		{
			fillequationsfromgenericequations(equations,((MechanicDesign)emf).getEquation());	
		}
		else if(emf instanceof MechanicDesignElment)
		{
			fillequationsfromgenericequations(equations,((MechanicDesignElment)emf).getEquation());	
		}
		else if( emf instanceof UsinageTrou)			
		{
			fillequationsfromgenericequations(equations,((UsinageTrou)emf).getEquation());	
		}
		else if( emf instanceof Rainure)			
		{
			fillequationsfromgenericequations(equations,((Rainure)emf).getEquation());	
		}
		else if( emf instanceof Cavity)			
		{
			fillequationsfromgenericequations(equations,((Cavity)emf).getEquation());	
		}

		
	}
	private static void fillequationsfromchildequations(ArrayList<Equation> equations, List<Couple> systemEquation) {
		if(systemEquation!=null) {
			for(Couple c  : systemEquation)
			{
				if(c.getKey()!=null && !c.getKey().isEmpty() && c.getExpr()!=null && !c.getExpr().isEmpty())
				{
					String tempkey = c.getKey().replace("@", "");
					ADDOrUpdateEquation("@"+tempkey+"@", c.getExpr(), Equation.CALCULATION_MANUAL,equations);	
				}
				
			}
		}
		
	}

	public static void fillequationsfromgenericequations(ArrayList<Equation> equations,List<param.Equation> list) throws DesignException {		
		List<param.Equation> eListequation2 = list;
		
		for(param.Equation eq : eListequation2)
		{
			boolean foundexpression = false;
			String tempkey=null;
			if(!eq.getCondtionalequation().isEmpty())
			{
				for(CondtionalEquation cond  : eq.getCondtionalequation())
				{
					if(cond.getWhenexpression()!=null)
					{
						try {
						 boolean res = 	(boolean) GeomtericEngine.getLogicalEngine().eval(cond.getWhenexpression());
						 if(res)
						 {
							if(eq.getKey()!=null && !eq.getKey().isEmpty()  )
								{
								    tempkey = "@"+eq.getKey().replace("@", "")+"@";
									ADDOrUpdateEquation(tempkey, cond.getExpression(), Equation.CALCULATION_MANUAL,equations);	
								}
							foundexpression = true;
							break;
						 }
						} catch (ScriptException e) {
							// TODO Auto-generated catch block
							
							e.printStackTrace();
							foundexpression = false;
							throw new DesignException(" When expression cannot be evaluated " + cond.getWhenexpression());
						}
					}

				}
			}
			if(!foundexpression)
			{
				if(eq.getKey()!=null && !eq.getKey().isEmpty() && eq.getExpression()!=null && !eq.getExpression().isEmpty())
				{
					tempkey = "@"+eq.getKey().replace("@", "")+"@";
					ADDOrUpdateEquation(tempkey, eq.getExpression(), Equation.CALCULATION_MANUAL,equations);	
				}
			}
			
		}
		
	}

	protected static void fillequationsfrompublicparam(ArrayList<Equation> equations,List<MechanicPublicParam> publicparams2) {

		for(MechanicPublicParam eq : publicparams2)
		{
			if(eq.getKey()!=null && !eq.getKey().isEmpty())
			{
				if( eq.getDefaultvalue()!=null && !eq.getDefaultvalue().isEmpty())
				{	
				
	 				String tempkey = eq.getKey().replace("@", "");
					if(eq.getKey().contains("_")&&!eq.getKey().contains(".")) {
						GeomtericEngine.getLogicalEngine().put(tempkey, eq.getDefaultvalue());
						tempkey = tempkey.replace('_', '.');			
					}else {
						GeomtericEngine.getLogicalEngine().put(tempkey.replace('.', '_'), eq.getDefaultvalue());
					}
					ADDOrUpdateEquation("@"+tempkey+"@", eq.getDefaultvalue(), Equation.CALCULATION_MANUAL,equations);	
				}else if(eq.getTypedef()!=null && eq.getTypedefelement()!=null) {
					String tempkey = eq.getKey().replace("@", "");
					tempkey=tempkey.replace('.', '_');
					GeomtericEngine.getLogicalEngine().put(tempkey, eq.getTypedefelement().getKey());
				}
			}
		}
	}
	protected static void fillequationsfromImportedParam(ArrayList<Equation> equations,EList<ImportedParams> importedParams) {

		for(ImportedParams eq : importedParams)
		{
			if(eq.getKey()!=null && !eq.getKey().isEmpty())
			{
				if( eq.getDefaultvalue()!=null && !eq.getDefaultvalue().isEmpty())
				{	
				
	 				String tempkey = eq.getKey().replace("@", "");
					if(eq.getKey().contains("_")&&!eq.getKey().contains(".")) {
						if(!eq.getDefaultvalue().contains("@"))
						{
							GeomtericEngine.getLogicalEngine().put(tempkey, eq.getDefaultvalue());
						}
						tempkey = tempkey.replace('_', '.');			
					}else {
						if(!eq.getDefaultvalue().contains("@"))
						{
							GeomtericEngine.getLogicalEngine().put(tempkey.replace('.', '_'), eq.getDefaultvalue());
						}
					}
					ADDOrUpdateEquation("@"+tempkey+"@", eq.getDefaultvalue(), Equation.CALCULATION_MANUAL,equations);	
				}else if(eq.getTypedef()!=null && eq.getTypedefelement()!=null) {
					String tempkey = eq.getKey().replace("@", "");
					tempkey=tempkey.replace('.', '_');
					GeomtericEngine.getLogicalEngine().put(tempkey, eq.getTypedefelement().getKey());
				}
			}
		}
	}

	protected static void fillequationsfromprivateparam( ArrayList<Equation> equations,	List<MechanicPrivateParam> privateparams2) {
		// TODO Auto-generated method stub
		for(MechanicPrivateParam eq : privateparams2)
		{
			if(eq.getKey()!=null && !eq.getKey().isEmpty() )
			{
				if(eq.getValue()!=null && !eq.getValue().isEmpty())
				
				{
					String tempkey = eq.getKey().replace("@", "");
					if(eq.getKey().contains("_")&&!eq.getKey().contains(".")) {
						if(!eq.getValue().contains("@"))
						{
						GeomtericEngine.getLogicalEngine().put(tempkey, eq.getValue());
						}
						tempkey = tempkey.replace('_', '.');
					}else {
						if(!eq.getValue().contains("@"))
						{
						GeomtericEngine.getLogicalEngine().put(tempkey.replace('.', '_'), eq.getValue());
						}
					}
					ADDOrUpdateEquation("@"+tempkey+"@", eq.getValue(), Equation.CALCULATION_MANUAL,equations);	
				}else if(eq.getTypedef()!=null && eq.getTypedefelement()!=null) {
					String tempkey = eq.getKey().replace("@", "");
					tempkey=tempkey.replace('.', '_');
					GeomtericEngine.getLogicalEngine().put(tempkey, eq.getTypedefelement().getKey());
				}
				
			}	
			
		}
	}

	protected static void    fillequationsfromparent(Object parent,ArrayList<Equation> equations)
	{
		if(parent!= null && parent instanceof Space3D)
		{
			Space3D space3d = (Space3D)parent;
			ADDOrUpdateEquation(EngineKeys.parentLongeurExt, ""+space3d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureExt, ""+space3d.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
			ADDOrUpdateEquation(EngineKeys.parentProfondeurExt, ""+space3d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentLongeurint, ""+space3d.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureint, ""+space3d.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
			ADDOrUpdateEquation(EngineKeys.parentProfondeurint, ""+space3d.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;				
			ADDOrUpdateEquation(EngineKeys.parentposx, ""+space3d.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposy, ""+space3d.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposz, ""+space3d.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurPrincipale, ""+space3d.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurSecondaire, ""+space3d.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentLongeurExt.replaceAll("@", "").replace('.', '_'), space3d.getLongeurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentHauteureExt.replaceAll("@", "").replace('.', '_'), space3d.getHauteurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentProfondeurExt.replaceAll("@", "").replace('.', '_'), space3d.getProfondeurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentLongeurint.replaceAll("@", "").replace('.', '_'), space3d.getLongeurint());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentHauteureint.replaceAll("@", "").replace('.', '_'), space3d.getHauteurint());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentProfondeurint.replaceAll("@", "").replace('.', '_'), space3d.getProfondeurint());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposx.replaceAll("@", "").replace('.', '_'), space3d.getXpos());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposy.replaceAll("@", "").replace('.', '_'), space3d.getYpos());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposz.replaceAll("@", "").replace('.', '_'), space3d.getZpos());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentEpaisseurPrincipale.replaceAll("@", "").replace('.', '_'), space3d.getBasematerial().getEpaisseur());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentEpaisseurSecondaire.replaceAll("@", "").replace('.', '_'), space3d.getBackmaterial().getEpaisseur());

			
		}
		
		if(parent!= null && parent instanceof Piece2D)
		{
			Piece2D piece2d = (Piece2D)parent;
			ADDOrUpdateEquation(EngineKeys.parentLongeurExt, ""+piece2d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentProfondeurExt, ""+piece2d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureExt, ""+piece2d.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
			//
			ADDOrUpdateEquation(EngineKeys.parentLongeurint, ""+piece2d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentProfondeurint, ""+piece2d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentHauteureint, ""+piece2d.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
			//
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurSecondaire, ""+(piece2d.getMaterial()!=null? piece2d.getMaterial().getEpaisseur():0), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentEpaisseurPrincipale, ""+(piece2d.getMaterial()!=null? piece2d.getMaterial().getEpaisseur():0), Equation.CALCULATION_MANUAL,equations) ;
			//
			ADDOrUpdateEquation(EngineKeys.parentposx, ""+piece2d.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposy, ""+piece2d.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
			ADDOrUpdateEquation(EngineKeys.parentposz, ""+piece2d.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentLongeurExt.replaceAll("@", "").replace('.', '_'), piece2d.getLongeurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentHauteureExt.replaceAll("@", "").replace('.', '_'), piece2d.getHauteurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentProfondeurExt.replaceAll("@", "").replace('.', '_'), piece2d.getProfondeurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentLongeurint.replaceAll("@", "").replace('.', '_'), piece2d.getLongeurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentHauteureint.replaceAll("@", "").replace('.', '_'), piece2d.getHauteurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentProfondeurint.replaceAll("@", "").replace('.', '_'), piece2d.getProfondeurext());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposx.replaceAll("@", "").replace('.', '_'), piece2d.getXpos());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposy.replaceAll("@", "").replace('.', '_'), piece2d.getYpos());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentposz.replaceAll("@", "").replace('.', '_'), piece2d.getZpos());
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentEpaisseurPrincipale.replaceAll("@", "").replace('.', '_'), piece2d.getMaterial()!=null? piece2d.getMaterial().getEpaisseur():0);
			GeomtericEngine.getLogicalEngine().put(EngineKeys.parentEpaisseurSecondaire.replaceAll("@", "").replace('.', '_'), piece2d.getMaterial()!=null? piece2d.getMaterial().getEpaisseur():0);

		}
	}
	
	protected static void FILL_USINAGE(EList<Parameters> eList,ArrayList<Equation> equations) {
		if(eList!=null) {
			for(Parameters param:eList) {
				if(param!=null&& param.getCode()!=null&& param.getValue()!=null) {
					ADDOrUpdateEquation(param.getCode(),param.getValue() ,Equation.CALCULATION_MANUAL,equations);
				}
				
			}
		}
		
	}	
}
