package dressing.model;

import java.util.ArrayList;
import java.util.List;

import org.frs.debitage.engine.core.evalutor.Couple;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.Direction;
import dressing.cam.model.PlanUsinage;
import param.UsinageTrou;

/**
 * @Bug 0001217: ajouter le calcul des rainure et les trous d'usinage
 * @author Imed
 *
 */
public class Trou extends Usinage{

	private double depth;	
	private double oppositeTrouDepth;
	private double diameter;
	private double oppositeDiameter;
	private Direction direction;
	
	public Trou(Direction direction) {
		this.direction = direction;
	}
	
	public Trou() {
	}
	
	
	
	public Vector3 getStart() {
		Vector3 start = new Vector3();
		start.set((float)getXpos(), (float)getYpos(), (float)getZpos());
		return start;
	}

	public Vector3 getEnd() {
		Vector3 end = new Vector3();
		
		switch (direction) {
		case XMINUS:
			end.set((float) -getDepth(), 0 , 0);
			break;
		case XPLUS:
			end.set((float) getDepth(), 0 , 0);
			break;
		case YMINUS:
			end.set(0 ,(float) -getDepth(),  0);
			break;
		case YPLUS:
			end.set(0 ,(float) getDepth(),  0);
			break;
		case ZMINUS:
			end.set(0 ,0 ,(float) -getDepth());
			break;
		case ZPLUS:
			end.set(0 ,0 ,(float) getDepth());
			break;
		default:
			break;
		}
		end.add(getStart());
		return end;
	}

	public double getDepth() {
		return depth;
	}
	public double getDiameter() {
		return diameter;
	}

	public void setDepth(double depth) {
		double oldValue = this.depth;
		this.depth = depth;
		firePropertyChange("depth", oldValue, depth);
	}
	
	public double getOppositeTrouDepth() {
		return oppositeTrouDepth;
	}

	public void setOppositeTrouDepth(double oppositeTrouDepth) {
		double oldValue = this.oppositeTrouDepth;
		this.oppositeTrouDepth = oppositeTrouDepth;
		firePropertyChange("oppositeTrouDepth", oldValue, oppositeTrouDepth);
	}

	public void setDiameter(double diameter) {
		double oldValue = this.diameter;
		this.diameter = diameter;
		firePropertyChange("diameter", oldValue, diameter);
	}
	
	public double getOppositeDiameter() {
		return oppositeDiameter;
	}

	public void setOppositeDiameter(double oppositeDiameter) {
		double oldValue = this.oppositeDiameter;
		this.oppositeDiameter = oppositeDiameter;
		firePropertyChange("oppositeDiameter", oldValue, oppositeDiameter);
	}

	public void setDirection(Direction direction) {
		Direction oldValue = this.direction;
		this.direction = direction;
		firePropertyChange("direction", oldValue, direction);
	}
	public Direction getDirection() {
		return direction;
	}

	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}
	
	@Override
	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException {
		// TODO Auto-generated method stub
		setNotificationon(false);
		Equation eq = null;
		try {
			if (equations != null) {
				eq = Equation.FIND_EQUATION(EngineKeys.troudiametre, equations);
				if (eq != null) {
					GeomtericEngine.getInstance().resolveEquation(eq);
					setDiameter(eq.getEvaluation(null));
				} else {
					throw new GeometricEngineException(EngineKeys.troudiametre+" not found to update");
				}
				eq = Equation.FIND_EQUATION(EngineKeys.troudepth, equations);
				if (eq != null) {
					GeomtericEngine.getInstance().resolveEquation(eq);
					setDepth(eq.getEvaluation(null));
				} else {
					throw new GeometricEngineException(EngineKeys.troudepth+" not found to update");
				}
				eq = Equation.FIND_EQUATION(EngineKeys.opposite_troudepth, equations);
				if (eq != null) {
					GeomtericEngine.getInstance().resolveEquation(eq);
					setOppositeTrouDepth(eq.getEvaluation(null));
				} else {
					System.err.println(EngineKeys.opposite_troudepth+" not found to update");
					setOppositeTrouDepth(this.depth);
				}
				//
				eq = Equation.FIND_EQUATION(EngineKeys.opposite_troudiametre, equations);
				if (eq != null) {
					GeomtericEngine.getInstance().resolveEquation(eq);
					setOppositeDiameter(eq.getEvaluation(null));
				} else {
					System.err.println(EngineKeys.opposite_troudiametre+" not found to update");
					setOppositeDiameter(this.diameter);
				}
				//
				eq  = Equation.FIND_EQUATION(EngineKeys.posx, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setXpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(EngineKeys.posx+" not found to update");
				}
				
				eq  = Equation.FIND_EQUATION(EngineKeys.posy, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setYpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(EngineKeys.posy+" not found to update");
				}
				
				eq  = Equation.FIND_EQUATION(EngineKeys.posz, equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setZpos(eq.getEvaluation(null));

				}
				else
				{
					throw new GeometricEngineException(EngineKeys.posz+" not found to update");
				}
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		} finally {
			setNotificationon(true);
		}
	}
	@Override
	public String toString() {
		return "Trou"+ getName()+"[xcenter=" + getXpos() + ", ycenter=" + getYpos() + ", zcenter=" + getZpos() + ", depth=" + depth
				+ ", diameter=" + diameter + ", direction=" + direction + "]";
	}
	public boolean isLateral(PlanUsinage pl) {
		switch (pl) {
		case FRONT:
			return getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case BACK:
			return getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case RIGHT:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case LEFT:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
			||getDirection() == Direction.YPLUS ||getDirection() == Direction.YMINUS;
		case DOWN:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
				|| getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS;
		case TOP:
			return getDirection() == Direction.ZMINUS ||getDirection() == Direction.ZPLUS
			|| getDirection() == Direction.XMINUS ||getDirection() == Direction.XPLUS;
		default:
			break;
		}
		return false;
	}

	
	@Override
	public boolean isSolid(PlanUsinage pl) {
		switch (pl) {
		case FRONT:
			return getDirection() == Direction.ZMINUS;
		case BACK:
			return getDirection() == Direction.ZPLUS;
		case RIGHT:
			return getDirection() == Direction.XMINUS;
		case LEFT:
			return getDirection() == Direction.XPLUS;
		case DOWN:
			return getDirection() == Direction.YPLUS;
		case TOP:
			return getDirection() == Direction.YMINUS;
		default:
			break;
		}

		return false;
	}
	
	@Override
	public PlanUsinage getprimaryPlan() {
		switch (getDirection()) {
		case XMINUS:
			return PlanUsinage.RIGHT;
		case XPLUS:
			return PlanUsinage.LEFT;
		case YMINUS:
			return PlanUsinage.TOP;
		case YPLUS:
			return PlanUsinage.DOWN;
		case ZMINUS:
			return PlanUsinage.FRONT;			
		case ZPLUS:
			return PlanUsinage.BACK;			
		default:
			return PlanUsinage.FRONT;
		}
		
		
	}
	
	public List<Couple> getSystemEquation(Object emf) {
		List<Couple> systemesequations=new ArrayList<Couple>();
		if(emf instanceof UsinageTrou && emf != null )
		{					
			UsinageTrou utr = (UsinageTrou)emf;
			systemesequations.add(new Couple(EngineKeys.posx, utr.getX()));
			systemesequations.add(new Couple(EngineKeys.posy, utr.getY()));
			systemesequations.add(new Couple(EngineKeys.posz, utr.getZ()));
			systemesequations.add(new Couple(EngineKeys.troudiametre, utr.getDiameter()));
			systemesequations.add(new Couple(EngineKeys.troudepth, utr.getProfondeur()));
			if(!utr.isHaveopposite() && (utr.getHaveOppositeExpression().isEmpty()||utr.getHaveOppositeExpression().trim().contentEquals("false"))) {
				systemesequations.add(new Couple(EngineKeys.opposite_troudepth, utr.getProfondeur()));
				systemesequations.add(new Couple(EngineKeys.opposite_troudiametre, utr.getDiameter()));
			}else {
				systemesequations.add(new Couple(EngineKeys.opposite_troudepth, utr.getOppositeProfondeur()));
				systemesequations.add(new Couple(EngineKeys.opposite_troudiametre, utr.getOppositeDiameter()));
			}
			
			return systemesequations;
		}
		return systemesequations;
	}

	public Point3D getEndPoint() {
		Point3D point=new Point3D();
		double x=getXPosABS();
		double y=getYPosABS();
		double z=getZPosABS();
		
		Direction direction =getDirection();
		switch (direction) {
		case XMINUS:
			x=getXPosABS() -getDepth();
			break;
		case XPLUS:
			x=getXPosABS()+getDepth();
			break;
		case YMINUS:
			y=getYPosABS()-getDepth();
			break;
		case YPLUS:
			y=getYPosABS()+getDepth();
			break;
		case ZMINUS:
			z=getZPosABS()-getDepth();
			break;
		case ZPLUS:
			z=getZPosABS()+getDepth();
			break;
		default:
			break;
		}
			point.setX(x);
			point.setY(y);
			point.setZ(z);
			
		return point;
	}
	
	public Direction getOppositeDirection() {
		
		Direction direction =getDirection();
		switch (direction) {
		case XMINUS:
			return Direction.XPLUS;
		case XPLUS:
			return Direction.XMINUS;
		case YMINUS:
			return Direction.YPLUS;
		case YPLUS:
			return Direction.YMINUS;
		case ZMINUS:
			return Direction.ZPLUS;			
		case ZPLUS:
			return Direction.ZMINUS;			
		default:
			return Direction.XPLUS;
		}
			
			
		 
	}

}
