package dressing.model;

public class TransformManagerFactory {

	public static void assign(Solide3D solide) {
	        if (solide instanceof Piece2D) {
	        	
	            // Also assign the 3D base manager if needed
	        	solide.setTransformManager(new Piece2DVecmathTransformManager(solide));
	        } 
	        else if (solide instanceof DesignObject3D) {
	            // Fallback for all other 3D design objects
	        	solide.setTransformManager(new VecmathTransformManager(solide));
	        }
	    }
}
