package dressing.model;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import param.ChainOfResponsabilityController;
import param.ImportedParams;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.ParamFactory;
import param.PieceType;
import param.PrivateParamGroup;
import param.PublicParamGroup;
import param.TypeDef;

public class MechanicDesignCreator {
	public static int create=1;
	public static int open=2;
	public static int update=3;
	public static int preview=4;

	public static boolean createUsinage=true;
	public static boolean isDirectParent=true;
	public static boolean isCreatedFromParentChilds=true;

	private static MechanicDesignCreator instance ;
	public static MechanicDesignCreator getInstance() {
		synchronized(MechanicDesignCreator.class) {
			if (instance == null) {
				instance = new MechanicDesignCreator();
			}
			return instance;
		}
	}
	
	public MechanicDesignCreator() {}
	public DesignObject3D constructObject(MechanicDesign mechanicdesign,DesignObject3D parent,DesignObject3D rootspace) throws Exception
	{
		return constructObject( mechanicdesign,parent, rootspace,MechanicDesignCreator.isDirectParent,MechanicDesignCreator.isCreatedFromParentChilds);
	}
	public DesignObject3D constructObject(MechanicDesign mechanicdesign,DesignObject3D parent, boolean isDirectParent, boolean isCreatedFromParentChilds) throws Exception
	{
		return constructObject( mechanicdesign,parent, null,isDirectParent,isCreatedFromParentChilds);
	}
	public DesignObject3D constructObject(MechanicDesign mechanicdesign,DesignObject3D parent,DesignObject3D rootspace,boolean isDirectParent, boolean isCreatedFromParentChilds) throws Exception
	{
		return constructObject(parent, rootspace,mechanicdesign,MechanicDesignCreator.create, !MechanicDesignCreator.createUsinage, isDirectParent, isCreatedFromParentChilds);
	}
	public DesignObject3D constructObject( DesignObject3D parent , DesignObject3D rootspace 
			, MechanicDesign mechanicdesign,int update) throws Exception {
		return constructObject(parent, rootspace,mechanicdesign,update, !MechanicDesignCreator.createUsinage, MechanicDesignCreator.isDirectParent, !MechanicDesignCreator.isCreatedFromParentChilds);

	}
	public DesignObject3D constructObject(MechanicDesign mechanicdesign,int update) throws Exception {
		return constructObject(null, null,mechanicdesign,update, !MechanicDesignCreator.createUsinage, MechanicDesignCreator.isDirectParent, !MechanicDesignCreator.isCreatedFromParentChilds);

	}
	
	public DesignObject3D constructObject(MechanicDesign mechanicdesign) throws Exception {
		return constructObject(null, null,mechanicdesign,MechanicDesignCreator.create, !MechanicDesignCreator.createUsinage, MechanicDesignCreator.isDirectParent, !MechanicDesignCreator.isCreatedFromParentChilds);
	}
	
	public DesignObject3D constructObject( DesignObject3D parent , DesignObject3D rootspace 
			, MechanicDesign mechanicdesign,int update,boolean createUsinage,boolean isDirectParent, boolean isCreatedFromParentChilds) throws Exception {

		if(isDirectParent && parent!=null && parent.getRootModule()!=null) {
			DesignObject3D processedParent = MechanicDesignDelimitersSystemManager.preprocessParent(parent, mechanicdesign);
			if (processedParent != parent) {
			    parent = processedParent;
			    isDirectParent = false;
			}
			
		    DesignObject3D oldInstance = MechanicDesignDelimitersSystemManager.getExistingInstanceFromRootModule(parent, mechanicdesign);
			if (oldInstance != null) {
				rootspace = oldInstance;
				oldInstance.clearautomatique(false);
			}
		}
		// 3. Determine parentDesign (could be parent's parent if !isDirectParent)
	    DesignObject3D parentDesign = isDirectParent ? parent : parent.getParentdesign();
	    // 4. Build object based on type
	    DesignObject3D src;
		//build design
	    switch (mechanicdesign.getType()) {
        case SPACE3D:
        case CAISSON:
        case DRESSING:
        case ACCESOIRE:
            src = buildSpace3DObject(parent, rootspace, mechanicdesign, update, createUsinage, isDirectParent, parentDesign);
            break;
        case PIECE2D:
            src = buildPiece2DObject(parent, rootspace, mechanicdesign, update, createUsinage, isDirectParent, parentDesign);
            if (src == null) return null;
            if(src.getVolume()<=0) {
            	parentDesign.deletechild(src);
            	return null;
            }
            break;
        case OBSTACLE:
            src = buildObstacleObject(parent, rootspace, mechanicdesign, update, parentDesign);
            break;
        default:
            throw new IllegalArgumentException("Unknown PieceType: " + mechanicdesign.getType());
	    }

		Space3D rootModule =src.getParentdesign()==null?null: (Space3D) src.getParentdesign().getRootModule();

		// 5. Update delimiters and check collisions
		DesignObject3D collusion = MechanicDesignDelimitersSystemManager.updateDelimitersAndCheckCollisions(
				mechanicdesign, update, isCreatedFromParentChilds, src, parentDesign, rootModule);
		if (collusion != null) {
			return collusion;
		}

	    // 6. Post build updates and cleanup
	    postBuildUpdates(mechanicdesign, update, createUsinage, src, parentDesign);

	    return src;
	}

	private void postBuildUpdates(MechanicDesign mechanicdesign, int update, boolean createUsinage, DesignObject3D src,
			DesignObject3D parentDesign) throws Exception {
		if (mechanicdesign.getStructureAction() != null) {
			MechanicDesignScriptManager.excuteStructureActions(src, mechanicdesign);
		}

		upateMechanicDesignChildren(mechanicdesign, update, createUsinage, src, parentDesign);

		MechanicDesignDelimitersSystemManager.cleanUP(src, update);
		if(createUsinage) {
			MechanicDesignUsinageManager.createUsinage(src, false);
		}else
		if ((mechanicdesign.getMechanicelementgroup() != null
				&& mechanicdesign.getMechanicelementgroup().getMechanicdesignelment().size() > 0)
				|| mechanicdesign.getType().equals(PieceType.ACCESOIRE)) {
			MechanicDesignUsinageManager.createUsinage(src, true);
		}
	}
	
	private DesignObject3D adjustPositionAndParent(DesignObject3D child, DesignObject3D parent) {
		if (child == null || parent == null)
			return null;

		DesignObject3D parentDesign = parent.getParentdesign();
		child.setXpos(child.getXpos() + parent.getXpos());
		child.setYpos(child.getYpos() + parent.getYpos());
		child.setZpos(child.getZpos() + parent.getZpos());
		child.setParentdesign(parentDesign);
		return parentDesign;
	}
	
	private DesignObject3D buildPiece2DObject(DesignObject3D parent, DesignObject3D rootspace,
	        MechanicDesign mechanicdesign, int update, boolean createUsinage, boolean isDirectParent,
	        DesignObject3D parentDesign) throws Exception {
		Piece2D piece=null;
		if(rootspace instanceof Piece2D ) {
			piece=(Piece2D) rootspace;
		}
		MechanicDesignMaterialsHelper.setDefaultMaterialifNull(mechanicdesign);
		EList<MechanicPrivateParam> privateparams = mechanicdesign.getPrivateparamgroup().getMechanicprivateparam();
		EList<MechanicPublicParam> publicparams = mechanicdesign.getPublicparamgroup().getMechanicpublicparam();
		syncParamsFromParentDesign(mechanicdesign, parentDesign);
//		List<DesignObject3D> pieces=buildDesignElements(parent, mechanicdesign, privateparams, publicparams,update,createUsinage);
		piece =buildDesignElement(mechanicdesign, mechanicdesign.getMechanicelementgroup().getMechanicdesignelment().get(0),piece, parent, privateparams, publicparams, update, createUsinage);
		if(piece==null) {
			if(rootspace!=null) {
				Space3D rootModule = (Space3D) rootspace.getParentdesign().getRootModule();
				rootModule.getDependenceController().deleteDesign(mechanicdesign);
			}
			return null;
		}
		if(!isDirectParent) {
			parentDesign =	adjustPositionAndParent(piece, parent);
		}
		if(mechanicdesign.getId()==null|| update==MechanicDesignCreator.create) {
			UUID id=UUID.randomUUID();
			mechanicdesign.setId(id);
		}
		piece.setName(mechanicdesign.getName());
		mechanicdesign.setInstance(piece);
		
		if(parentDesign!=null && (update !=MechanicDesignCreator.update || !parentDesign.getChilds().contains(piece)))
		{			
			parentDesign.addElement(piece);
		}
		if(parentDesign!=null && update !=MechanicDesignCreator.update)
		{			
			if(parentDesign.getMechanicDesignDefinition()!=null ) {
				parentDesign.getMechanicDesignDefinition().getMechanicdesign().add(mechanicdesign);
			}
		}
		
		return piece;
	}
	
	private DesignObject3D buildSpace3DObject(DesignObject3D parent, DesignObject3D rootspace,
			MechanicDesign mechanicdesign, int update, boolean createUsinage, boolean isDirectParent,
			DesignObject3D parentDesign) throws Exception {
		// Prepare params
		EList<MechanicPrivateParam> privateparams = mechanicdesign.getPrivateparamgroup().getMechanicprivateparam();
		EList<MechanicPublicParam> publicparams = mechanicdesign.getPublicparamgroup().getMechanicpublicparam();

		// Sync params from parent design
		syncParamsFromParentDesign(mechanicdesign, parentDesign);

		rootspace = initializeRootspace(rootspace, mechanicdesign, parent);
		setupMaterialAndParams(mechanicdesign, rootspace, privateparams, publicparams, update);

		// Build child pieces
		List<Piece2D> pieces = buildDesignElements(rootspace, mechanicdesign, privateparams, publicparams, update,
				createUsinage);
		for (DesignObject3D piece : pieces) {
			rootspace.addElement(piece);
		}

		// Adjust position and parenting if not direct
		if (!isDirectParent) {
			parentDesign = adjustPositionAndParent(rootspace, parent);
		}

		// Add to parent design children if applicable
		if (parentDesign != null
				&& (update != MechanicDesignCreator.update || !parentDesign.getChilds().contains(rootspace))) {
			parentDesign.addElement(rootspace);
		}
		if (parentDesign != null && update != MechanicDesignCreator.update) {
			if (parentDesign instanceof Space3DFree && parentDesign.getMechanicDesignDefinition() != null) {
				parentDesign.getMechanicDesignDefinition().getMechanicdesign().add(mechanicdesign);
			}
		}

		return rootspace;
	}

	private DesignObject3D buildObstacleObject(DesignObject3D parent, DesignObject3D rootspace,
			MechanicDesign mechanicdesign, int update, DesignObject3D parentDesign) throws Exception {
		EList<MechanicPrivateParam> privateparams = mechanicdesign.getPrivateparamgroup().getMechanicprivateparam();
		EList<MechanicPublicParam> publicparams = mechanicdesign.getPublicparamgroup().getMechanicpublicparam();

		// Sync params from parent design
		syncParamsFromParentDesign(mechanicdesign, parentDesign);

		rootspace = initializeRootspace(rootspace, mechanicdesign, parent);
		setupMaterialAndParams(mechanicdesign, rootspace, privateparams, publicparams, update);

		List<Piece2D> pieces = buildDesignElements(rootspace, mechanicdesign, privateparams, publicparams, update,
				false);
		for (DesignObject3D piece : pieces) {
			rootspace.addElement(piece);
		}

		if (parentDesign != null
				&& (update != MechanicDesignCreator.update || !parentDesign.getChilds().contains(rootspace))) {
			parentDesign.addElement(rootspace);
		}
		if (parentDesign != null && update != MechanicDesignCreator.update) {
			if (parentDesign instanceof Space3DFree && parentDesign.getMechanicDesignDefinition() != null) {
				parentDesign.getMechanicDesignDefinition().getMechanicdesign().add(mechanicdesign);
			}
		}

		return rootspace;
	}
	/**
	 * @param mechanicdesign
	 * @param parentDesign
	 * @param importedParams
	 * @throws Exception
	 */
	public void syncParamsFromParentDesign(MechanicDesign mechanicdesign, DesignObject3D parentDesign) throws Exception {
		EList<ImportedParams> importedParams = mechanicdesign.getImportparamgroup().getImportedparams();
		if (parentDesign != null && parentDesign.getMechanicDesignDefinition() != null) {
			if (importedParams != null && !importedParams.isEmpty()) {
				fillimportParamFromParent(parentDesign.getMechanicDesignDefinition(), importedParams);
				fillPublicParamFromImportedParams(mechanicdesign.getPublicparamgroup(), importedParams);
			}
			importParamsFromParent(mechanicdesign.getPublicparamgroup(),
					parentDesign.getMechanicDesignDefinition().getPublicparamgroup());
			importParamsFromParent(mechanicdesign.getPrivateparamgroup(),
					parentDesign.getMechanicDesignDefinition().getPrivateparamgroup());
			MechanicDesignMaterialsHelper.updateMaterialFromParentDesign(parentDesign.getMechanicDesignDefinition(), mechanicdesign);
			MechanicDesignAssemblyManager.updateAssemblyPreferencesFromParentDesign(parentDesign.getMechanicDesignDefinition(), mechanicdesign);
		}
	}

	private DesignObject3D initializeRootspace(DesignObject3D rootspace, MechanicDesign mechanicdesign, DesignObject3D parent) {
	    if (rootspace == null) {
	        rootspace = new Space3DFree();
	    }

	    rootspace.setMechanicDesignDefinition(mechanicdesign);
	    mechanicdesign.setInstance(rootspace);
	    rootspace.setParentdesign(parent);
	    rootspace.setXpos(0);
	    rootspace.setYpos(0);
	    rootspace.setZpos(0);

	    if (mechanicdesign.getType().equals(PieceType.DRESSING)) {
	        ((Space3DFree) rootspace).getAccessoires().clear();
	        ((Space3DFree) rootspace).getQuincailleries().clear();
	    }

	    if (mechanicdesign.getChainOfResponsabilityController() == null) {
	        ChainOfResponsabilityController chainModel = ParamFactory.eINSTANCE.createChainOfResponsabilityController();
	        mechanicdesign.setChainOfResponsabilityController(chainModel);
	    }

	    ((Space3D) rootspace).getDependenceController().setRoot(rootspace);

	    return rootspace;
	}
	
	private void setupMaterialAndParams(MechanicDesign mechanicdesign, DesignObject3D rootspace,
	        EList<MechanicPrivateParam> privateparams, EList<MechanicPublicParam> publicparams, int update) throws DesignException, GeometricEngineException {

	    if (mechanicdesign.getId() == null || update == MechanicDesignCreator.create) {
	        UUID id = UUID.randomUUID();
	        mechanicdesign.setId(id);
	        rootspace.setID(id);
	    } else {
	        rootspace.setID(mechanicdesign.getId());
	    }

	    MechanicDesignMaterialsHelper.setDefaultMaterialifNull(mechanicdesign);
	    ((Space3D) rootspace).setBasematerial(mechanicdesign.getPrincipalmaterial());
	    ((Space3D) rootspace).setBackmaterial(mechanicdesign.getSecondmaterial());
	    ((Space3D) rootspace).setFacadeMaterial(mechanicdesign.getFacadeMaterial());

	    rootspace.setName(mechanicdesign.getName());
	    rootspace.constructGenericDebitage(privateparams, publicparams, mechanicdesign, rootspace.getParentdesign());
	}

	/**
	 * 
	 * @param mechanicdesign the parent design to update its children
	 * @param update mode (create,open,update)
	 * @param createUsinage isCreateUsinage
	 * @param src the MechanicDesign Model Instance
	 * @param parentDesign the model Parent
	 * @throws Exception
	 */
	private void upateMechanicDesignChildren(MechanicDesign mechanicdesign, int update, boolean createUsinage,
			DesignObject3D src, DesignObject3D parentDesign) throws Exception {
		DesignObject3D childsparent=null;
		if(mechanicdesign.getType().equals(PieceType.PIECE2D)) {
			childsparent=src;
		}else if(src instanceof Space3D &&(mechanicdesign.getType().equals(PieceType.SPACE3D) 
				|| mechanicdesign.getType().equals(PieceType.CAISSON)
				|| mechanicdesign.getType().equals(PieceType.DRESSING)
				|| mechanicdesign.getType().equals(PieceType.OBSTACLE)
				|| mechanicdesign.getType().equals(PieceType.ACCESOIRE)) ) {
			childsparent =src;
		}
		if(childsparent!=null && mechanicdesign.getMechanicdesign()!=null && mechanicdesign.getMechanicdesign().size()>0) {
			//ajout les designs child pour ce design 
			List<MechanicDesign> childs=new ArrayList<MechanicDesign>();
			List<MechanicDesign> childsorigin=new ArrayList<MechanicDesign>();

			childs.addAll(mechanicdesign.getMechanicdesign());
			childsorigin.addAll(mechanicdesign.getMechanicdesign());
			List<MechanicDesign> obstacles=childs.stream().filter(design->design.getType().equals(PieceType.OBSTACLE)).collect(Collectors.toList());
			childs.removeAll(obstacles);
			childsorigin.removeAll(obstacles);
//			ubdateChildsMaterial(mechanicdesign);
//			ubdateChildsAssemblyPreferences(mechanicdesign);
			if(childsparent!=null && childsparent.getRootModule()!=null && childsparent.getRootModule() instanceof Space3D && ((Space3D) childsparent.getRootModule()).getDependenceController()!=null
					&&((Space3D) childsparent.getRootModule()).getDependenceController().getChainModel()!=null ) {
				while (childs.size()>0) {
					((Space3D) childsparent.getRootModule()).getDependenceController().filterDependentent(childs);
					if(childs.isEmpty()) {
						break;
					}
					for(MechanicDesign mcdesign :childs)
					{
						MechanicDesignCreator.getInstance().constructObject(childsparent, null, mcdesign, update,createUsinage,MechanicDesignCreator.isDirectParent ,MechanicDesignCreator.isCreatedFromParentChilds);
					}
					
					childsorigin.removeAll(childs);
					childs.clear();
					childs.addAll(childsorigin);
				}
			}
			
			childs.clear();
			if(!obstacles.isEmpty())
			{
				long debut =new Date().getTime();
				MechanicDesignObstaclesManager.updateObstacles(childsparent,obstacles,update);
				long end =new Date().getTime();
				System.err.println("update obstacles end:\t"+(end-debut)+" of design"+childsparent.getName());
			}
			
		}
	}
	

	private void fillimportParamFromParent(MechanicDesign mechanicDesign, EList<ImportedParams> importedParams) throws Exception {
		for(ImportedParams param:importedParams) {
			MechanicPublicParam publicParam=null;
			MechanicPrivateParam privateparam=null;
			if(param.getKey()!=null && !param.getKey().isEmpty()) {
				try {
					publicParam=mechanicDesign.getPublicParam(param.getKey());
				} catch (Exception e) {
					e.printStackTrace();
				}
				if(publicParam!=null) {
					param.setDefaultvalue(publicParam.getDefaultvalue());
					param.setTypedef(publicParam.getTypedef());
					param.setTypedefelement(publicParam.getTypedefelement());
				}else {
					try {
						privateparam=mechanicDesign.getPrivateParam(param.getKey());
					} catch (Exception e) {
						e.printStackTrace();
					}
					if(privateparam!=null) {
						param.setDefaultvalue(privateparam.getValue());
						param.setTypedef(privateparam.getTypedef());
						param.setTypedefelement(privateparam.getTypedefelement());
					}else if(param.isIsMandatory()){
						throw new Exception("imported parameter not found\t"+param.getName());
					}
				}
			}
		}
		
	}
	/**
	 *  import public Params from parent when param.isImport() == true
	 * @param publicParams
	 * @param parentPublicParams
	 */

	public void importParamsFromParent(PublicParamGroup publicParams, PublicParamGroup parentPublicParams) {
		if (publicParams == null || parentPublicParams == null) {
			return;
		}
		for(MechanicPublicParam param:publicParams.getMechanicpublicparam()) {
			if(param.isImport()) {
				MechanicPublicParam publicParam=parentPublicParams.getParam(param.getKey());
				if(publicParam!=null) {
					
					if(publicParam.getTypeDefinition()!=null && publicParam.getTypeDefinition().equals(publicParam.getTypedef())) {
						TypeDef typedef = EcoreUtil.copy(publicParam.getTypeDefinition());
						param.setTypeDefinition(typedef);
						param.setTypedef(typedef);
						param.setTypedefelement(typedef.getElement(publicParam.getTypedefelement().getKey()));
					}else {
						param.setTypedef(publicParam.getTypedef());
						param.setTypedefelement(publicParam.getTypedefelement());
					}
					param.setDefaultvalue(publicParam.getDefaultvalue());
					
				}
			}
		}

	}
	
	/**
	 * import private Params from parent when param.isImport() == true
	 * @param privateParams
	 * @param parentPrivateParams
	 */
	public void importParamsFromParent(PrivateParamGroup privateParams, PrivateParamGroup parentPrivateParams) {
		if (privateParams == null || parentPrivateParams == null) {
			return;
		}
		for(MechanicPrivateParam param:privateParams.getMechanicprivateparam()) {
			if(param.isImport()) {
				MechanicPrivateParam privateParam=parentPrivateParams.getParam(param.getKey());
				if(privateParam!=null) {
					param.setValue(privateParam.getValue());
					param.setTypedef(privateParam.getTypedef());
					param.setTypedefelement(privateParam.getTypedefelement());
				}
			}
		}

	}
	
	public void fillPublicParamFromImportedParams(PublicParamGroup publicParamGroup, EList<ImportedParams> importedParams){
		ArrayList<ImportedParams> tobedeleted = new ArrayList<ImportedParams>();
		for(ImportedParams importParam:importedParams) {
			if(importParam.getKey()!=null && !importParam.getKey().isEmpty()) {
				MechanicPublicParam publicParam=publicParamGroup.getParam(importParam.getKey());
				if(publicParam!=null) {
					publicParam.setDefaultvalue(importParam.getDefaultvalue());
					publicParam.setTypedef(importParam.getTypedef());
					publicParam.setTypedefelement(importParam.getTypedefelement());
				}else {
					MechanicPublicParam publicParam1=	ParamFactory.eINSTANCE.createMechanicPublicParam();
					publicParam1.setDefaultvalue(importParam.getDefaultvalue());
					publicParam1.setTypedef(importParam.getTypedef());
					publicParam1.setTypedefelement(importParam.getTypedefelement());
					publicParam1.setName(importParam.getName());
					publicParam1.setUserlabel(importParam.getUserlabel());
					publicParam1.setChangeable(false);
					publicParam1.setKey(importParam.getKey());
					publicParamGroup.getMechanicpublicparam().add(publicParam1);
				}
			}else {
				tobedeleted.add(importParam);

			}
		}
		for(ImportedParams importParam:tobedeleted) {
			importedParams.remove(importParam);
		}

	}
	
	public static List<Piece2D> buildDesignElements(DesignObject3D rootspace ,MechanicDesign mechanicdesign,List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, int update2, boolean createUsinage) throws DesignException, GeometricEngineException {
		
		List<Piece2D> pieces=new ArrayList<Piece2D>();
		//build elements (pieces)
		if(mechanicdesign.getMechanicelementgroup()!=null) // scho 1953 
		{
			for(MechanicDesignElment mechaelment : mechanicdesign.getMechanicelementgroup().getMechanicdesignelment())
			{
				Piece2D piece=buildDesignElement(mechanicdesign, mechaelment, null, rootspace, privateparams, publicparams,update2, createUsinage);
				if(piece!=null) {
					pieces.add(piece);
				}
			}
		}
		return pieces;
	}
	public static Piece2D buildDesignElement(MechanicDesign mechanicdesign, MechanicDesignElment mechaelment, Piece2D piece, DesignObject3D rootspace, List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, int update, boolean createUsinage) throws DesignException, GeometricEngineException {

		if (piece == null) {
			piece = new Piece2D();
		}

		piece.setMechanicDesignDefinition(mechanicdesign);
		piece.setMechanicDesignElementDefinition(mechaelment);
		
		piece.setErrorexist(false);
		piece.setErrormsg("");
		
		MechanicDesignMaterialsHelper.updateDesignElement(mechanicdesign, mechaelment, piece);
		////////
		piece.setParentdesign(rootspace);
		piece.setXpos(0);
		piece.setZpos(0);
		piece.setYpos(0);
		dressing.model.types.PieceType type = dressing.model.types.PieceType.GENERIC;
		if (mechaelment.getTypedef() != null && mechaelment.getTypedef().getKey()!=null &&  mechaelment.getTypedef().getKey().contentEquals("PieceType")
				&& mechaelment.getTypedefelement() != null && mechaelment.getTypedefelement().getKey() != null
				&& !mechaelment.getTypedefelement().getKey().isEmpty()) {
			String typedefElment = mechaelment.getTypedefelement().getKey();
			try {
				type = dressing.model.types.PieceType.valueOf(typedefElment);
			} catch (Exception e) {
				type = dressing.model.types.PieceType.valueOf(mechaelment.getName());
			}
		} else {

			try {
				type = dressing.model.types.PieceType.valueOf(mechaelment.getName());
			} catch (Exception e) {
			}
		}
		piece.setPiecetype(type);
		piece.setName(mechaelment.getName());
		if (mechaelment.getId() == null || update == MechanicDesignCreator.create) {
			UUID id = UUID.randomUUID();
			mechaelment.setId(id);
			piece.setID(id);
		} else {
			piece.setID(mechaelment.getId());
		}
		///////
		piece.constructGenericDebitage(privateparams, publicparams, mechaelment, rootspace);
		if(piece.containsKey("SOLID_EXPRESSION"));
		{
			piece.setSolid((Boolean) piece.get("SOLID_EXPRESSION"));
		}
		if (!(Boolean) piece.get("EXIST")) {
			return null;

		}
		return piece;

	}


}
