package dressing.mathutils;

import java.util.Arrays;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import gdxapp.Commun.Preferences;
import gdxapp.object3d.Wall;
//this class represent rectangular surfaces
public class Surface {
	
	private Vector3 start;
	private Vector3 end;
	private Vector3 normal;
	private float length;
	private float height;
	private Direction direction;
	private Matrix4 surfaceToWorldTransform;
	private Vector3 u,v;
	private float yRotation;
	private transient Wall wall;
	
	private Vector3 v00, v01, v10, v11;
	
	public Surface() {}
	
	public Surface(Vector3 v00, Vector3 v01, Vector3 v10, Vector3 v11) {
		this.v00 = v00.cpy();
		this.v01 = v01.cpy();
		this.v10 = v10.cpy();
		this.v11 = v11.cpy();
		this.normal = v10.cpy().sub(v01).nor().crs(v00.cpy().sub(v01)).nor().scl(-1);
		this.start = v00.cpy();
		this.end = v10.cpy();
		calculateRotationangle();
		setSurfaceDimension();
		calculateTransform(length, height);
	}
	
	public void set(Vector3 v00, Vector3 v01, Vector3 v10, Vector3 v11) {
		this.v00 = v00.cpy();
		this.v01 = v01.cpy();
		this.v10 = v10.cpy();
		this.v11 = v11.cpy();
		this.normal = v10.cpy().sub(v01).nor().crs(v00.cpy().sub(v01)).nor().scl(-1);
		this.start = v00;
		this.end = v10;
		calculateRotationangle();
		setSurfaceDimension();
		calculateTransform(length, height);
	}
	
	public Surface(Vector3 start, Vector3 end) {
		this.start = start;
		this.end = end;
		this.v00 = start;
		this.v01 = new Vector3(start.x, end.y, start.z);
		this.v10 = end;
		this.v11 = new Vector3(end.x, start.y, end.z);
		this.normal = v10.cpy().sub(v01).nor().crs(v00.cpy().sub(v01)).nor().scl(-1);
		calculateRotationangle();
		setSurfaceDimension();
		calculateTransform(length, height);
	}
	
	public void calculateTransform(float viewportWidth, float viewportHeight) {
		setSurfaceDimension();
		float scaleX = viewportWidth/length, scaleY = viewportHeight/height;
		Vector3 sx = new Vector3(1.0f/scaleX,0,0); 
		Vector3 sy = new Vector3(0.0f,1.0f/scaleY,0.0f); 
		Vector3 sz = new Vector3(0.0f,0.0f,1.0f);
		Matrix4 scaleM = new Matrix4(new float[] {
				sx.x, sx.y, sx.z, 0,
				sy.x, sy.y, sy.z, 0,
				sz.x, sz.y, sz.z, 0,
				0, 		0,  0, 	  1
		});
		
		u = end.cpy().sub(start);
		u.y = 0;
		u.nor();
		v = new Vector3(0,1,0);
		
		float[] values = new float[]{
				u.x, u.y, u.z, 0,
				v.x, v.y, v.z, 0,
				normal.x, normal.y, normal.z, 0,
				start.x, 0, start.z, 1
		};
		Matrix4 rotationM = new Matrix4(values);
		surfaceToWorldTransform= rotationM.mul(scaleM);
	}
	
	public Matrix4 getRelativeTransform() {
		Vector3 u = end.cpy().sub(start).nor();
		
		
		
		return null;
	}

	public void setSurfaceDimension() {
		Vector3 vector = end.cpy().sub(start);
		this.height = Math.abs(vector.y);
		vector.y = 0;
		this.length = vector.len();
	}
	

	public Vector3 toWorldCoords(Vector3 point) {
		Vector3 realWorldPosition = point.cpy().mul(surfaceToWorldTransform);
		return  realWorldPosition;
	}
	
	public Vector3 toSurfaceCoords(Vector3 point) {
		Vector3 surfacePoint = point.cpy().mul(surfaceToWorldTransform.cpy().inv());
		return surfacePoint;
	}
	
	public void calculateRotationangle() {
		if(this.normal != null) {
			float dotProduct = this.normal.dot(Vector3.Z);
			yRotation = (float) Math.toDegrees(Math.acos(dotProduct));
			if(normal.x < 0)
				yRotation *= -1;
		}
	}
	
	public Vector3 getStart() {
		return start;
	}

	public void setStart(Vector3 start) {
		this.start = start;
	}

	public Vector3 getEnd() {
		return end;
	}

	public void setEnd(Vector3 end) {
		this.end = end;
	}

	public Vector3 getNormal() {
		return normal;
	}
	public void setNormal(Vector3 normal) {
		this.normal = normal;
	}
	
	public float getLength() {
		return length;
	}
	public void setLength(float length) {
		this.length = length;
	}
	public float getHeight() {
		return height;
	}
	public void setHeight(float height) {
		this.height = height;
	}
	public Direction getDirection() {
		return direction;
	}
	public void setDirection(Direction direction) {
		this.direction = direction;
	}
	
	public Vector3 getV00() {
		return v00;
	}

	public void setV00(Vector3 v00) {
		this.v00 = v00;
	}

	public Vector3 getV01() {
		return v01;
	}

	public void setV01(Vector3 v01) {
		this.v01 = v01;
	}

	public Vector3 getV10() {
		return v10;
	}

	public void setV10(Vector3 v10) {
		this.v10 = v10;
	}

	public Vector3 getV11() {
		return v11;
	}

	public void setV11(Vector3 v11) {
		this.v11 = v11;
	}

	public float getyRotation() {
		return yRotation;
	}

	public void setyRotation(float yRotation) {
		this.yRotation = yRotation;
	}
	
	
	public Matrix4 getWorldToSurfaceTransform() {
		return surfaceToWorldTransform.cpy().inv();
	}

	public Matrix4 getSurfaceToWorldTransform() {
		return surfaceToWorldTransform.cpy();
	}

	public void setSurfaceToWorldTransform(Matrix4 surfaceToWorldTransform) {
		this.surfaceToWorldTransform = surfaceToWorldTransform;
	}

	public Vector3 getU() {
		return u;
	}

	public void setU(Vector3 u) {
		this.u = u;
	}

	public Vector3 getV() {
		return v;
	}

	public void setV(Vector3 v) {
		this.v = v;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((end == null) ? 0 : end.hashCode());
		result = prime * result + ((normal == null) ? 0 : normal.hashCode());
		result = prime * result + ((start == null) ? 0 : start.hashCode());
		result = prime * result + Float.floatToIntBits(yRotation);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Surface other = (Surface) obj;
		if (end == null) {
			if (other.end != null)
				return false;
		} else if (!end.equals(other.end))
			return false;
		if (normal == null) {
			if (other.normal != null)
				return false;
		} else if (!normal.equals(other.normal))
			return false;
		if (start == null) {
			if (other.start != null)
				return false;
		} else if (!start.equals(other.start))
			return false;
		if (surfaceToWorldTransform == null) {
			if (other.surfaceToWorldTransform != null)
				return false;
		} else if (!Arrays.equals(surfaceToWorldTransform.val, other.surfaceToWorldTransform.val))
			return false;
		if (Float.floatToIntBits(yRotation) != Float.floatToIntBits(other.yRotation))
			return false;
		return true;
	}

	//return the plane coords of a real world point projected on the surface
	public Vector2 getPlaneCoords(Vector3 worldPoint) {
		Vector3 planeCoords = worldPoint.cpy().mul(getWorldToSurfaceTransform());		
		return new Vector2(planeCoords.x, planeCoords.y);
	}

	public Wall getWall() {
		return wall;
	}

	public void setWall(Wall wall) {
		this.wall = wall;
	}
	
	
}
