package dressing.mathutils;

import java.util.ArrayList;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.Direction;
import dressing.cam.model.Util;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Rainure;

public class CoordinateSystem {

	public Matrix4 transform;					//the transform matrix that convert the point coords from world coordinates to the system coordinate
	private Vector3 origin;						//the world coordinates of the system origin
	
	public CoordinateSystem() {
		transform = new Matrix4();
		origin = new Vector3();
	}
	public CoordinateSystem(Vector3 origin) {
		this.origin = origin;
		transform = new Matrix4();
		transform.setTranslation(origin);
	}
	public CoordinateSystem(Matrix4 transform) {
		this.transform = transform;
	}
	
	//calculate the point coordinates in the cartesian system
	private Vector3 coordsOf(Vector3 point) {
		return point.mul(transform);
	}
	
	
	public static Vector3 getPieceDimension(Piece2D piece) {
		double pieceLength = Math.max(Math.max(piece.getLongeurext(), piece.getHauteurext()), piece.getProfondeurext());
		Rainure rainure = null;
		for (DesignObject3D usinage : piece.getChilds()) {
			if(usinage instanceof Rainure) {
				Rainure rainureX = (Rainure) usinage;
				if(rainure!=null) {
					if(rainureX.getRainureLength() > rainure.getRainureLength()) {
						rainure = rainureX;
					}else if( rainureX.getRainureLength() == rainure.getRainureLength()) {
						Vector3 rainureXAxe = Util.getDesignAxe(rainureX);
						Vector3 rainureAxe = Util.getDesignAxe( rainure);
						Vector3 pieceDimension = new Vector3((float)piece.getLongeurext(), (float)piece.getHauteurext(), (float)piece.getProfondeurext());
						rainure = (rainureXAxe.dot(pieceDimension) > rainureAxe.dot(pieceDimension))?rainureX:rainure;
					}
				}else
				{
					rainure = (Rainure) usinage;
				}
			}
		}
		if(rainure != null ) {
			Vector3 lengthAxis =Util.getDesignAxe( rainure);
			if(lengthAxis == Vector3.X) {
				pieceLength = piece.getLongeurext();
			}else if (lengthAxis == Vector3.Y) {
				pieceLength = piece.getHauteurext();
			}else {
				pieceLength = piece.getProfondeurext();
			}	
		}
		double pieceDepth = Math.min(Math.min(piece.getLongeurext(), piece.getHauteurext()), piece.getProfondeurext());
		double pieceHeight = piece.getLongeurext() + piece.getHauteurext() + piece.getProfondeurext() - pieceLength - pieceDepth;
		return  new Vector3((float)pieceLength, (float)pieceHeight, (float)pieceDepth);
		
	}
	public static ArrayList<CoordinateSystem> getMachineCoordSystem(Piece2D piece) {
		Vector3 x, y, z;
		double pieceLength = Math.max(Math.max(piece.getLongeurext(), piece.getHauteurext()), piece.getProfondeurext());
		double pieceDepth = Math.min(Math.min(piece.getLongeurext(), piece.getHauteurext()), piece.getProfondeurext());
		Rainure rainure = null;
		for (DesignObject3D usinage : piece.getChilds()) {
			if(usinage instanceof Rainure) {
				Rainure rainureX = (Rainure) usinage;
				if(rainure!=null) {
					if(rainureX.getRainureLength() > rainure.getRainureLength()) {
						rainure = rainureX;
					}else if( rainureX.getRainureLength() == rainure.getRainureLength()) {
						Vector3 rainureXAxe = Util.getDesignAxe(rainureX);
						Vector3 rainureAxe = Util.getDesignAxe( rainure);
						Vector3 pieceDimension = new Vector3((float)piece.getLongeurext(), (float)piece.getHauteurext(), (float)piece.getProfondeurext());
						rainure = (rainureXAxe.dot(pieceDimension) > rainureAxe.dot(pieceDimension))?rainureX:rainure;

					}
				}else
				{
					rainure = (Rainure) usinage;
				}
			}
		}
		if(rainure != null ) {
			x =  Util.getDesignAxe( rainure);
		}else {
			
			if(pieceLength == piece.getLongeurext()) {
				x = Vector3.X;
			}else if(pieceLength == piece.getHauteurext()) {
				x = Vector3.Y;
			}else {
				x = Vector3.Z;
			}
		}
		
		if(pieceDepth == piece.getLongeurext()) {
			z = Vector3.X;
		}else if(pieceDepth == piece.getHauteurext()) {
			z = Vector3.Y;
		}else {
			z = Vector3.Z;
		}
		 
		y = new Vector3(1,1,1).sub(x).sub(z);

		ArrayList<Vector3> origins = piece.getCornersList();
		ArrayList<Vector3> reflections = new ArrayList<Vector3>();
		reflections.add(new Vector3(1,1,1));
		reflections.add(new Vector3(1,1,-1));
		reflections.add(new Vector3(1,-1,1));
		reflections.add(new Vector3(1,-1,-1));
		reflections.add(new Vector3(-1,1,1));
		reflections.add(new Vector3(-1,1,-1));
		reflections.add(new Vector3(-1,-1,1));
		reflections.add(new Vector3(-1,-1,-1));
		ArrayList<CoordinateSystem> coordSystems = new ArrayList<CoordinateSystem>();
		int counter = 0;

		for(Vector3 origin: origins) {
			Vector3 orientedX , orientedY, orientedZ = new Vector3();
			orientedX = x.cpy().scl(reflections.get(counter));
			orientedY = y.cpy().scl(reflections.get(counter));
			orientedZ = z.cpy().scl(reflections.get(counter));
			float[] values = new float[] {
					orientedX.x, orientedX.y, orientedX.z,
					orientedY.x, orientedY.y, orientedY.z,
					orientedZ.x, orientedZ.y, orientedZ.z
			};
			Matrix3 rotationMatrix = new Matrix3(values).inv();
			Vector3 translation = origin.cpy().scl(-1);
			translation.mul(rotationMatrix); 
			
			float[] val = rotationMatrix.getValues(); 
			float[] vals = new float[] {
					val[0], val[1], val[2], 0,
					val[3], val[4], val[5], 0,
					val[6], val[7], val[8], 0,
					translation.x, translation.y, translation.z, 1,
			};
			
			Matrix4 transform = new Matrix4(vals);

			CoordinateSystem coordSys = new CoordinateSystem(transform);
			coordSystems.add(coordSys);
			counter++;
			
		}
		
		return coordSystems;
	}
	public static Matrix3 getRotationMatrix(Vector3 orientedX, Vector3 orientedY, Vector3 orientedZ , Vector3 origin){
		float[] values = new float[] {
				orientedX.x, orientedX.y, orientedX.z,
				orientedY.x, orientedY.y, orientedY.z,
				orientedZ.x, orientedZ.y, orientedZ.z
		};
		Matrix3 rotationMatrix = new Matrix3(values);
		
		return rotationMatrix;
	}
	public static Matrix4 getTransformMatrix(Vector3 orientedX, Vector3 orientedY, Vector3 orientedZ , Vector3 origin){
		
		Matrix3 rotationMatrix = getRotationMatrix(orientedX, orientedY, orientedZ, origin).inv();
		Vector3 translation = origin.cpy().scl(-1);
		translation.mul(rotationMatrix); 
		
		float[] val = rotationMatrix.getValues(); 
		float[] vals = new float[] {
				val[0], val[1], val[2], 0,
				val[3], val[4], val[5], 0,
				val[6], val[7], val[8], 0,
				translation.x, translation.y, translation.z, 1,
		};
		
		Matrix4 transform = new Matrix4(vals);
		return transform;
	}
	
	public static ArrayList<CoordinateSystem> getPieceCoordinateSytem(Piece2D piece){
		ArrayList<Vector3> origins = piece.getCornersList();
		ArrayList<Vector3> reflections = new ArrayList<Vector3>();
		
		reflections.add(new Vector3(1,1,1));
		reflections.add(new Vector3(1,1,-1));
		reflections.add(new Vector3(1,-1,1));
		reflections.add(new Vector3(1,-1,-1));
		reflections.add(new Vector3(-1,1,1));
		reflections.add(new Vector3(-1,1,-1));
		reflections.add(new Vector3(-1,-1,1));
		reflections.add(new Vector3(-1,-1,-1));
		
		Matrix4 id = new Matrix4();

		ArrayList<CoordinateSystem> coordSystems = new ArrayList<CoordinateSystem>();
		int counter = 0;

		for(Vector3 origin: origins) {
			Matrix4 transform = id.cpy().setTranslation(origin.cpy().add((float)piece.getXPosABS(), (float)piece.getYPosABS(),(float) piece.getZPosABS()).scl(0.01f));
			Vector3 c1, c2,c3;
			c1 = new Vector3(transform.val[Matrix4.M00], transform.val[Matrix4.M10], transform.val[Matrix4.M20]);
			c2 = new Vector3(transform.val[Matrix4.M01], transform.val[Matrix4.M11], transform.val[Matrix4.M21]);
			c3 = new Vector3(transform.val[Matrix4.M02], transform.val[Matrix4.M12], transform.val[Matrix4.M22]);
			
			c1.scl(reflections.get(counter).x);
			c2.scl(reflections.get(counter).y);
			c3.scl(reflections.get(counter).z);

			transform.val[Matrix4.M00] = c1.x ; 
			transform.val[Matrix4.M10] = c1.y;
			transform.val[Matrix4.M20] = c1.z;
			
			transform.val[Matrix4.M01] = c2.x ; 
			transform.val[Matrix4.M11] = c2.y;
			transform.val[Matrix4.M21] = c2.z;
			
			transform.val[Matrix4.M02] = c3.x ; 
			transform.val[Matrix4.M12] = c3.y;
			transform.val[Matrix4.M22] = c3.z;
			
			CoordinateSystem coordSys = new CoordinateSystem(transform);
			coordSystems.add(coordSys);
			counter++;
			
		}
		
		return coordSystems;
		
	}

	
	public static void main(String[] args) {
		//set the direction of the three Axis for the new Coordinate System
		Vector3 x = new Vector3(0, 0, -1);
		Vector3 y = new Vector3(0, -1, 0);
		Vector3 z = new Vector3(1, 0, 0);
		//set the origin
		Vector3 origin =new Vector3(0, 18,600);
		//calculate the transform Matrix to switch between the original and the new Coordinate Systems
		Matrix4 transform =getTransformMatrix(x, y, z, origin);
		//calculate the rotation Matrix to switch direction the original and the new Coordinate Systems
		Matrix3 rotationMatrix = getRotationMatrix(x, y, z, origin);
		// inverse the transform and rotation to set them to transform from the new system to the original coordinate system
//		rotationMatrix=rotationMatrix.inv();
		transform = transform.inv();
		//set the point to transform in the new Coordinate System
		Vector3 worldPoint =new Vector3(58, 9, 0);
		//transform the point to the original Coordinate System
		Vector3 image = worldPoint.cpy().mul(transform);
		System.err.println(image.toString());
		//get a direction to rotate
		param.Direction dir=param.Direction.ZMINUS;
		Direction dir1=Direction.valueOf(dir.getLiteral());
		//transform the direction from ENUM to Vector to rotate
		Vector3 VoriginDirection = dir1.toVector();
		//rotate the direction by multiply with the rotationMatrix
		Vector3 VRotatedDirection = VoriginDirection.cpy().mul(rotationMatrix);
		//transform the new direction back to ENUM for later use
		Direction rotatedDirection = Direction.fromVector(VRotatedDirection);
		System.err.println(rotatedDirection.toString());

	}
	
}
