package dressing.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class FileSearch {

    public static String[] getFiles(String path, boolean isFile, String[] extensions, boolean acceptSubFile) {
        List<String> fileList = new ArrayList<>();

        try {
            File configFolder = new File(path);

            if (configFolder.exists()) {
                listFiles(configFolder, isFile, extensions, acceptSubFile, fileList);
            }
        } catch (Exception e) {
            // Handle the exception appropriately (e.g., log it or throw a custom exception)
            e.printStackTrace();
        }

        return fileList.toArray(new String[0]);
    }

    private static void listFiles(File directory, boolean isFile, String[] extensions, boolean acceptSubFile, List<String> fileList) {
        File[] files = directory.listFiles();

        if (files != null) {
            for (File file : files) {
                if (file.isDirectory() && acceptSubFile) {
                    // Recursive call for subdirectories
                    listFiles(file, isFile, extensions, acceptSubFile, fileList);
                } else if(hasMatchingExtension(file.getName(), extensions)){
                    fileList.add(file.getAbsolutePath());
                }
            }
        }
    }

    private static boolean hasMatchingExtension(String fileName, String[] extensions) {
        for (String ext : extensions) {
            if (fileName.endsWith(ext)) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        String[] extensions = {".txt", ".xml",".catalog"};
        String path = "C:\\ProgramData\\superDressing\\Data\\Dressing";
        boolean isFile = true;
        boolean acceptSubFile = true;

        String[] files = FileSearch.getFiles(path, isFile, extensions, acceptSubFile);

        System.out.println("Matching files and directories:");
        for (String file : files) {
            System.out.println(file);
        }
    }
}
