package dressing.handlers.gdx;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

import dressing.model.ProjectManager;
import gdxapp.Commun.ActionProcessor;

public class HideObjectByFamily {
	
	@Execute
	public void execute(ParameterizedCommand command) {
		if(command.getParameterMap().get("dressing.commandparameter.view.mode.object.type")!=null)
		{
		
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.view.mode.object.type");
			switch (persp) {
			case "bas":
				ActionProcessor.getProcessor().setShowBottom(!ActionProcessor.getProcessor().isShowBottom());

				break;
			case "haut":
				ActionProcessor.getProcessor().setShowTop(!ActionProcessor.getProcessor().isShowTop());

				break;
			case "colonne":
				 ActionProcessor.getProcessor().setShowColonne(!ActionProcessor.getProcessor().isShowColonne());

				break;
			case "InnerQuotations":
	        	 ActionProcessor.getProcessor().setShowInnerQuotations(!ActionProcessor.getProcessor().isShowInnerQuotations());

	        	 break;
			case "OuterQuotations":
	        	 ActionProcessor.getProcessor().setShowOuterQuotations(!ActionProcessor.getProcessor().isShowOuterQuotations());
	        	 break;
			case "selected":
				ActionProcessor.getProcessor().hideSelected();
				break;
			case "showhidden":
				ActionProcessor.getProcessor().showHiddenElements();
				break;
			case "freezeBas":
				ActionProcessor.getProcessor().toggleFreezeBottom();

				break;
			case "freezeHaut":
				ActionProcessor.getProcessor().toggleFreezeTop();

				break;
			case "freezeColonne":
				 ActionProcessor.getProcessor().toggleFreezeColonne();

				break;
			case "HideFacades":
				 ActionProcessor.getProcessor().toggleShowFacades();

				break;	
			default:
				break ;
			}

		}
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}

}
