package dressing.handlers.catalog;

import java.io.File;
import java.util.Date;
import java.util.UUID;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.MechanicDesignCreator;
import dressing.ui.util.EditorWindow;
import param.Catalog;
import param.DesignClasse;
import param.MechanicDesignGroup;
import param.ParamPackage;
import param.impl.ParamFactoryImpl;
import param.impl.ParamPackageImpl;

public class CreateCatalogEditorWindow extends EditorWindow {

	private Text txt;
	private Text txtOwner;

	private Catalog cat;
	private boolean isCatalog=true;
	private MechanicDesignGroup group;
	private DesignClasse classe;
	IEventBroker eventBroker;

	public CreateCatalogEditorWindow(Shell parentShell,Catalog cat,int update,boolean isCatalog, MechanicDesignGroup group,DesignClasse classe) {
		super(parentShell,update);
		this.isCatalog=isCatalog;
		this.cat=cat;
		this.group=group;
		this.classe=classe;
	}

	public Text getTxt() {
		return txt;
	}

	public void setTxt(Text txt) {
		this.txt = txt;
	}

	public Text getTxtOwner() {
		return txtOwner;
	}

	public void setTxtOwner(Text txtOwner) {
		this.txtOwner = txtOwner;
	}

	public Catalog getCat() {
		return cat;
	}

	public void setCat(Catalog cat) {
		this.cat = cat;
	}
	
	public boolean isCatalog() {
		return isCatalog;
	}

	public void setCatalog(boolean isCatalog) {
		this.isCatalog = isCatalog;
	}

	public MechanicDesignGroup getGroup() {
		return group;
	}

	public void setGroup(MechanicDesignGroup group) {
		this.group = group;
	}

	public DesignClasse getClasse() {
		return classe;
	}

	public void setClasse(DesignClasse classe) {
		this.classe = classe;
	}

	public IEventBroker getEventBroker() {
		return eventBroker;
	}

	public void setEventBroker(IEventBroker eventBroker) {
		this.eventBroker = eventBroker;
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		
		Composite composite=new Composite(parent, SWT.None); 
		GridLayout gl_composite_2 = new GridLayout(2, true);
		composite.setLayout(gl_composite_2);
		Label lbl=new Label(composite, SWT.None);
		lbl.setText("Nom:");
		lbl.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, true, 1, 1));
		txt = new Text(composite, SWT.BORDER);
		txt.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1));
		String title="Ajouter un catalogue";
		if(isCatalog) {
			
			Label lbl2=new Label(composite, SWT.None);
			lbl2.setText("Societe:");
			lbl2.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, true, 1, 1));
			txtOwner = new Text(composite, SWT.BORDER);
			txtOwner.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1));
			if(getUpdateMode()==EditorWindow.update) {
				title="Modifier un catalogue";
				txtOwner.setText(cat.getOwner()!=null?cat.getOwner():"");
				txt.setText(cat.getName()!=null?cat.getName():"");
			}
		}else{
			if(getUpdateMode()==EditorWindow.update) {
				title="Modifier un Group";
				if(group!=null) {
					txt.setText(group.getName()!=null?group.getName():"");
				}
			}else {
				title="Ajouter un Group";
			}
		}
		parent.getShell().setText(title);
		composite.pack();
		return composite;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}else {
			if(isCatalog) {
				if(getUpdateMode()==EditorWindow.update) {
					cat.setName(txt.getText());
					cat.setModificationDate(new Date());
					if(txtOwner!=null) {
						cat.setOwner(txtOwner.getText());
					}
				}else {
					cat=ParamFactoryImpl.eINSTANCE.createCatalog();
					cat.setName(txt.getText());
					cat.setId(UUID.randomUUID());
					if(txtOwner!=null) {
						cat.setOwner(txtOwner.getText());
					}
					cat.setCreationDate(new  Date());
					cat.setModificationDate(new Date());
					File file=new File(WorkspaceConfiguration.getCatalogsPath()+File.separator+cat.getName()+"("+cat.getOwner()+")_"+cat.getId()+".catalog");

					URI uri=URI.createFileURI(file.getAbsolutePath()); 
					Resource res=ResourceManagers.getIntance().getResSet().createResource(uri);
					res.getContents().clear();
					res.getContents().add(cat);
					ResourceManagers.getIntance().getCatalogs().add(cat);

				}
			}else {
				if(getUpdateMode()==EditorWindow.update) {
					group.setName(txt.getText());
				}else {
					MechanicDesignGroup group=ParamFactoryImpl.eINSTANCE.createMechanicDesignGroup();
					group.setName(txt.getText());
					group.setPublic(true);
					if(this.cat!=null)
					{
						this.cat.getCategorie().add(group);
					}
					if(this.classe!=null) {
						this.classe.getCategorie().add(group);
					}
				}
			}
			if(cat!=null && !ResourceManagers.getIntance().getCatalogs().contains(cat))
			{
				ResourceManagers.getIntance().getCatalogs().add(cat);
			}
			ResourceManagers.getIntance().saveLibraryResource();
			eventBroker.send("update_DataModel", ResourceManagers.getIntance().getApplication());

		}
		finish();
		return true;
	}

	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name=txt.getText();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom du catalogue est obligatoire.";
		}
		if(isCatalog) {
			String Ownercompany=txtOwner.getText();
			if(Ownercompany==null || Ownercompany.isEmpty()) {
				errorExist=true;
				errorMessage="Le nom de la société est obligatoire.";
			}
		}
		return !errorExist;
	}
	@Override
	protected void cancel() {
	
		
	}
}
