package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.parsley.edit.action.EmfCommandAction;
import org.eclipse.emf.parsley.util.EmfCommandsUtil;
import org.eclipse.swt.widgets.Shell;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.SuperCadProject;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import param.MechanicDesign;
import param.ModelRoot;

public class PreviewModelHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
		
	@Inject
	IEventBroker eventBroker;
	@Execute
	public void execute(Shell shell){
		Object o = selectionService.getSelection("dressing.part.parameters");
		Object parent = selectionService.getSelection("dressing.part.tree"); 
		Object selectedObject = selectionService.getSelection("dressing.part.projectexplorer");
		DesignObject3D parentdesign=null;
		Kitchen kitchen = null;
		if(parent instanceof DesignObject3D)
		{
			parentdesign = (DesignObject3D) parent;
		}
		if(selectedObject instanceof Kitchen) {
			kitchen = (Kitchen) selectedObject;
		}
		//Voire l element de l arbre selectionne
		if(o instanceof MechanicDesign)
		{				        
			try {
				
				DesignObject3D designobject = MechanicDesignCreator.getInstance().constructObject(EcoreUtil.copy((MechanicDesign) o),parentdesign, null);
				if(kitchen != null) {
					kitchen.addElement(designobject);
				}
				eventBroker.post("PREVIEW_MODEL", designobject);
			} catch (DesignException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (GeometricEngineException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}				
		}		
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.parameters");
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof MechanicDesign)
		{	
			return true;
		}
		return false;
	}
}
