package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.Usinage;
import dressing.ui.MechaincDesignEditorWindow;
import param.DirectionDelimiterMap;
import param.MechanicDesign;

public class ModifyHandler {

	@Inject ESelectionService selectionService;
	@Inject EPartService partService;

	@Inject
	IEventBroker eventBroker;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){
		Object o = selectionService.getSelection("dressing.part.tree");
		if(partService.getActivePart().getElementId().contentEquals("dressing.part.tree")) {
			o = selectionService.getSelection("dressing.part.tree");
		}else if(partService.getActivePart().getElementId().contentEquals("dressing.part.palette")) {
			o = selectionService.getSelection("dressing.part.palette");
		}else if(partService.getActivePart().getElementId().contentEquals("dressing.part.projectexplorer")){
			o = selectionService.getSelection("dressing.part.projectexplorer");

		}
		// Voire l element de l arbre selectionne
		if (o instanceof DesignObject3D ) {
			DesignObject3D DesignObject = (DesignObject3D) o;
			if (DesignObject != null ) {

				try {
					MechanicDesign design= DesignObject.getMechanicDesignDefinition();
			    	if(design.isChangeable()) {

						if(DesignObject instanceof Piece2D && !design.getType().equals(param.PieceType.PIECE2D)) {
							DesignObject=DesignObject.getParentdesign();
						}
						DesignObject3D space=DesignObject.getParentdesign();
						boolean isdirectParent=true;
						DirectionDelimiterMap spacedelimeters=null;
						if(space!=null && space.getRootModule()!=null)
						{
							spacedelimeters = ((Space3D) space.getRootModule()).getDependenceController().getChainModel().getDesignsReferences().get(design);
	    					DesignObject3D spaceParent = ((Space3D) space.getRootModule()).getDependenceController().createConstraintSpace(spacedelimeters, space,false);
	    					//make temporary space directPArent for test  purposes
	    					if(spaceParent!=null) {
	    						isdirectParent=false;
	    						space=spaceParent;
	    					}
						}
						
						
						MechaincDesignEditorWindow mechanicDesignWindow=new MechaincDesignEditorWindow(shell,design,false,null, space,DesignObject, spacedelimeters,isdirectParent, MechanicDesignCreator.update);
						mechanicDesignWindow.create();
						mechanicDesignWindow.open();
			    	}else {
			    		MessageDialog.openWarning(shell, "Imposissible de modifier", "Imposissible de modifier le modele séléctionner");
			    	}
				} catch (Exception e) {
					MessageDialog.openError(shell, "Erreur lors du modification du model",
							"Erreur lors du modification du model" + DesignObject.getName());
					e.printStackTrace();
				}
//						}

			}
		}else if( o instanceof MechanicDesign) {
			MechanicDesign design =(MechanicDesign) o;
			MechaincDesignEditorWindow mechanicDesignWindow=new MechaincDesignEditorWindow(shell,design,true,null, null,null, null,true, MechanicDesignCreator.update);
			mechanicDesignWindow.setEventBroker(eventBroker);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();
		}
	
	}
	@CanExecute
	public boolean check()	{
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		//Voire l element de l arbre selectionne
		if(o instanceof DesignObject3D)
		{
			if(o instanceof Usinage)
			{
				return false;
			}
			else
			{
				return true;
			}
		}
		else if(partService.getActivePart().getElementId().contentEquals("dressing.part.palette")) {
			o = selectionService.getSelection("dressing.part.palette");
			if(o!=null && o instanceof MechanicDesign) {
				return true;
			}
		}
		return false;
	}
}
