package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;

import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.ui.ApplicationEditorWindow;
import param.PieceType;

public class AddApplicableWindowHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEventBroker eventBroker;
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		//Voire l element de l arbre selectionne
		if(o instanceof DesignObject3D 
				&& ((DesignObject3D) o).getMechanicDesignDefinition()!=null 
				&&((o instanceof Piece2D && ((DesignObject3D) o).getMechanicDesignDefinition().getType().equals(PieceType.PIECE2D)) ||
						o instanceof Space3D)
				)
		{
			DesignObject3D target =(DesignObject3D)o;
			ApplicationEditorWindow mechanicDesignWindow=new ApplicationEditorWindow(shell,target, eventBroker,
                    selectionService);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();

		}		
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof DesignObject3D)
		{
			return true;
		}	
		return false;
	}
}
