package dressing.config.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.model.DesignException;
import dressing.model.ProjectManager;
import dressing.model.SuperCadClipBoard;
import dressing.ui.ChangeCommandController;
import dressing.ui.RemoveObjectCommand;
import dressing.ui.usinage.HabillageCreator;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.ScreenController;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.ModeledObject;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WallSide;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.room3d.Room3DController;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.ui.ActionItem;
import gdxapp.ui.ObjectMenuList;
import resources.IconsResource;

@Creatable
public class ActionListManager implements EventHandler{
	

	
	public ActionListManager() {}

	@PostConstruct
	public void init() {
		subscribe(SceneEvent.OBJECT_RIGHT_CLICK.name());
	}
	
	@Override
	public void handle(Event event) {
		try {
			Map<String,Object> details = (Map<String, Object>) event.getData();
			var controller = ((AbstractScreen) Scene.game.getScreen()).getController();
			details.put("context", controller);
			List<ActionItem> actions = getActions(details);
			HashMap<String, Object> displayEventDetails = new HashMap<String, Object>();
			displayEventDetails.put("actions", actions);
			displayEventDetails.put("location", details.get("location"));
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.DISPLAY_ACTIONS_MENU.name(), displayEventDetails));
		}catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	
	public List<ActionItem> getActions(Map<String, Object> details) {
		Object target = details.get("source");
		if(target instanceof WallSide) {
			target = ((WallSide) target).getWall();
			details.put("source", target);
		}
		if (target == null) {
			return getActionListOnEmpty(details);
		} else if (target instanceof KitchenElement) {
			return getKitchenElementActions(details);
		} else if (target instanceof Wall) {
			return getActionListOnWall(details);
		} else if (target instanceof GeometryObject) {
			return getActionListOnGeometryObject(details);
		} else if(target instanceof Object3D) {
			return getActionListOn3DObject(details);
		}else if(target instanceof ModeledObject){
			return getActionsOnModeledObject(details);
		}else if(target instanceof WorldObject) {
			return getGenericActions(details);
		}
		else {
			throw new RuntimeException("unsuppoorted model");
		}
	}

	private List<ActionItem> getActionsOnModeledObject(Map<String, Object> details) {
		
		return getGenericActions(details);
	}
	
	/*
	 * return actions on world object delete, hide, copy, paste,modify
	 */
	private List<ActionItem> getGenericActions(Map<String, Object> details){
		final WorldObject target = (WorldObject) details.get("source");
		final ScreenController context = (ScreenController) details.get("context");
		final Vector3 location = (Vector3) details.getOrDefault("location", new Vector3());

		List<ActionItem> actions = new ArrayList<ActionItem>();
		actions.add(new ActionItem(ObjectMenuList.MODIFY, IconsResource.getEditDrawable(),
				() -> EventDriver.getDriver().deliverEvent(new Event(SceneEvent.MODIFY_OBJECT.name(), target)), true,
				"Ctrl+E"));
		actions.add(new ActionItem(ObjectMenuList.HIDE, null,
				() -> EventDriver.getDriver().deliverEvent(new Event(SceneEvent.HIDE_OBJECT.name(), target)), true,
				"Ctrl+H"));
		if (!(context instanceof Room3DController)) {
			Object2D optional = null;
			try {
				optional = (Object2D) context.getObject(target);
			} catch (Exception e) {
				optional = null;
			}
			Object2D target2D = optional;
			if (!SuperCadClipBoard.getContent().isEmpty()) {
				actions.add(getPasteAction(location));
			}
			actions.add(new ActionItem(ObjectMenuList.COPY, IconsResource.getCopyDrawable(), () -> {
				SuperCadClipBoard.setContent(target);
			}, target instanceof KitchenElement, "Ctrl+C"));
			if (target2D != null) {
				actions.add(new ActionItem(ObjectMenuList.AJUSTER_POSITION, IconsResource.getCopyDrawable(), () -> {
					target2D.adjustPosition();
				}, !target.isConstraint(), "SHIFT+P"));
				actions.add(new ActionItem(ObjectMenuList.AJUSTER_ROTATION, IconsResource.getCopyDrawable(), () -> {
					target2D.adjustRotation();
				}, !target.isConstraint(), "SHIFT+R"));
			}
			actions.add(new ActionItem(ObjectMenuList.FREEZE_OBJECT, IconsResource.getFreezeObjectDrawable(),
					() -> target.setMoveable(false), target.isMoveable(), null));
			actions.add(new ActionItem(ObjectMenuList.UNFREEZE_OBJECT, IconsResource.getUnFreezeObjectDrawable(),
					() -> target.setMoveable(true), !target.isMoveable(), null));
		}
		if (context instanceof SurfaceController) {
			SurfaceController surfaceController = (SurfaceController) context;
			actions.add(new ActionItem(ObjectMenuList.FIT_SPACE, IconsResource.getResizeHorizontalDrawable(), () -> {
				Object2D selectedActor = surfaceController.getObject( (WorldObject) GroupSelection.getInstance().getFirstElement());
				surfaceController.fitToPlacebySides(selectedActor, surfaceController.getAttachedActors());
			}, true, "Ctrl+F"));
		}
		actions.add(new ActionItem(ObjectMenuList.DELETE, IconsResource.getRemoveDrawable(), () -> {
			RemoveObjectCommand rmoCmd = new RemoveObjectCommand("delete command", "", target);
			ChangeCommandController.getInstance().addCommand(rmoCmd);
		}, true, "Del"));
		
		return actions;
	}

	public List<ActionItem> getKitchenElementActions(Map<String, Object> details) {
		KitchenElement target = (KitchenElement) details.get("source");
        List<ActionItem> actions = new ArrayList<ActionItem>();
        actions.addAll(getGenericActions(details));
		actions.add(new ActionItem(ObjectMenuList.FINITION, IconsResource.getPaintDrawable(),
				() -> EventDriver.getDriver().deliverEvent(new Event(SceneEvent.EDIT_OBJECT.name(), target)), true,
				"Ctrl+E"));
		actions.add(new ActionItem(ObjectMenuList.HIDE_ELEMENT_FACADE, null,
				() -> showFacadeElement(target, false), true,
				""));
		actions.add(new ActionItem(ObjectMenuList.SHOW_ELEMENT_FACADE, null,
				() -> showFacadeElement(target, true), true,
				""));
		return actions;
	}
	public void showFacadeElement(KitchenElement target,boolean showFacades) {
		target.getDesignObject().hideFacade(showFacades);
		target.setRequireRefrech(true);
		EventDriver.getDriver().deliverEvent(SceneEvent.OBJECT_CHANGED, target);
	}
	public List<ActionItem> getActionListOnWall(Map<String, Object> details) {
		Wall target = (Wall) details.get("source");
		ArrayList<ActionItem> actions = new ArrayList<>();
		actions.add(new ActionItem(ObjectMenuList.MODIFY, IconsResource.getEditDrawable(),
				() -> EventDriver.getDriver().deliverEvent(new Event(SceneEvent.MODIFY_OBJECT.name(), target)), true,
				"Ctrl+E"));
		actions.add(new ActionItem(ObjectMenuList.EDIT, IconsResource.getPaintDrawable(),
				() -> EventDriver.getDriver().deliverEvent(new Event(SceneEvent.EDIT_OBJECT.name(), target)), true,
				"Ctrl+E"));
		actions.add(new ActionItem(ObjectMenuList.DELETE, IconsResource.getRemoveDrawable(), () -> {
			RemoveObjectCommand rmoCmd = new RemoveObjectCommand("delete command", "", target);
			ChangeCommandController.getInstance().addCommand(rmoCmd);
		}, true, "Del"));

		actions.add(new ActionItem(ObjectMenuList.HIDE, null,
				() -> EventDriver.getDriver().deliverEvent(new Event(SceneEvent.HIDE_OBJECT.name(), target)), true,
				"Ctrl+H"));
		return actions;
	}

	public List<ActionItem> getActionListOnGeometryObject(Map<String, Object> details) {
		return getGenericActions(details);
	}
	
	public List<ActionItem> getActionListOn3DObject(Map<String, Object> details){
		List<ActionItem> actions = new ArrayList<ActionItem>();
		Object3D object3D = (Object3D) details.get("source");
		WorldObject worldObject = object3D.getWorldObject();
		ActionItem isolateAction;
		HashMap<String, Object> elementDetails = new HashMap<String, Object>(details);
		elementDetails.put("source", worldObject);
		actions.addAll(getActions(elementDetails));
		isolateAction = new ActionItem(ObjectMenuList.ISOLATE_OBJECT, null,
				() ->EventDriver.getDriver().deliverEvent(new Event(SceneEvent.ISOLATE_OBJECT.name(), object3D))
		, true, null);
		actions.add(isolateAction);
		return actions;
		
	}

	public List<ActionItem> getActionListOnEmpty(Map<String, Object> details) {
		final Vector3 location = getLocationFromDetails(details);
		ArrayList<ActionItem> actions = new ArrayList<>();
		actions.add(new ActionItem(ObjectMenuList.PASTE, IconsResource.getPasteDrawable(), () -> {
			WorldObject element = (WorldObject) SuperCadClipBoard.getContent().get(0).copy();
			Vector3 position = RoomController.getInstance()
					.toRealWorldCoordinate(new Vector3(location.x, location.y, element.getRealWorldPosition().y));
			HashMap<String, Object> eventData = new HashMap<>();
			eventData.put("position", position);
			eventData.put("element", element);

			try {
				ProjectManager.getManager().getCurrentKitchen()
						.addElement(((KitchenElement) element).getDesignObject());
			} catch (DesignException e) {
				e.printStackTrace();
			}

			Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
			EventDriver.getDriver().deliverEvent(pastevent);
		}, SuperCadClipBoard.hasItems(), "Ctrl+V")); // this enables/disables the item

		actions.add(new ActionItem(ObjectMenuList.CREATE_HABILLAGE, null, () -> {
			Display.getDefault().asyncExec(() -> {
				Shell shell = new Shell(Display.getCurrent(), SWT.DIALOG_TRIM);
				HabillageCreator window = new HabillageCreator(shell);
				window.open();
			});
		}, true, null));

		return actions;
	}

	public static Vector3 getLocationFromDetails(Map<String, Object> details) {
		Vector3 loc = null;
		Object tempLocation= details.getOrDefault("location", new Vector3());
		if(tempLocation instanceof Vector3) {
			loc = (Vector3) tempLocation;
		}else if(tempLocation instanceof Vector2) {
			loc =new Vector3((Vector2) tempLocation, 0);
		}
		final Vector3 location =loc;
		return location;
	}

	public ActionItem getPasteAction(final Vector3 position) {
		return new ActionItem(ObjectMenuList.PASTE, IconsResource.getPasteDrawable(), () -> {
			WorldObject element = (WorldObject) SuperCadClipBoard.getContent().get(0).copy();
			HashMap<String, Object> eventData = new HashMap<>();
			eventData.put("position", position);
			eventData.put("element", element);
			Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
			EventDriver.getDriver().deliverEvent(pastevent);
		}, true, "Ctrl+V");
	}


}
