package dressing.cam.model;

import java.util.ArrayList;
import java.util.List;

import com.badlogic.gdx.math.Vector2;

import dressing.model.Trou;
import dressing.model.Usinage;

public class Cercle2D extends CamShape{

	protected double xPos;
	protected double yPos;
	protected double raduis;
	protected double diameter;
	protected double depth;
	protected double zbottom;
	private Trou trou;
	
	
	public Cercle2D(Trou tr, PlanUsinage plan) {
		super(plan, tr);
		this.trou =tr;
		init();
	}
	
	
	public Cercle2D(double xPos, double yPos, double raduis, double diameter, double depth) {
		super();
		this.xPos = xPos;
		this.yPos = yPos;
		this.raduis = raduis;
		this.diameter = diameter;
		this.depth = depth;
		init();
	}

	@Override
	protected void init() {
		this.raduis=this.trou.getDiameter()/2;
		this.diameter=this.trou.getDiameter();
		this.depth=this.trou.getDepth();
		this.zbottom=-this.depth;
		this.xPos=Util.getXcenter(this.trou, this.plan);
		this.yPos=Util.getYcenter(this.trou, this.plan);
	}

	public Cercle2D() {
		super();
		// TODO Auto-generated constructor stub
	}
	public Cercle2D(double xPos2, double yPos2, double raduis2) {
		// TODO Auto-generated constructor stub
	}


	@Override
	public String getGcode() {
		String gcode="";
		double x = getxPos();
		double y = getyPos();
		double p = getZbottom();
		
		gcode += Tool.X_CODE + x + " " + Tool.Y_CODE + y + Tool.END_OF_LINE;
		gcode +=Tool. Z_CODE + p + Tool.END_OF_LINE;
		gcode += Tool.Z_CODE + Tool.Z_OFFSET + Tool.END_OF_LINE;
		return gcode;
	}	

	public Trou getTrou() {
		return trou;
	}

	public void setTrou(Trou trou) {
		this.trou = trou;
	}

	public  double getxPos() {
		return xPos;
	}
	public void setxPos(double xPos) {
		this.xPos = xPos;
	}
	public  double getyPos() {
		return yPos;
	}
	public void setyPos(double yPos) {
		this.yPos = yPos;
	}
	public double getRaduis() {
		return raduis;
	}
	public void setRaduis(double raduis) {
		this.raduis = raduis;
	}
	public double getDiameter() {
		return diameter;
	}
	public void setDiameter(double diameter) {
		this.diameter = diameter;
	}
	public double getDepth() {
		return depth;
	}
	public void setDepth(double depth) {
		this.depth = depth;
	}
	public double getZbottom() {
		return zbottom;
	}
	public void setZbottom(double zbottom) {
		this.zbottom = zbottom;
	}

	@Override
	public Usinage getUsin() {
		return this.getTrou();
	}
	
	public void sort(List<Cercle2D> list) {
		List<Cercle2D> sorted=new ArrayList<Cercle2D>();
		Cercle2D orgin=new Cercle2D(0, 0, 5, 10, 5);
		Cercle2D chosen=list.get(0);
//		while(list.size()>0) {
//			
//		}
	}


	public Vector2 getCenter() {
		// TODO Auto-generated method stub
		 Vector2 center = new Vector2((float) getxPos(),(float) getyPos());
		 return center;
	}
}
