package dressing.cam.exemples;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

class Vector2 {
    double x, y;

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }
}

public class DXFGenerator {

    public static void main(String[] args) {
        Vector2 lineStart = new Vector2(0.0, 0.0);
        Vector2 lineEnd = new Vector2(10.0, 5.0);

        Vector2 circleCenter = new Vector2(15.0, 10.0);
        double circleRadius = 5.0;

        String dxfContent = generateDXFLine(lineStart, lineEnd, "2") +
                            generateDXFCircle(circleCenter, circleRadius, "3");

        // Save the DXF content to a file
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("C:\\Users\\HP\\OneDrive\\Bureau\\marko\\drawing.dxf"))) {
            writer.write(dxfContent);
            System.out.println(dxfContent);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String generateDXFLine(Vector2 startPoint, Vector2 endPoint, String layer) {
        StringBuilder dxfBuilder = new StringBuilder();

        // Line entity
        dxfBuilder.append("0\nLINE\n");
        dxfBuilder.append(String.format("8\n%s\n", layer)); // Layer name
        dxfBuilder.append(String.format("10\n%.6f\n", startPoint.x)); // X-coordinate of start point
        dxfBuilder.append(String.format("20\n%.6f\n", startPoint.y)); // Y-coordinate of start point
        dxfBuilder.append(String.format("11\n%.6f\n", endPoint.x)); // X-coordinate of end point
        dxfBuilder.append(String.format("21\n%.6f\n", endPoint.y)); // Y-coordinate of end point

        return dxfBuilder.toString();
    }

    private static String generateDXFCircle(Vector2 center, double radius, String layer) {
        StringBuilder dxfBuilder = new StringBuilder();

        // Circle entity
        dxfBuilder.append("0\nCIRCLE\n");
        dxfBuilder.append(String.format("8\n%s\n", layer)); // Layer name
        dxfBuilder.append(String.format("10\n%.6f\n", center.x)); // X-coordinate of center
        dxfBuilder.append(String.format("20\n%.6f\n", center.y)); // Y-coordinate of center
        dxfBuilder.append(String.format("40\n%.6f\n", radius)); // Radius

        return dxfBuilder.toString();
    }
}
