/*
 * Decompiled with CFR 0.152.
 */
package org.frs.perspectiveswitcher.tools;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.frs.perspectiveswitcher.tools.IPerspectiveSwitcherControl;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Creatable
public class EPerspectiveSwitcher {
    @Inject
    EModelService modelService;
    @Inject
    IEventBroker eventBroker;
    @Inject
    MWindow window;
    IPerspectiveSwitcherControl control;
    private EventHandler labelHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EPerspectiveSwitcher.this.window == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspective)) {
                return;
            }
            MPerspective perspective = (MPerspective)changedElement;
            if (!perspective.isToBeRendered()) {
                return;
            }
            MWindow perspectiveWindow = (MWindow)perspective.getContext().get(MWindow.class);
            if (EPerspectiveSwitcher.this.window != perspectiveWindow) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            Object newValue = event.getProperty("NewValue");
            EPerspectiveSwitcher.this.control.updateAttributeFor(perspective, attName, newValue);
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EPerspectiveSwitcher.this.window == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspective)) {
                return;
            }
            MPerspective perspective = (MPerspective)changedElement;
            if (!perspective.getParent().isToBeRendered()) {
                return;
            }
            MWindow perspectiveWindow = (MWindow)perspective.getContext().get(MWindow.class);
            if (EPerspectiveSwitcher.this.window != perspectiveWindow) {
                return;
            }
            if (perspective.isToBeRendered()) {
                EPerspectiveSwitcher.this.control.addPerspectiveShortcut(perspective);
            } else {
                EPerspectiveSwitcher.this.control.removePerspectiveShortcut(perspective);
            }
        }
    };
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EPerspectiveSwitcher.this.window == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MPerspectiveStack perspectiveStack = (MPerspectiveStack)changedElement;
            if (!perspectiveStack.isToBeRendered()) {
                return;
            }
            MWindow stackWindow = (MWindow)EPerspectiveSwitcher.this.modelService.getContainingContext((MUIElement)perspectiveStack).get(MWindow.class);
            if (EPerspectiveSwitcher.this.window != stackWindow) {
                return;
            }
            MPerspective selectedElement = (MPerspective)perspectiveStack.getSelectedElement();
            EPerspectiveSwitcher.this.control.setSelectedElement(selectedElement);
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            block7: {
                block6: {
                    if (EPerspectiveSwitcher.this.window == null) {
                        return;
                    }
                    MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
                    if (!(changedElement instanceof MPerspectiveStack)) {
                        return;
                    }
                    MPerspectiveStack perspectiveStack = (MPerspectiveStack)changedElement;
                    if (!perspectiveStack.isToBeRendered()) {
                        return;
                    }
                    MWindow stackWindow = (MWindow)EPerspectiveSwitcher.this.modelService.getContainingContext((MUIElement)perspectiveStack).get(MWindow.class);
                    if (EPerspectiveSwitcher.this.window != stackWindow) {
                        return;
                    }
                    if (!UIEvents.isADD((Event)event)) break block6;
                    for (Object o : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                        MPerspective added = (MPerspective)o;
                        if (!added.isToBeRendered()) continue;
                        EPerspectiveSwitcher.this.control.addPerspectiveShortcut(added);
                    }
                    break block7;
                }
                if (!UIEvents.isREMOVE((Event)event)) break block7;
                for (Object o : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                    MPerspective removed = (MPerspective)o;
                    if (!removed.isToBeRendered()) continue;
                    EPerspectiveSwitcher.this.control.removePerspectiveShortcut(removed);
                }
            }
        }
    };

    void init() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.labelHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.toBeRenderedHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.selectionHandler);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childrenHandler);
    }

    @PreDestroy
    void cleanUp() {
        this.eventBroker.unsubscribe(this.labelHandler);
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
    }

    public void setControlProvider(IPerspectiveSwitcherControl uiControl) {
        if (uiControl == null) {
            this.control = null;
            this.cleanUp();
        } else {
            if (this.control == null) {
                this.init();
            }
            this.control = uiControl;
        }
    }
}

