/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.events.CustomEvent;
import api.events.EventHandler;
import api.events.EventType;
import api.graphics.Camera;
import api.graphics.IDrawable;
import api.graphics.IObjectController;
import api.graphics.ModelInstance;
import api.graphics.ObjectPositioner;
import api.graphics.ObjectRotator;
import api.graphics.Shader;
import api.input.IEventHandler;
import api.input.InputMultiplexer;
import org.eclipse.swt.widgets.Event;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ObjectController
implements IDrawable,
EventHandler,
IEventHandler {
    private ObjectPositioner positioner;
    private ObjectRotator rotator;
    private IObjectController operator;
    private Camera camera;
    private ModelInstance target;
    private Vector3f operationAxis = new Vector3f();

    public ObjectController(Camera camera) {
        this.camera = camera;
        this.create();
        this.subscribeToEvents();
    }

    private void subscribeToEvents() {
        this.subscribe(EventType.TRANSFORM_OP);
    }

    public void create() {
        this.rotator = new ObjectRotator(this.camera);
        this.positioner = new ObjectPositioner(this.camera);
        this.operator = this.positioner;
    }

    @Override
    public void draw(Shader shader, Camera camera) {
        if (this.target != null) {
            this.operator.draw(shader, null);
        }
    }

    public void attachTo(ModelInstance target) {
        this.target = target;
        this.operator.attachTo(target);
        InputMultiplexer.getInstance().insertEventHandler(this, 0);
    }

    public void setMode(OPERATION operation) {
        switch (operation) {
            case TRANSLATE: {
                this.operator = this.positioner;
                break;
            }
            case ROTATE: {
                this.operator = this.rotator;
                break;
            }
            case SCALE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)operation));
            }
        }
    }

    public void detach() {
        InputMultiplexer.getInstance().removeEventHandler(this);
        this.target = null;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setSurfaceTransform(Matrix4f transform) {
    }

    @Override
    public void drawVertices(Camera camera) {
    }

    @Override
    public void drawSilhouette(Camera camera) {
    }

    @Override
    public void handle(CustomEvent event) {
        EventType type = event.getType();
        switch (type) {
            case TRANSFORM_OP: {
                this.handleModeChangeEvent(event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)type));
            }
        }
    }

    private void handleModeChangeEvent(CustomEvent event) {
        try {
            OPERATION op = (OPERATION)((Object)event.getDetail("op"));
            this.setMode(op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ModelInstance getTarget() {
        return this.target;
    }

    public void setTarget(ModelInstance target) {
        if (target == null) {
            this.detach();
        } else {
            this.attachTo(target);
        }
    }

    @Override
    public boolean handle(Event event) {
        return this.operator.handle(event);
    }

    public static enum OPERATION {
        TRANSLATE,
        ROTATE,
        SCALE;

    }
}

