/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.BoundingBox;
import api.graphics.Camera;
import api.graphics.IDrawable;
import api.graphics.Mesh;
import api.graphics.MeshIterator;
import api.graphics.Model;
import api.graphics.RenderingMode;
import api.graphics.Shader;
import api.graphics.Vertex;
import api.graphics.geometry.Triangle;
import java.util.Iterator;
import java.util.List;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ModelInstance
implements IDrawable,
Iterable<Mesh> {
    private Model model;
    private Matrix4f transform;
    private Matrix4f inversTransform;
    private BoundingBox boundingBox;
    private boolean layingSurface;
    private boolean deletable = false;
    private boolean quotable = false;
    private boolean moveable = false;
    private boolean hidden = false;
    private RenderingMode renderingMode = RenderingMode.FACETS;

    public ModelInstance(Model model) {
        this.model = model;
        if (!model.isLoaded()) {
            model.load();
        }
        this.transform = new Matrix4f();
        this.inversTransform = new Matrix4f();
        this.calculateBoundingBox();
    }

    public boolean occupies(Vector3f point) {
        Vector4f modelPoint4 = new Vector4f((Vector3fc)point, 1.0f).mul((Matrix4fc)this.inversTransform);
        Vector3f modelPoint = new Vector3f(modelPoint4.x, modelPoint4.y, modelPoint4.z);
        return this.getBoundingBox().contains(modelPoint, 0.01f);
    }

    private Vertex selectVertex(Vector3f point) {
        return null;
    }

    public Triangle selectFace(Vector3f point) {
        Vector4f modelPoint4 = new Vector4f((Vector3fc)point, 1.0f).mul((Matrix4fc)this.getInversTransform());
        Vector3f modelPoint = new Vector3f(modelPoint4.x, modelPoint4.y, modelPoint4.z);
        for (Mesh mesh : this.model.getMeshes()) {
            Triangle selection = mesh.selectFace(modelPoint);
            if (selection == null) continue;
            return selection;
        }
        return null;
    }

    public List<Triangle> selectFaces(Vector3f point) {
        Vector4f modelPoint4 = new Vector4f((Vector3fc)point, 1.0f).mul((Matrix4fc)this.getInversTransform());
        Vector3f modelPoint = new Vector3f(modelPoint4.x, modelPoint4.y, modelPoint4.z);
        for (Mesh mesh : this.model.getMeshes()) {
            List<Triangle> selection = mesh.selectFaces(modelPoint);
            if (selection == null) continue;
            return selection;
        }
        return null;
    }

    public Mesh selectPart(Vector3f point) {
        Vector4f modelPoint4 = new Vector4f((Vector3fc)point, 1.0f).mul((Matrix4fc)this.inversTransform);
        Vector3f modelPoint = new Vector3f(modelPoint4.x, modelPoint4.y, modelPoint4.z);
        for (Mesh mesh : this) {
            Triangle selection;
            if (mesh.indices == null || (selection = mesh.selectFace(modelPoint)) == null) continue;
            return mesh;
        }
        return null;
    }

    @Override
    public void draw(Shader shader, Camera camera) {
        if (!this.hidden) {
            switch (this.renderingMode) {
                case WIRED_FACETS: {
                    this.drawWired(shader, camera);
                    break;
                }
                case EDGES: {
                    this.drawSilhouette(camera);
                    break;
                }
                default: {
                    this.drawFacets(shader);
                }
            }
        }
    }

    public void drawFacets(Shader shader) {
        if (!this.hidden) {
            for (Mesh mesh : this.model.getMeshes()) {
                mesh.setTransform(new Matrix4f((Matrix4fc)this.transform).mul((Matrix4fc)mesh.getModelTransform()));
                mesh.draw(shader, null);
            }
        }
    }

    @Override
    public void drawSilhouette(Camera camera) {
        if (!this.hidden) {
            for (Mesh mesh : this.model.getMeshes()) {
                mesh.setTransform(new Matrix4f((Matrix4fc)this.transform).mul((Matrix4fc)mesh.getModelTransform()));
                mesh.drawSilhouette(camera);
            }
        }
    }

    public void drawWired(Shader shader, Camera camera) {
        if (!this.hidden) {
            for (Mesh mesh : this.model.getMeshes()) {
                shader.use();
                mesh.setTransform(new Matrix4f((Matrix4fc)this.transform).mul((Matrix4fc)mesh.getModelTransform()));
                mesh.draw(shader, null);
                mesh.drawSilhouette(camera);
            }
        }
    }

    public void drawFaces(Camera camera) {
        if (!this.hidden) {
            for (Mesh mesh : this.model.getMeshes()) {
                mesh.setTransform(new Matrix4f((Matrix4fc)this.transform).mul((Matrix4fc)mesh.getModelTransform()));
                mesh.drawFaces(camera, new Vector3f(1.0f, 0.0f, 0.0f));
            }
        }
    }

    public void drawBoundingBox(Shader shader) {
        shader.setMat4("model", new Matrix4f((Matrix4fc)this.transform).mul((Matrix4fc)this.boundingBox.getTransform()));
        shader.setMat3("normal", new Matrix4f((Matrix4fc)this.transform).normal().get3x3(new Matrix3f()));
        this.boundingBox.draw(shader, null);
    }

    public BoundingBox calculateBoundingBox() {
        this.boundingBox = this.model.calculateBoundingBox();
        return this.boundingBox;
    }

    public void translate(Vector3f translation) {
        this.setTransform(this.transform.translateLocal((Vector3fc)translation));
    }

    public void rotate(float radians, Vector3f axis) {
    }

    public void transform(Matrix4f transform) {
        this.setTransform(transform.mul((Matrix4fc)this.transform));
    }

    public List<Mesh> getMeshes() {
        return this.model.getMeshes();
    }

    public Vector3f getSize() {
        Vector4f size4 = new Vector4f((Vector3fc)this.boundingBox.getSize(), 0.0f).mul((Matrix4fc)this.transform);
        return new Vector3f(size4.x, size4.y, size4.z);
    }

    public Vector3f getCenter() {
        Vector4f center4 = new Vector4f((Vector3fc)this.boundingBox.getCenter(), 1.0f).mul((Matrix4fc)this.transform);
        return new Vector3f(center4.x, center4.y, center4.z);
    }

    public Matrix4f getTransform() {
        return this.transform;
    }

    public void setTransform(Matrix4f transform) {
        this.transform = transform;
        this.transform.invert(this.inversTransform);
    }

    public BoundingBox getBoundingBox() {
        if (this.boundingBox == null) {
            return this.calculateBoundingBox();
        }
        return this.boundingBox;
    }

    public Matrix4f getInversTransform() {
        return this.inversTransform;
    }

    public boolean isLayingSurface() {
        return this.layingSurface;
    }

    public void setLayingSurface(boolean layingSurface) {
        this.layingSurface = layingSurface;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public boolean isQuotable() {
        return this.quotable;
    }

    public void setQuotable(boolean quotable) {
        this.quotable = quotable;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    @Override
    public Iterator<Mesh> iterator() {
        return new MeshIterator(this);
    }

    public List<Vector3f> getVertices() {
        return null;
    }

    @Override
    public void drawVertices(Camera camera) {
        for (Mesh mesh : this.model.getMeshes()) {
            mesh.setTransform(new Matrix4f((Matrix4fc)this.transform).mul((Matrix4fc)mesh.getModelTransform()));
            mesh.drawVertices(camera);
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
    }
}

