<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="text" />

	<xsl:template match="TestCases">

		<xsl:text>	
package model.piece2dcreator;
import org.junit.Test;
import static org.junit.Assert.*;

import dressing.model.DesignException;
import dressing.model.Materiaux;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.model.Separator;
import utils.ParametersUtils;
/**
 * 
 * ce classe de testCases tester tout les possibilité du séparateur dans piece2dCreator
 *
 */
</xsl:text>
		<xsl:text>
public class Piece2dCreatorTestCases extends Checks{
</xsl:text>
		<xsl:for-each select="Function">
			<xsl:variable name="function" select="@name" />

			<xsl:for-each select="TestCase">
				<xsl:text>
	@Test
	public void test_</xsl:text>
				<xsl:value-of select="$function" />
				<xsl:text>_</xsl:text>
				<xsl:value-of select="@id" />
				<xsl:text>()</xsl:text>
				<xsl:text> {
</xsl:text>

				<xsl:variable name="creator"
					select="Has[@name='piece2dCreator']/@value" />
				<xsl:variable name="assert"
					select="Has[@name='assert']/@value" />
				<xsl:for-each select="Input/Var">
				<!--	<xsl:if test ="@value !=''">-->
				
					<xsl:text>    	</xsl:text>
					
					<xsl:value-of select="Has[@name='varType']/@value" />
					<xsl:text> </xsl:text>
					<xsl:value-of select="Has[@name='varName']/@value" />
					<xsl:text> = </xsl:text>
					<xsl:choose>
						<xsl:when test="Has[@name='varEval']">
							<xsl:value-of select="Has[@name='varEval']/@value" />
							<xsl:text>(</xsl:text>
							<xsl:value-of select="@value" />
							<xsl:text>)</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="Has[@name='varType']/@value='String'">
									<xsl:text>"</xsl:text>
									<xsl:value-of select="@value" />
									<xsl:text>"</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@value" />
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>

					</xsl:choose>
					<xsl:text>;
</xsl:text>
					<xsl:if test="Has[@name='varApply']">
						<xsl:text>		</xsl:text>
						<xsl:value-of select="$creator" />
						<xsl:text>.</xsl:text>
						<xsl:value-of select="Has[@name='varApply']/@value" />
						<xsl:text>(</xsl:text>
						<xsl:value-of select="Has[@name='varName']/@value" />
						<xsl:text>);
                        </xsl:text>
					</xsl:if>
					<xsl:text> 
		</xsl:text><xsl:value-of select="$assert" />
						<xsl:text>(</xsl:text>
						<xsl:value-of select="Has[@name='varName']/@value" /> <xsl:text>,</xsl:text>
						<xsl:value-of select="$creator" />
						<xsl:text>.</xsl:text>
						<xsl:value-of select="Has[@name='varApplyget']/@value" />
						<xsl:text>(</xsl:text>						
						<xsl:text>)</xsl:text><xsl:if test="Has[@name='varApplyget']/@value='getSeparationposition'">,ParametersUtils.epsilon</xsl:if>
						<xsl:if test="Has[@name='varApplyget']/@value='getSepRetrait'">,ParametersUtils.epsilon</xsl:if>
						<xsl:if test="Has[@name='varApplyget']/@value='getSepretraitderiere'">,ParametersUtils.epsilon</xsl:if>						
						<xsl:text>);</xsl:text>
						<xsl:text>
</xsl:text>
<!--</xsl:if>-->
				</xsl:for-each>

				<xsl:text>    
		try {
		</xsl:text>
				<xsl:value-of select="$creator" />
				<xsl:text>.</xsl:text>
				<xsl:value-of select="$function" />
				<xsl:text>();</xsl:text>
				<xsl:text>
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	</xsl:text>

				<xsl:text>  
	}
</xsl:text>
			</xsl:for-each>

		</xsl:for-each>
		<xsl:text>}
</xsl:text>
	</xsl:template>

</xsl:stylesheet>
