package supercad.api.dto;

import java.time.ZoneId;
import java.util.Date;
import java.util.UUID;
import org.json.simple.JSONObject;
import dressing.model.SuperCadProject;
import dressing.model.SuperCadProject.ProjectType;

public class CadProjectDTO {
	private UUID id;
	private String name;
	private ProjectType type;
	private Date creationDate;
	private String client;
	private String site;
	private String commercial;
	private String clientNumber;
	
	public CadProjectDTO() {}
	
	public CadProjectDTO(SuperCadProject project) {
		this.id = project.getId();
		this.name = project.getName();
		this.type = project.getType();
		this.creationDate = Date.from(project.getCreationDate().atZone(ZoneId.systemDefault()).toInstant());
		this.client = project.getClient();
		this.site = project.getSite();
		this.commercial = project.getCommercial();
		this.clientNumber = project.getClientNumber();
	}

	
	public UUID getId() {
		return id;
	}
	public void setId(UUID id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public ProjectType getType() {
		return type;
	}
	public void setType(ProjectType type) {
		this.type = type;
	}


	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	public String getClient() {
		return client;
	}
	public void setClient(String client) {
		this.client = client;
	}
	public String getSite() {
		return site;
	}
	public void setSite(String site) {
		this.site = site;
	}
	public String getCommercial() {
		return commercial;
	}
	public void setCommercial(String commercial) {
		this.commercial = commercial;
	}
	public String getClientNumber() {
		return clientNumber;
	}
	public void setClientNumber(String clientNumber) {
		this.clientNumber = clientNumber;
	}
	
	public JSONObject json() {
		JSONObject json = new JSONObject();
		for(var field: this.getClass().getDeclaredFields()) {
			try {
				String getter = "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
				Object value = getClass().getDeclaredMethod(getter, null).invoke(this, null);
				if(value != null)
					json.put(field.getName(), value.toString());
			}catch (Exception e) {
				e.printStackTrace();
				continue;
			}
		}
		return json;
	}
}
