package reporting.htmlReporting;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import dressing.reporting.data.handle.ArticleReport;
import dressing.reporting.data.handle.ProjectCoupe;

public class DevisServlet extends HttpServlet{
	
	
	private static SingleDocKitchenReport report;

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		// Read the JSON data sent from the client
        StringBuilder jsonBuffer = new StringBuilder();
        String line;
        while ((line = req.getReader().readLine()) != null) {
            jsonBuffer.append(line);
        }
        
        JSONParser parser = new JSONParser();
        Object requestBody = null;
        try {
			requestBody = parser.parse(jsonBuffer.toString());
			if(requestBody != null) {
				JSONObject data = (JSONObject) requestBody;
				String ref = (String) data.getOrDefault("reference", "aucun reference");
				String designation = (String) data.getOrDefault("designation", "aucun designation");
				float price = Float.parseFloat( (String) data.getOrDefault("price", "NaN") );
				float remise = Float.parseFloat( (String) data.getOrDefault("remise", "NaN") );
				int qauntity = Integer.parseInt((String) data.getOrDefault("quantity", "1"));
				ArticleReport article = new ArticleReport(designation, ref, qauntity, price, remise, 19, null, false);
				report.getProjectCoupe().addArticle(article);
				report.generate(false);
				report.export(report.getReportDir() + File.separator + "report.html");
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
		System.out.println(String.format("recieveing request %s", requestBody.toString()));

      

        // Do something with the data (e.g., store in database, generate new HTML, etc.)

        // Respond back to the client
        resp.setContentType("application/json");
        resp.getWriter().write("{\"status\": \"success\"}");
	}

	public SingleDocKitchenReport getReport() {
		return DevisServlet.report;
	}

	public static void setReport(SingleDocKitchenReport report) {
		 DevisServlet.report = report;
	}


	
	
}
