package geometry;

import java.util.Vector;

import org.frs.svg.Plane;

import com.badlogic.gdx.math.Vector3;

import gdxapp.fabs3d.Quad;


public class Ray3D {

	private Vector3 origin;
	private Vector3 dir;
	
	public Ray3D(Vector3 origin, Vector3 dir) {
		super();
		this.origin = origin;
		this.dir = dir.cpy().nor();
	}
	
	
	
	public Vector3 intersect(Quad quad) {
		Vector3 intersection = null;
		Vector3[] planePoints =  quad.getVertices();
		Vector3 v0 = planePoints[1].cpy().sub(planePoints[0]);
		Vector3 v1 = planePoints[2].cpy().sub(planePoints[0]);
		if(v1.isOnLine(v0, 0.1f))
			v1 = planePoints[3].cpy().sub(planePoints[0]);
		Vector3 normal = v0.cpy().crs(v1).nor();
		Plane plane = new Plane(planePoints[0].cpy(), normal.cpy());
		float alpha = (plane.getPoint().dot(normal) - origin.dot(normal)) / (dir.dot(normal) + 0.00001f);
		if(alpha != Float.NaN && alpha > 0) {
			intersection = origin.cpy().add(dir.cpy().scl(alpha));
		}
		return intersection;
		
	}
	
	
	
	
	
	//getters and setters
	public Vector3 getOrigin() {
		return origin;
	}
	public void setOrigin(Vector3 origin) {
		this.origin = origin;
	}
	public Vector3 getDir() {
		return dir;
	}
	public void setDir(Vector3 dir) {
		this.dir = dir;
	}
	
	
	public static void main(String...strings) {
		Ray3D ray = new Ray3D(new Vector3(0,0,10), new Vector3(0,0,1));
		Quad quad = new Quad(new Vector3(0 ,0 , 2), new Vector3(-5, 5, 2),
				new Vector3(3, -5, 2), new Vector3(5, 5, 2));
		System.out.println(ray.intersect(quad));
		
	}
	
	
}
