package gdxapp.shapes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer.ShapeType;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Align;

import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.LineObject;
import gdxapp.Commun.ScreenController;
import gdxapp.assets.AssetFont;
import gdxapp.assets.SDFFont;
import gdxapp.quotation.Quotation;
import gdxapp.scenes.Scene;
import gdxapp.screens.wall.SurfaceController;

public class LineSegment extends Actor {
	
	private String description;
	private float[] scale;
	private static ShapeRenderer renderer;
	private static SDFFont font;
	private boolean cut;
	private LineObject line;
	private Vector2 startImage;
	private Vector2 endImage;
	private transient Vector2 directorImage;
	private transient Vector2 normalImage;
	public PropertyChangeListener pcl=new PropertyChangeListener() {
		
		@Override
		public void propertyChange(PropertyChangeEvent arg0) {
			if(arg0.getPropertyName().contentEquals("recalculate")) {
				recalculate();
			}
			
		}
	};
	public LineSegment() {
		super();
		setWidth(0);
		setHeight(0);		
	}
	
	public void recalculate() {
		if(getStart()!=null ) {
			Vector2 end=getEnd()!=null?getEnd():getTmpVertex();
			if(end!=null) {
				startImage=getStart().cpy();
				endImage=end.cpy();
				if(getOffset()!=0.0f)
				{
					startImage.add(getNormal().cpy().scl(getOffset()));
					endImage.add(getNormal().cpy().scl(getOffset()));
				}
				this.directorImage = end.cpy().sub(startImage).nor();
				this.normalImage = new Vector2(-directorImage.y, directorImage.x);
			}
		}
	}
	
	public LineSegment(LineObject line) {
		this();
		this.line = line;
		this.line.addPropertyChangeListener(pcl);
	}

	public LineSegment cpy() {
		LineSegment copy = new LineSegment(getLine());
		copy.setScale(getScale());
		
		if(this.description != null)
			copy.description = new String(this.description);
		return copy;
	}
	
	public boolean contains(Vector2 point) {
		return getLine().contains(point, 1/getScale()[0]);
	}
	public void updateScale() {
		try {
			AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
			ScreenController controller = screen.getController();
			float[] scales = controller.getScales();
			setScale(scales);
			
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	

	
	@Override
	public void draw(Batch batch, float parentAlpha) {
 		updateScale();
		getRenderer().setProjectionMatrix(batch.getProjectionMatrix());
		if(getStart() != null) {
			boolean tmpUsed = false;
			if(getEnd() == null && getTmpVertex() != null) {
				setEnd(getTmpVertex());
				tmpUsed = true;
			}
			if(getEnd() != null) {
				boolean batchInterrupted = false;
		    	if(batch.isDrawing()) {
		    		batch.end();
		    		batchInterrupted = true;
		    	}
		    	getRenderer().begin(ShapeType.Filled);
		    	getRenderer().setColor(getLine().getTmpcolor());
		    	getRenderer().rectLine(getStart().x, getStart().y, getEnd().x, getEnd().y,2);
		    	getRenderer().end();
				startImage=getStart().cpy();
				endImage=getEnd().cpy();
				if( getOffset()!=0.0f) {
					startImage.add(getNormal().cpy().scl(getOffset()));
					endImage.add(getNormal().cpy().scl(getOffset()));
					getRenderer().begin(ShapeType.Filled);
					getRenderer().setColor(getColor());
					getRenderer().rectLine(getStart().x, getStart().y, startImage.x, startImage.y,1);
					getRenderer().rectLine(getEnd().x, getEnd().y, endImage.x, endImage.y,1);
					Vector2 startImage1=startImage.cpy().add(getNormal().cpy().scl(-5)).add(getDirector().cpy().scl(-5));
					Vector2 startImage2=startImage.cpy().add(getNormal().cpy().scl(5)).add(getDirector().cpy().scl(5));
					Vector2 endImage1=endImage.cpy().add(getNormal().cpy().scl(-5)).add(getDirector().cpy().scl(-5));
					Vector2 endImage2=endImage.cpy().add(getNormal().cpy().scl(5)).add(getDirector().cpy().scl(5));

					getRenderer().rectLine(startImage1.x, startImage1.y, startImage2.x, startImage2.y,1);
					getRenderer().rectLine(endImage1.x, endImage1.y, endImage2.x, endImage2.y,1);
					
					getRenderer().setColor(Color.BLUE);

					getRenderer().rectLine(startImage.x, startImage.y, endImage.x, endImage.y,3);
					getRenderer().setColor(getColor());
					getRenderer().end();
					
				}
				Vector2 v0 = new Vector2(startImage.x,startImage.y);
				Vector2 v1 = new Vector2(endImage.x, endImage.y);
				if(getOffset()<0) {
					Vector2 ox=v0;
					v0=v1;
					v1=ox;
					Vector2 ox2=startImage;
					startImage=endImage;
					endImage=ox2;
				}
				Edge e=new Edge(startImage, endImage);
				v0.add(e.getNormal().cpy().scl(10));
				v1.add(e.getNormal().cpy().scl(10));
				Vector2 v2 = new Vector2();
				v2.set(v0.cpy().add( e.getDirector().cpy().scl(getLength() * .5f)).
						add( e.getNormal().cpy().scl(10)));
				float measure = Math.round(getMeasurement() * 1000 +0) ;
				measure/=10;
				measure = Math.round(measure);
				String value =String.valueOf( (int)measure)  + "cm";
				float rotation=e.getRotation();
	            batch.getProjectionMatrix().translate(v2.x,v2.y,0).rotate(Vector3.Z, rotation);
		        batch.begin();
		        getFont().draw(batch,value,0,0,0,Align.center,false, getColor());
		        batch.getProjectionMatrix().rotate(Vector3.Z, -rotation).translate(-v2.x,-v2.y,0);
		        batch.end();
		        if(batchInterrupted)
	            {
		        	batch.begin();
	            }
			}
			if(tmpUsed)
			{
				setEnd(null);
			}
		}
		
	}
	//the rotation of the edge in the x-y plan
	public float getRotation() {
		
		return line.getRotation();
	}
	 public float getLength() {
			
	        return this.line.getLength();
	   }
	
	public Vector2 getDirector() {
		
		return this.line.getDirector();
	}
	
	public Vector2 getNormal() {
		return line.getNormal();
	}
	
	public LineSegment endDrawing() {
		Object listeners = this.getListeners();
		listeners.equals(this);
		return this;
	}
	
	public Vector2 getStart() {
		return line.getStart();
	}
	public void setStart(Vector2 start) {
		this.line.setStart(start);

	}
	public Vector2 getEnd() {
		return line.getEnd();
	}
	public void setEnd(Vector2 end) {
		this.line.setEnd(end);
	}
	public Vector2 getMiddle() {
		return line.getMiddle();
	}
	
	public float getOffset() {
		return line.getOffset();
	}
	
	public Vector2 getTmpVertex() {
		return line.getTmpVertex();
	}
	
	public Color getColor() {
		return line.getColor();
	}
	
	public float getMeasurement() {
		float measure = Float.NaN;
		if(getStart() != null && getEnd() != null) {
			measure= getStart().cpy().sub(getEnd()).scl(getScale()[0], getScale()[1]).len();
		}
		return measure;
	}
	
	
	public float[] getScale() {
		updateScale();
		return scale;
	}
	public void setScale(float[] scale) {
		if (((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {			
			this.scale = scale;
		}else
		{
			this.scale = new float[2];
			this.scale[0]=1f/scale[0];
			this.scale[1]=1f/scale[1];
		}
	}
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	public Vector2 getNearestEdge(Vector2 point) {
		Vector2 nearest = (getStart().dst(point) < getEnd().dst(point))? getStart():getEnd();
		if(nearest.dst(point) * getScale()[0] < 0.5f)
			return nearest;
		return null;
	}
	

	public Vector2 getDirectorImage() {
		return directorImage;
	}
	public void setDirectorImage(Vector2 directorImage) {
		this.directorImage = directorImage;
	}
	public Vector2 getNormalImage() {
		return normalImage;
	}
	public void setNormalImage(Vector2 normalImage) {
		this.normalImage = normalImage;
	}
	
	public Vector2 getStartImage() {
		return startImage;
	}
	public void setStartImage(Vector2 startImage) {
		this.startImage = startImage;
	}
	public Vector2 getEndImage() {
		return endImage;
	}
	public void setEndImage(Vector2 endImage) {
		this.endImage = endImage;
	}
	public static ShapeRenderer getRenderer() {
		if(renderer == null)
			renderer = new ShapeRenderer();
		return renderer;
	}
	public static void setRenderer(ShapeRenderer renderer) {
		LineSegment.renderer = renderer;
	}
	public static SDFFont getFont() {
		if(font == null)
    		font =  AssetFont.getInstance().getFont();
		return font;
	}
	public static void setFont(SDFFont font) {
		LineSegment.font = font;
	}
	public LineObject getLine() {
		return line;
	}
	public void setLine(LineObject line) {
		if(this.line!=null) {
			this.line.removePropertyChangeListener(pcl);
			
		}
		this.line = line;
		this.line.addPropertyChangeListener(pcl);
	}
	@Override
	public void clear() {
		super.clear();
		if(line!=null ) {
			line.removePropertyChangeListener(pcl);
		}
	}
	
	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		this.clear();

	}
	public void setLength(float length, int direction) {
		line.setLength(length, direction);
	}
	public void setLength(float length) {
		setLength(length, 1);
	}
	
	

}
