package dressing.ui.util;

import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Edge;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.Space3DFree;
import dressing.ui.ChangeCommand;
import dressing.ui.ChangeCommandController;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import dressing.ui.parts.GdxPart;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Measure;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import param.MechanicDesign;
import param.MechanicPublicParam;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;

public class MeasureLineWidow extends org.eclipse.jface.window.Window{

	public MeasureLineWidow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}
	public Shell shell;
	public Action runAction;
	public Measure measure;
	Spinner spnLength;
	Listener controlListener=new Listener() {
		
		@Override
		public void handleEvent(Event event) {
			CommandStack command=updateObject();
			
		}
	};
	Listener KeyUpListener= new Listener() {
		
		@Override
		public void handleEvent(Event event) {
			if(event.keyCode==SWT.CR) {
				CommandStack command=updateObject();
				if(command!=null)
				{
					if(((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()!=null)
					{
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(command);
					}

				}
			}
			
		}
	};
	private static MeasureLineWidow instance;
	private Spinner spnOffset;
	private Label lblRetrait;

	public static MeasureLineWidow getInstance() {
	 		synchronized(MeasureLineWidow.class) {
	 			if (instance == null) {
	 				instance = new MeasureLineWidow(GdxPart.parentShell);
	 				instance.create();
	 				instance.constrainShellSize();
	 			}
	 			return instance;
	 		}
	 }
	
	public Action getRunAction() {
		return runAction;
	}

	public void setRunAction(Action runAction) {
		this.runAction = runAction;
	}

	

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}
	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}
	

	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Mesure");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		Composite composite_1 = new Composite(composite, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 266;
		gd_composite_1.heightHint = 62;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(2, false));
		
		Label lblLongeur = new Label(composite_1, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLongeur.setText("Longeur");
		
		spnLength = new Spinner(composite_1, SWT.BORDER);
		spnLength.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnLength.setMaximum(100000000);
		spnLength.setMinimum(-1000000);

		lblRetrait = new Label(composite_1, SWT.NONE);
		lblRetrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRetrait.setText("Retrait");
		
		spnOffset = new Spinner(composite_1, SWT.BORDER);
		spnOffset.setMaximum(1000000);
		spnOffset.setMinimum(-1000000);
		spnOffset.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Composite composite_2 = new Composite(composite, SWT.NONE);
		GridData gd_composite_2 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_2.heightHint = 39;
		composite_2.setLayoutData(gd_composite_2);
		GridLayout gl_composite_2 = new GridLayout(2, false);
		gl_composite_2.horizontalSpacing = 0;
		composite_2.setLayout(gl_composite_2);
		
		Button btnRun = new Button(composite_2, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 31;
		btnRun.setLayoutData(gd_btnRun);
		if(runAction !=null) {
			btnRun.setText(runAction.getText());
		}else {
			btnRun.setText("Terminer");
		}
		Button btnFermer = new Button(composite_2, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 31;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		composite.setTabList(new Control[]{composite_1, composite_2});
		
				btnFermer.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						MeasureLineWidow.this.hide();
					}
					
				});
				btnRun.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						float scale=measure.getLineSegment().getScale()[0];
						float l = MeasureLineWidow.this.spnLength.getSelection();
						l /= 1000;
						l /=scale;
						//implent update logic here
						measure.getLineSegment().setLength(l, 1);
						float offset=MeasureLineWidow.this.spnOffset.getSelection();
						offset/=1000;
						offset /= scale;
						measure.getLine().setOffset(offset);
						if(runAction!=null) {
							runAction.run();
						}
						hide();
					}
				});
		return composite;

	}
	
	public Measure getMeasure() {
		return measure;
		
	}
	public void setMeasure(Measure measure,boolean isOffsetVisible) {
		this.measure = measure;
		if(measure!=null)
		{
			float l=this.measure.getLineSegment().getMeasurement();
			this.spnLength.setSelection(Math.round(l * 1000));
			if(isOffsetVisible) {
				float offset=this.measure.getLine().getOffset() * this.measure.getLineSegment().getScale()[0];
				this.spnOffset.setSelection(Math.round(offset * 1000));
				spnOffset.setVisible(true);
				lblRetrait.setVisible(true);
			}else {
				spnOffset.setVisible(false);
				lblRetrait.setVisible(false);
			}
			
		}
	}
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			MeasureLineWidow.this.shell.setVisible(true);
			MeasureLineWidow.this.shell.setActive();

		}

	}
	public void hide() {
		if(!shell.isDisposed())
		{
			
			MeasureLineWidow.this.shell.setVisible(false);
		}

	}
	public CommandStack updateObject(){
		
		return null;
	}
	public void createController() {
		
	}
	
	
}
