package dressing.ui.usinage;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.util.EdgeConfigWindow;
import dressing.ui.util.MesureWidow;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.assets.AssetsTextures;
import gdxapp.fabs3d.WoodCovering;
import gdxapp.screens.room.RoomController;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Group;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;

import dressing.ui.composite.WoodCoveringCreatorComposite;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.ColorComposite;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.widgets.WidgetFactory;

public class HabillageCreator extends Dialog{
	
	
	private WoodCovering woodCovering;
	
	private Composite container;
	
	public HabillageCreator(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.DIALOG_TRIM | SWT.RESIZE);
		setBlockOnOpen(true);
		woodCovering = new WoodCovering();
		woodCovering.setRealWorldPosition(new Vector3(4,0.01f,4));
		woodCovering.setMaterial(AssetsTextures.getInstance().getMaterial("Bois"));
		create();
		constrainShellSize();
	}
	
	@Override
	protected Control createDialogArea(Composite parent) {
		container.setLayout(new GridLayout(1, false));
		Composite composite = new WoodCoveringCreatorComposite(container, SWT.NONE, woodCovering);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		ControlAdapter adaptor = new ControlAdapter() {
			@Override
			public void controlResized(ControlEvent e) {
				Rectangle area2 = HabillageCreator.this.getShell().getClientArea();
				container.setBounds(area2);
			}
		};
		parent.getShell().addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);
		return composite;
	}
	
	

	
	
	

	@Override
	protected Control createContents(Composite parent) {
		// create the top level composite for the dialog
				GridLayout layout = new GridLayout();
				layout.marginHeight = 0;
				layout.marginWidth = 0;
				layout.verticalSpacing = 0;
				container = new Composite(parent, SWT.FILL);
				applyDialogFont(container);
				// initialize the dialog units
				initializeDialogUnits(container);
				// create the dialog area and button bar
				dialogArea = createDialogArea(container);
				buttonBar = createButtonBar(container);
				buttonBar.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				buttonBar.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));

				return container;
	}



	@Override
	protected boolean isResizable() {
		return true;
	}

	@Override
	protected Point getInitialSize() {
		return new Point(480, 618);
	}

	@Override
	protected void okPressed() {
		ProjectManager.getManager().getCurrentScene().addActor(woodCovering, true);
		super.okPressed();
	}
	
	public void cancel() {
		close();
	}
}
