package dressing.ui.palette;

import org.eclipse.jface.viewers.ITreeContentProvider;

import dressing.model.DesignObject3D;
import dressing.model.ProjectParent;

public class PaletteTreeContentProvider implements ITreeContentProvider {
    @Override
    public boolean hasChildren(Object element) {
    	if(element!=null && element instanceof PaletteGroup)
    	{
    		PaletteGroup obj3d = (PaletteGroup)element;
    		if(obj3d!=null && obj3d.getItems().size()>0)
    		{
    			return true;
    		}
    		return false;
    	}
        return false;
    }

    @Override
    public Object getParent(Object element) {
    	if(element!=null && element instanceof PaletteItem)
    	{
    		PaletteItem obj3d = (PaletteItem)element;
    		return obj3d.getParent();
    	}
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
    	if(inputElement instanceof PaletteProject)
    	{
    		if(((PaletteProject) inputElement).getPalettegroupes()!=null && !((PaletteProject) inputElement).getPalettegroupes().isEmpty())
    		{
    			Object[]  o = ((PaletteProject) inputElement).getPalettegroupes().toArray();
       		 return o;
    		}
    		//ne doit pas etre null
    		Object[] o = new Object[] {};
    		return o;
    	}
    	//ne doit pas etre null
    	Object[] o = new Object[] {};
		return o;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
    	if(parentElement!=null && parentElement instanceof PaletteGroup)
    	{
    		PaletteGroup obj3d = (PaletteGroup)parentElement;
    		return obj3d.getItems().toArray();
    	}
        return null;
    }
}