package dressing.ui.caisson;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

import dressing.model.Piece2D;
import dressing.model.Space3DFree;
import gdxapp.object3d.KitchenElement;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;

public class ElementConfigurerComposite extends Composite {
	
	private KitchenElement element;
	private ListFacadesSettingCmp facadeConfigContainer;
	

	public ElementConfigurerComposite(Composite parent, KitchenElement element) {
		super(parent, SWT.NONE);
		this.element = element;
		setLayout(new GridLayout(2, false));
		
		Composite paramContainer = new Composite(this, SWT.NONE);
		paramContainer.setLayout(new GridLayout(1, false));
		paramContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1));
		
		TabFolder tabFolder = new TabFolder(paramContainer, SWT.NONE);
		GridData gd_tabFolder = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_tabFolder.widthHint = 600;
		tabFolder.setLayoutData(gd_tabFolder);
		tabFolder.setLayout(new GridLayout(1, false));
		TabItem tbtmGneral = new TabItem(tabFolder, SWT.NONE);
		tbtmGneral.setText("Géneral");
		
		TabItem tbtmFaades = new TabItem(tabFolder, SWT.NONE);
		tbtmFaades.setText("Façades");

		facadeConfigContainer = new ListFacadesSettingCmp(tabFolder, element);
		facadeConfigContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		tbtmFaades.setControl(facadeConfigContainer);

		TabItem tbtmPices = new TabItem(tabFolder, SWT.NONE);
		tbtmPices.setText("Piéces");
		
		Composite previewContainer = new Composite(this, SWT.NONE);
		previewContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
	}

	
	
	public void update() {
		facadeConfigContainer.applySetting();
	}
	
}
