package dressing.model;

import java.util.Optional;
import java.util.UUID;

import gdxapp.object3d.KitchenElement;
import param.DesignClasse;
import param.MechanicDesignGroup;
import param.ModelRoot;

public class LibraryInfo {

	private ModelRoot modelRoot;
	
	private DesignClasse kitchenClass;
	
	public static final String BASE_ELEMNT = "60c7fbce-015d-4ffb-9421-4b8f5dc85851";
	
	
	private static LibraryInfo instance;
	
	private LibraryInfo() {
		this.modelRoot = ModelProvider.getModelroot();
		getKitchneDesignClass();
	}
	
	
	public float getBaseCabinetDefaultHeight() {
		float value = .72f;
		try {
			MechanicDesignGroup baseGrp = findDesignGroup(BASE_ELEMNT);
			var mechanicDesign = baseGrp.getMechanicdesign().get(0);
			String param = mechanicDesign.getPublicParam("global.h").getDefaultvalue();
			value = Float.parseFloat(param) / 1000.0f;
			
		}catch (Exception e) {
			System.err.println("failed to retrieve the default height if base element");
			e.printStackTrace();
		}
		return value;
	}

	public static LibraryInfo getInstance() {
		if(instance == null)
			instance = new LibraryInfo();
		return instance;
	}
	
	private void getKitchneDesignClass() {
		var classes = modelRoot.getClasses().getDesignClasse();
		this.kitchenClass =  classes.stream().filter((dc) -> dc.getName().equals("Cuisine")).findFirst().get();
		
	}
	
	public MechanicDesignGroup findDesignGroup(String id) {
		UUID uuid = UUID.fromString(id);
		return kitchenClass.getCategorie().stream().filter((mdg) -> mdg.getId().equals(uuid)).findFirst().get();
	}
	
	
}
